/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel.ensemble;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TargetType;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.ensemble.LenientlyParsedOutputAggregator;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.ensemble.StrictlyParsedOutputAggregator;

public class Exponent
implements StrictlyParsedOutputAggregator,
LenientlyParsedOutputAggregator {
    public static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(Exponent.class);
    public static final ParseField NAME = new ParseField("exponent", new String[0]);
    public static final ParseField WEIGHTS = new ParseField("weights", new String[0]);
    private static final ConstructingObjectParser<Exponent, Void> LENIENT_PARSER = Exponent.createParser(true);
    private static final ConstructingObjectParser<Exponent, Void> STRICT_PARSER = Exponent.createParser(false);
    private final double[] weights;

    private static ConstructingObjectParser<Exponent, Void> createParser(boolean lenient) {
        ConstructingObjectParser parser = new ConstructingObjectParser(NAME.getPreferredName(), lenient, a -> new Exponent((List)a[0]));
        parser.declareDoubleArray(ConstructingObjectParser.optionalConstructorArg(), WEIGHTS);
        return parser;
    }

    public static Exponent fromXContentStrict(XContentParser parser) {
        return (Exponent)STRICT_PARSER.apply(parser, null);
    }

    public static Exponent fromXContentLenient(XContentParser parser) {
        return (Exponent)LENIENT_PARSER.apply(parser, null);
    }

    Exponent() {
        this((List<Double>)null);
    }

    private Exponent(List<Double> weights) {
        this(weights == null ? null : weights.stream().mapToDouble(Double::valueOf).toArray());
    }

    public Exponent(double[] weights) {
        this.weights = weights;
    }

    public Exponent(StreamInput in) throws IOException {
        this.weights = (double[])(in.readBoolean() ? in.readDoubleArray() : null);
    }

    @Override
    public Integer expectedValueSize() {
        return this.weights == null ? null : Integer.valueOf(this.weights.length);
    }

    @Override
    public double[] processValues(double[][] values) {
        Objects.requireNonNull(values, "values must not be null");
        if (this.weights != null && values.length != this.weights.length) {
            throw new IllegalArgumentException("values must be the same length as weights.");
        }
        assert (values[0].length == 1);
        double[] processed = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            processed[i] = this.weights != null ? this.weights[i] * values[i][0] : values[i][0];
        }
        return processed;
    }

    @Override
    public double aggregate(double[] values) {
        Objects.requireNonNull(values, "values must not be null");
        double sum = 0.0;
        for (double val : values) {
            if (!Double.isFinite(val)) continue;
            sum += val;
        }
        return Math.exp(sum);
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    @Override
    public boolean compatibleWith(TargetType targetType) {
        return TargetType.REGRESSION.equals((Object)targetType);
    }

    public String getWriteableName() {
        return NAME.getPreferredName();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.weights != null);
        if (this.weights != null) {
            out.writeDoubleArray(this.weights);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.weights != null) {
            builder.field(WEIGHTS.getPreferredName(), (Object)this.weights);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Exponent that = (Exponent)o;
        return Arrays.equals(this.weights, that.weights);
    }

    public int hashCode() {
        return Arrays.hashCode(this.weights);
    }

    public long ramBytesUsed() {
        long weightSize = this.weights == null ? 0L : RamUsageEstimator.sizeOf((double[])this.weights);
        return SHALLOW_SIZE + weightSize;
    }
}

