/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.ClassificationConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.PredictionFieldType;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.NamedXContentObject;

public class ClassificationConfigUpdate
implements InferenceConfigUpdate,
NamedXContentObject {
    public static final ParseField NAME = ClassificationConfig.NAME;
    public static ClassificationConfigUpdate EMPTY_PARAMS = new ClassificationConfigUpdate(null, null, null, null, null);
    private final Integer numTopClasses;
    private final String topClassesResultsField;
    private final String resultsField;
    private final Integer numTopFeatureImportanceValues;
    private final PredictionFieldType predictionFieldType;
    private static final ObjectParser<Builder, Void> STRICT_PARSER = ClassificationConfigUpdate.createParser(false);

    public static ClassificationConfigUpdate fromMap(Map<String, Object> map) {
        HashMap<String, Object> options = new HashMap<String, Object>(map);
        Integer numTopClasses = (Integer)options.remove(ClassificationConfig.NUM_TOP_CLASSES.getPreferredName());
        String topClassesResultsField = (String)options.remove(ClassificationConfig.TOP_CLASSES_RESULTS_FIELD.getPreferredName());
        String resultsField = (String)options.remove(ClassificationConfig.RESULTS_FIELD.getPreferredName());
        Integer featureImportance = (Integer)options.remove(ClassificationConfig.NUM_TOP_FEATURE_IMPORTANCE_VALUES.getPreferredName());
        String predictionFieldTypeStr = (String)options.remove(ClassificationConfig.PREDICTION_FIELD_TYPE.getPreferredName());
        if (!options.isEmpty()) {
            throw ExceptionsHelper.badRequestException("Unrecognized fields {}.", options.keySet());
        }
        return new ClassificationConfigUpdate(numTopClasses, resultsField, topClassesResultsField, featureImportance, predictionFieldTypeStr == null ? null : PredictionFieldType.fromString(predictionFieldTypeStr));
    }

    public static ClassificationConfigUpdate fromConfig(ClassificationConfig config) {
        return new ClassificationConfigUpdate(config.getNumTopClasses(), config.getResultsField(), config.getTopClassesResultsField(), config.getNumTopFeatureImportanceValues(), config.getPredictionFieldType());
    }

    private static ObjectParser<Builder, Void> createParser(boolean lenient) {
        ObjectParser parser = new ObjectParser(NAME.getPreferredName(), lenient, Builder::new);
        parser.declareInt(Builder::setNumTopClasses, ClassificationConfig.NUM_TOP_CLASSES);
        parser.declareString(Builder::setResultsField, ClassificationConfig.RESULTS_FIELD);
        parser.declareString(Builder::setTopClassesResultsField, ClassificationConfig.TOP_CLASSES_RESULTS_FIELD);
        parser.declareInt(Builder::setNumTopFeatureImportanceValues, ClassificationConfig.NUM_TOP_FEATURE_IMPORTANCE_VALUES);
        parser.declareString((rec$, x$0) -> ((Builder)rec$).setPredictionFieldType(x$0), ClassificationConfig.PREDICTION_FIELD_TYPE);
        return parser;
    }

    public static ClassificationConfigUpdate fromXContentStrict(XContentParser parser) {
        return ((Builder)STRICT_PARSER.apply(parser, null)).build();
    }

    public ClassificationConfigUpdate(Integer numTopClasses, String resultsField, String topClassesResultsField, Integer featureImportance, PredictionFieldType predictionFieldType) {
        this.numTopClasses = numTopClasses;
        this.topClassesResultsField = topClassesResultsField;
        this.resultsField = resultsField;
        if (featureImportance != null && featureImportance < 0) {
            throw new IllegalArgumentException("[" + ClassificationConfig.NUM_TOP_FEATURE_IMPORTANCE_VALUES.getPreferredName() + "] must be greater than or equal to 0");
        }
        this.numTopFeatureImportanceValues = featureImportance;
        this.predictionFieldType = predictionFieldType;
        InferenceConfigUpdate.checkFieldUniqueness(resultsField, topClassesResultsField);
    }

    public ClassificationConfigUpdate(StreamInput in) throws IOException {
        this.numTopClasses = in.readOptionalInt();
        this.topClassesResultsField = in.readOptionalString();
        this.resultsField = in.readOptionalString();
        this.numTopFeatureImportanceValues = in.readOptionalVInt();
        this.predictionFieldType = (PredictionFieldType)in.readOptionalWriteable(PredictionFieldType::fromStream);
    }

    public Integer getNumTopClasses() {
        return this.numTopClasses;
    }

    public String getTopClassesResultsField() {
        return this.topClassesResultsField;
    }

    @Override
    public String getResultsField() {
        return this.resultsField;
    }

    @Override
    public InferenceConfigUpdate.Builder<? extends InferenceConfigUpdate.Builder<?, ?>, ? extends InferenceConfigUpdate> newBuilder() {
        return new Builder().setNumTopClasses(this.numTopClasses).setTopClassesResultsField(this.topClassesResultsField).setResultsField(this.resultsField).setNumTopFeatureImportanceValues(this.numTopFeatureImportanceValues).setPredictionFieldType(this.predictionFieldType);
    }

    public Integer getNumTopFeatureImportanceValues() {
        return this.numTopFeatureImportanceValues;
    }

    public PredictionFieldType getPredictionFieldType() {
        return this.predictionFieldType;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalInt(this.numTopClasses);
        out.writeOptionalString(this.topClassesResultsField);
        out.writeOptionalString(this.resultsField);
        out.writeOptionalVInt(this.numTopFeatureImportanceValues);
        out.writeOptionalWriteable((Writeable)this.predictionFieldType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassificationConfigUpdate that = (ClassificationConfigUpdate)o;
        return Objects.equals(this.numTopClasses, that.numTopClasses) && Objects.equals(this.topClassesResultsField, that.topClassesResultsField) && Objects.equals(this.resultsField, that.resultsField) && Objects.equals(this.numTopFeatureImportanceValues, that.numTopFeatureImportanceValues) && Objects.equals((Object)this.predictionFieldType, (Object)that.predictionFieldType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.numTopClasses, this.topClassesResultsField, this.resultsField, this.numTopFeatureImportanceValues, this.predictionFieldType});
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.numTopClasses != null) {
            builder.field(ClassificationConfig.NUM_TOP_CLASSES.getPreferredName(), this.numTopClasses);
        }
        if (this.topClassesResultsField != null) {
            builder.field(ClassificationConfig.TOP_CLASSES_RESULTS_FIELD.getPreferredName(), this.topClassesResultsField);
        }
        if (this.resultsField != null) {
            builder.field(ClassificationConfig.RESULTS_FIELD.getPreferredName(), this.resultsField);
        }
        if (this.numTopFeatureImportanceValues != null) {
            builder.field(ClassificationConfig.NUM_TOP_FEATURE_IMPORTANCE_VALUES.getPreferredName(), this.numTopFeatureImportanceValues);
        }
        if (this.predictionFieldType != null) {
            builder.field(ClassificationConfig.PREDICTION_FIELD_TYPE.getPreferredName(), this.predictionFieldType.toString());
        }
        builder.endObject();
        return builder;
    }

    public String getWriteableName() {
        return NAME.getPreferredName();
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    @Override
    public InferenceConfig apply(InferenceConfig originalConfig) {
        if (!(originalConfig instanceof ClassificationConfig)) {
            throw ExceptionsHelper.badRequestException("Inference config of type [{}] can not be updated with a inference request of type [{}]", originalConfig.getName(), this.getName());
        }
        ClassificationConfig classificationConfig = (ClassificationConfig)originalConfig;
        if (this.isNoop(classificationConfig)) {
            return originalConfig;
        }
        ClassificationConfig.Builder builder = new ClassificationConfig.Builder(classificationConfig);
        if (this.resultsField != null) {
            builder.setResultsField(this.resultsField);
        }
        if (this.numTopFeatureImportanceValues != null) {
            builder.setNumTopFeatureImportanceValues(this.numTopFeatureImportanceValues);
        }
        if (this.topClassesResultsField != null) {
            builder.setTopClassesResultsField(this.topClassesResultsField);
        }
        if (this.numTopClasses != null) {
            builder.setNumTopClasses(this.numTopClasses);
        }
        if (this.predictionFieldType != null) {
            builder.setPredictionFieldType(this.predictionFieldType);
        }
        return builder.build();
    }

    @Override
    public InferenceConfig toConfig() {
        return this.apply(ClassificationConfig.EMPTY_PARAMS);
    }

    @Override
    public boolean isSupported(InferenceConfig inferenceConfig) {
        return inferenceConfig instanceof ClassificationConfig;
    }

    boolean isNoop(ClassificationConfig originalConfig) {
        return !(this.resultsField != null && !this.resultsField.equals(originalConfig.getResultsField()) || this.numTopFeatureImportanceValues != null && originalConfig.getNumTopFeatureImportanceValues() != this.numTopFeatureImportanceValues.intValue() || this.topClassesResultsField != null && !this.topClassesResultsField.equals(originalConfig.getTopClassesResultsField()) || this.numTopClasses != null && originalConfig.getNumTopClasses() != this.numTopClasses.intValue() || this.predictionFieldType != null && !this.predictionFieldType.equals((Object)originalConfig.getPredictionFieldType()));
    }

    public static class Builder
    implements InferenceConfigUpdate.Builder<Builder, ClassificationConfigUpdate> {
        private Integer numTopClasses;
        private String topClassesResultsField;
        private String resultsField;
        private Integer numTopFeatureImportanceValues;
        private PredictionFieldType predictionFieldType;

        public Builder setNumTopClasses(Integer numTopClasses) {
            this.numTopClasses = numTopClasses;
            return this;
        }

        public Builder setTopClassesResultsField(String topClassesResultsField) {
            this.topClassesResultsField = topClassesResultsField;
            return this;
        }

        @Override
        public Builder setResultsField(String resultsField) {
            this.resultsField = resultsField;
            return this;
        }

        public Builder setNumTopFeatureImportanceValues(Integer numTopFeatureImportanceValues) {
            this.numTopFeatureImportanceValues = numTopFeatureImportanceValues;
            return this;
        }

        public Builder setPredictionFieldType(PredictionFieldType predictionFieldtype) {
            this.predictionFieldType = predictionFieldtype;
            return this;
        }

        private Builder setPredictionFieldType(String predictionFieldType) {
            return this.setPredictionFieldType(PredictionFieldType.fromString(predictionFieldType));
        }

        @Override
        public ClassificationConfigUpdate build() {
            return new ClassificationConfigUpdate(this.numTopClasses, this.resultsField, this.topClassesResultsField, this.numTopFeatureImportanceValues, this.predictionFieldType);
        }
    }
}

