/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference;

import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.license.License;
import org.elasticsearch.xpack.core.common.time.TimeUtils;
import org.elasticsearch.xpack.core.ml.inference.InferenceToXContentCompressor;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelDefinition;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelInput;
import org.elasticsearch.xpack.core.ml.inference.persistence.InferenceIndexConstants;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.LenientlyParsedInferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.StrictlyParsedInferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.metadata.FeatureImportanceBaseline;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.metadata.Hyperparameters;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.metadata.TotalFeatureImportance;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.MlStrings;
import org.elasticsearch.xpack.core.ml.utils.NamedXContentObjectHelper;

public class TrainedModelConfig
implements ToXContentObject,
Writeable {
    public static final String NAME = "trained_model_config";
    public static final int CURRENT_DEFINITION_COMPRESSION_VERSION = 1;
    public static final String DECOMPRESS_DEFINITION = "decompress_definition";
    public static final String TOTAL_FEATURE_IMPORTANCE = "total_feature_importance";
    public static final String FEATURE_IMPORTANCE_BASELINE = "feature_importance_baseline";
    public static final String HYPERPARAMETERS = "hyperparameters";
    public static final String MODEL_ALIASES = "model_aliases";
    private static final String ESTIMATED_HEAP_MEMORY_USAGE_HUMAN = "estimated_heap_memory_usage";
    public static final ParseField MODEL_ID = new ParseField("model_id", new String[0]);
    public static final ParseField CREATED_BY = new ParseField("created_by", new String[0]);
    public static final ParseField VERSION = new ParseField("version", new String[0]);
    public static final ParseField DESCRIPTION = new ParseField("description", new String[0]);
    public static final ParseField CREATE_TIME = new ParseField("create_time", new String[0]);
    public static final ParseField DEFINITION = new ParseField("definition", new String[0]);
    public static final ParseField COMPRESSED_DEFINITION = new ParseField("compressed_definition", new String[0]);
    public static final ParseField TAGS = new ParseField("tags", new String[0]);
    public static final ParseField METADATA = new ParseField("metadata", new String[0]);
    public static final ParseField INPUT = new ParseField("input", new String[0]);
    public static final ParseField ESTIMATED_HEAP_MEMORY_USAGE_BYTES = new ParseField("estimated_heap_memory_usage_bytes", new String[0]);
    public static final ParseField ESTIMATED_OPERATIONS = new ParseField("estimated_operations", new String[0]);
    public static final ParseField LICENSE_LEVEL = new ParseField("license_level", new String[0]);
    public static final ParseField DEFAULT_FIELD_MAP = new ParseField("default_field_map", new String[0]);
    public static final ParseField INFERENCE_CONFIG = new ParseField("inference_config", new String[0]);
    public static final ObjectParser<Builder, Void> LENIENT_PARSER = TrainedModelConfig.createParser(true);
    public static final ObjectParser<Builder, Void> STRICT_PARSER = TrainedModelConfig.createParser(false);
    private final String modelId;
    private final String createdBy;
    private final Version version;
    private final String description;
    private final Instant createTime;
    private final List<String> tags;
    private final Map<String, Object> metadata;
    private final TrainedModelInput input;
    private final long estimatedHeapMemory;
    private final long estimatedOperations;
    private final License.OperationMode licenseLevel;
    private final Map<String, String> defaultFieldMap;
    private final InferenceConfig inferenceConfig;
    private final LazyModelDefinition definition;

    private static ObjectParser<Builder, Void> createParser(boolean ignoreUnknownFields) {
        ObjectParser parser = new ObjectParser(NAME, ignoreUnknownFields, Builder::new);
        parser.declareString(Builder::setModelId, MODEL_ID);
        parser.declareString(Builder::setCreatedBy, CREATED_BY);
        parser.declareString((rec$, x$0) -> ((Builder)rec$).setVersion(x$0), VERSION);
        parser.declareString(Builder::setDescription, DESCRIPTION);
        parser.declareField(Builder::setCreateTime, (p, c) -> TimeUtils.parseTimeFieldToInstant(p, CREATE_TIME.getPreferredName()), CREATE_TIME, ObjectParser.ValueType.VALUE);
        parser.declareStringArray(Builder::setTags, TAGS);
        parser.declareObject(Builder::setMetadata, (p, c) -> p.map(), METADATA);
        parser.declareString((trainedModelConfig, s) -> {}, InferenceIndexConstants.DOC_TYPE);
        parser.declareObject(Builder::setInput, (p, c) -> TrainedModelInput.fromXContent(p, ignoreUnknownFields), INPUT);
        parser.declareLong(Builder::setEstimatedHeapMemory, ESTIMATED_HEAP_MEMORY_USAGE_BYTES);
        parser.declareLong(Builder::setEstimatedOperations, ESTIMATED_OPERATIONS);
        parser.declareObject((rec$, x$0) -> ((Builder)rec$).setLazyDefinition(x$0), (p, c) -> TrainedModelDefinition.fromXContent(p, ignoreUnknownFields), DEFINITION);
        parser.declareString((rec$, x$0) -> ((Builder)rec$).setLazyDefinition(x$0), COMPRESSED_DEFINITION);
        parser.declareString(Builder::setLicenseLevel, LICENSE_LEVEL);
        parser.declareObject(Builder::setDefaultFieldMap, (p, c) -> p.mapStrings(), DEFAULT_FIELD_MAP);
        parser.declareNamedObject(Builder::setInferenceConfig, (p, c, n) -> ignoreUnknownFields ? (InferenceConfig)p.namedObject(LenientlyParsedInferenceConfig.class, n, null) : (InferenceConfig)p.namedObject(StrictlyParsedInferenceConfig.class, n, null), INFERENCE_CONFIG);
        return parser;
    }

    public static Builder fromXContent(XContentParser parser, boolean lenient) throws IOException {
        return lenient ? (Builder)LENIENT_PARSER.parse(parser, null) : (Builder)STRICT_PARSER.parse(parser, null);
    }

    TrainedModelConfig(String modelId, String createdBy, Version version, String description, Instant createTime, LazyModelDefinition definition, List<String> tags, Map<String, Object> metadata, TrainedModelInput input, Long estimatedHeapMemory, Long estimatedOperations, String licenseLevel, Map<String, String> defaultFieldMap, InferenceConfig inferenceConfig) {
        this.modelId = ExceptionsHelper.requireNonNull(modelId, MODEL_ID);
        this.createdBy = ExceptionsHelper.requireNonNull(createdBy, CREATED_BY);
        this.version = ExceptionsHelper.requireNonNull(version, VERSION);
        this.createTime = Instant.ofEpochMilli(ExceptionsHelper.requireNonNull(createTime, CREATE_TIME).toEpochMilli());
        this.definition = definition;
        this.description = description;
        this.tags = Collections.unmodifiableList(ExceptionsHelper.requireNonNull(tags, TAGS));
        this.metadata = metadata == null ? null : Collections.unmodifiableMap(metadata);
        this.input = ExceptionsHelper.requireNonNull(input, INPUT);
        if (ExceptionsHelper.requireNonNull(estimatedHeapMemory, ESTIMATED_HEAP_MEMORY_USAGE_BYTES) < 0L) {
            throw new IllegalArgumentException("[" + ESTIMATED_HEAP_MEMORY_USAGE_BYTES.getPreferredName() + "] must be greater than or equal to 0");
        }
        this.estimatedHeapMemory = estimatedHeapMemory;
        if (ExceptionsHelper.requireNonNull(estimatedOperations, ESTIMATED_OPERATIONS) < 0L) {
            throw new IllegalArgumentException("[" + ESTIMATED_OPERATIONS.getPreferredName() + "] must be greater than or equal to 0");
        }
        this.estimatedOperations = estimatedOperations;
        this.licenseLevel = License.OperationMode.parse(ExceptionsHelper.requireNonNull(licenseLevel, LICENSE_LEVEL));
        this.defaultFieldMap = defaultFieldMap == null ? null : Collections.unmodifiableMap(defaultFieldMap);
        this.inferenceConfig = inferenceConfig;
    }

    public TrainedModelConfig(StreamInput in) throws IOException {
        this.modelId = in.readString();
        this.createdBy = in.readString();
        this.version = Version.readVersion((StreamInput)in);
        this.description = in.readOptionalString();
        this.createTime = in.readInstant();
        this.definition = (LazyModelDefinition)in.readOptionalWriteable(LazyModelDefinition::fromStreamInput);
        this.tags = Collections.unmodifiableList(in.readList(StreamInput::readString));
        this.metadata = in.readMap();
        this.input = new TrainedModelInput(in);
        this.estimatedHeapMemory = in.readVLong();
        this.estimatedOperations = in.readVLong();
        this.licenseLevel = License.OperationMode.parse(in.readString());
        this.defaultFieldMap = in.getVersion().onOrAfter(Version.V_7_7_0) ? (in.readBoolean() ? Collections.unmodifiableMap(in.readMap(StreamInput::readString, StreamInput::readString)) : null) : null;
        this.inferenceConfig = in.getVersion().onOrAfter(Version.V_7_8_0) ? (InferenceConfig)in.readOptionalNamedWriteable(InferenceConfig.class) : null;
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Version getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public Instant getCreateTime() {
        return this.createTime;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public Map<String, String> getDefaultFieldMap() {
        return this.defaultFieldMap;
    }

    @Nullable
    public InferenceConfig getInferenceConfig() {
        return this.inferenceConfig;
    }

    @Nullable
    public String getCompressedDefinition() throws IOException {
        if (this.definition == null) {
            return null;
        }
        return this.definition.getCompressedString();
    }

    public void clearCompressed() {
        this.definition.compressedString = null;
    }

    public TrainedModelConfig ensureParsedDefinition(NamedXContentRegistry xContentRegistry) throws IOException {
        if (this.definition == null) {
            return null;
        }
        this.definition.ensureParsedDefinition(xContentRegistry);
        return this;
    }

    public TrainedModelConfig ensureParsedDefinitionUnsafe(NamedXContentRegistry xContentRegistry) throws IOException {
        if (this.definition == null) {
            return null;
        }
        this.definition.ensureParsedDefinitionUnsafe(xContentRegistry);
        return this;
    }

    @Nullable
    public TrainedModelDefinition getModelDefinition() {
        if (this.definition == null) {
            return null;
        }
        return this.definition.parsedDefinition;
    }

    public TrainedModelInput getInput() {
        return this.input;
    }

    public static Builder builder() {
        return new Builder();
    }

    public long getEstimatedHeapMemory() {
        return this.estimatedHeapMemory;
    }

    public long getEstimatedOperations() {
        return this.estimatedOperations;
    }

    public License.OperationMode getLicenseLevel() {
        return this.licenseLevel;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.modelId);
        out.writeString(this.createdBy);
        Version.writeVersion((Version)this.version, (StreamOutput)out);
        out.writeOptionalString(this.description);
        out.writeInstant(this.createTime);
        out.writeOptionalWriteable((Writeable)this.definition);
        out.writeCollection(this.tags, StreamOutput::writeString);
        out.writeMap(this.metadata);
        this.input.writeTo(out);
        out.writeVLong(this.estimatedHeapMemory);
        out.writeVLong(this.estimatedOperations);
        out.writeString(this.licenseLevel.description());
        if (out.getVersion().onOrAfter(Version.V_7_7_0)) {
            if (this.defaultFieldMap != null) {
                out.writeBoolean(true);
                out.writeMap(this.defaultFieldMap, StreamOutput::writeString, StreamOutput::writeString);
            } else {
                out.writeBoolean(false);
            }
        }
        if (out.getVersion().onOrAfter(Version.V_7_8_0)) {
            out.writeOptionalNamedWriteable((NamedWriteable)this.inferenceConfig);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(MODEL_ID.getPreferredName(), this.modelId);
        if (!params.paramAsBoolean("exclude_generated", false)) {
            builder.field(CREATED_BY.getPreferredName(), this.createdBy);
            builder.field(VERSION.getPreferredName(), this.version.toString());
            builder.timeField(CREATE_TIME.getPreferredName(), CREATE_TIME.getPreferredName() + "_string", this.createTime.toEpochMilli());
            builder.humanReadableField(ESTIMATED_HEAP_MEMORY_USAGE_BYTES.getPreferredName(), ESTIMATED_HEAP_MEMORY_USAGE_HUMAN, (Object)ByteSizeValue.ofBytes((long)this.estimatedHeapMemory));
            builder.field(ESTIMATED_OPERATIONS.getPreferredName(), this.estimatedOperations);
            builder.field(LICENSE_LEVEL.getPreferredName(), this.licenseLevel.description());
        }
        if (this.description != null) {
            builder.field(DESCRIPTION.getPreferredName(), this.description);
        }
        if (!params.paramAsBoolean("for_internal_storage", false) && this.definition != null) {
            if (params.paramAsBoolean(DECOMPRESS_DEFINITION, false)) {
                builder.field(DEFINITION.getPreferredName(), (ToXContent)this.definition);
            } else {
                builder.field(COMPRESSED_DEFINITION.getPreferredName(), this.definition.getCompressedString());
            }
        }
        builder.field(TAGS.getPreferredName(), this.tags);
        if (this.metadata != null) {
            builder.field(METADATA.getPreferredName(), this.metadata);
        }
        if (params.paramAsBoolean("for_internal_storage", false)) {
            builder.field(InferenceIndexConstants.DOC_TYPE.getPreferredName(), NAME);
        }
        builder.field(INPUT.getPreferredName(), (ToXContent)this.input);
        if (this.defaultFieldMap != null && !this.defaultFieldMap.isEmpty()) {
            builder.field(DEFAULT_FIELD_MAP.getPreferredName(), this.defaultFieldMap);
        }
        if (this.inferenceConfig != null) {
            NamedXContentObjectHelper.writeNamedObject(builder, params, INFERENCE_CONFIG.getPreferredName(), this.inferenceConfig);
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrainedModelConfig that = (TrainedModelConfig)o;
        return Objects.equals(this.modelId, that.modelId) && Objects.equals(this.createdBy, that.createdBy) && Objects.equals(this.version, that.version) && Objects.equals(this.description, that.description) && Objects.equals(this.createTime, that.createTime) && Objects.equals(this.definition, that.definition) && Objects.equals(this.tags, that.tags) && Objects.equals(this.input, that.input) && Objects.equals(this.estimatedHeapMemory, that.estimatedHeapMemory) && Objects.equals(this.estimatedOperations, that.estimatedOperations) && Objects.equals((Object)this.licenseLevel, (Object)that.licenseLevel) && Objects.equals(this.defaultFieldMap, that.defaultFieldMap) && Objects.equals(this.inferenceConfig, that.inferenceConfig) && Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.modelId, this.createdBy, this.version, this.createTime, this.definition, this.description, this.tags, this.metadata, this.estimatedHeapMemory, this.estimatedOperations, this.input, this.licenseLevel, this.inferenceConfig, this.defaultFieldMap});
    }

    public static class LazyModelDefinition
    implements ToXContentObject,
    Writeable {
        private String compressedString;
        private TrainedModelDefinition parsedDefinition;

        public static LazyModelDefinition fromParsedDefinition(TrainedModelDefinition definition) {
            return new LazyModelDefinition(null, definition);
        }

        public static LazyModelDefinition fromCompressedString(String compressedString) {
            return new LazyModelDefinition(compressedString, null);
        }

        public static LazyModelDefinition fromStreamInput(StreamInput input) throws IOException {
            return new LazyModelDefinition(input.readString(), null);
        }

        private LazyModelDefinition(LazyModelDefinition definition) {
            if (definition != null) {
                this.compressedString = definition.compressedString;
                this.parsedDefinition = definition.parsedDefinition;
            }
        }

        private LazyModelDefinition(String compressedString, TrainedModelDefinition trainedModelDefinition) {
            if (compressedString == null && trainedModelDefinition == null) {
                throw new IllegalArgumentException("unexpected null model definition");
            }
            this.compressedString = compressedString;
            this.parsedDefinition = trainedModelDefinition;
        }

        public void ensureParsedDefinition(NamedXContentRegistry xContentRegistry) throws IOException {
            if (this.parsedDefinition == null) {
                this.parsedDefinition = (TrainedModelDefinition)InferenceToXContentCompressor.inflate(this.compressedString, parser -> TrainedModelDefinition.fromXContent(parser, true).build(), xContentRegistry);
            }
        }

        public String getCompressedString() throws IOException {
            if (this.compressedString == null) {
                this.compressedString = InferenceToXContentCompressor.deflate(this.parsedDefinition);
            }
            return this.compressedString;
        }

        private void ensureParsedDefinitionUnsafe(NamedXContentRegistry xContentRegistry) throws IOException {
            if (this.parsedDefinition == null) {
                this.parsedDefinition = (TrainedModelDefinition)InferenceToXContentCompressor.inflateUnsafe(this.compressedString, parser -> TrainedModelDefinition.fromXContent(parser, true).build(), xContentRegistry);
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.getCompressedString());
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.parsedDefinition != null) {
                return this.parsedDefinition.toXContent(builder, params);
            }
            Map<String, Object> map = InferenceToXContentCompressor.inflateToMap(this.compressedString);
            return builder.map(map);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LazyModelDefinition that = (LazyModelDefinition)o;
            return Objects.equals(this.compressedString, that.compressedString) && Objects.equals(this.parsedDefinition, that.parsedDefinition);
        }

        public int hashCode() {
            return Objects.hash(this.compressedString, this.parsedDefinition);
        }
    }

    public static class Builder {
        private String modelId;
        private String createdBy;
        private Version version;
        private String description;
        private Instant createTime;
        private List<String> tags = Collections.emptyList();
        private Map<String, Object> metadata;
        private TrainedModelInput input;
        private Long estimatedHeapMemory;
        private Long estimatedOperations;
        private LazyModelDefinition definition;
        private String licenseLevel;
        private Map<String, String> defaultFieldMap;
        private InferenceConfig inferenceConfig;

        public Builder() {
        }

        public Builder(TrainedModelConfig config) {
            this.modelId = config.getModelId();
            this.createdBy = config.getCreatedBy();
            this.version = config.getVersion();
            this.createTime = config.getCreateTime();
            this.definition = config.definition == null ? null : new LazyModelDefinition(config.definition);
            this.description = config.getDescription();
            this.tags = config.getTags();
            this.metadata = config.getMetadata() == null ? null : new HashMap<String, Object>(config.getMetadata());
            this.input = config.getInput();
            this.estimatedOperations = config.estimatedOperations;
            this.estimatedHeapMemory = config.estimatedHeapMemory;
            this.licenseLevel = config.licenseLevel.description();
            this.defaultFieldMap = config.defaultFieldMap == null ? null : new HashMap(config.defaultFieldMap);
            this.inferenceConfig = config.inferenceConfig;
        }

        public Builder setModelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public String getModelId() {
            return this.modelId;
        }

        public Builder setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public Builder setVersion(Version version) {
            this.version = version;
            return this;
        }

        private Builder setVersion(String version) {
            return this.setVersion(Version.fromString((String)version));
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setCreateTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public Builder setTags(List<String> tags) {
            this.tags = ExceptionsHelper.requireNonNull(tags, TAGS);
            return this;
        }

        public Builder setMetadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder setFeatureImportance(List<TotalFeatureImportance> totalFeatureImportance) {
            if (totalFeatureImportance == null) {
                return this;
            }
            return this.addToMetadata(TrainedModelConfig.TOTAL_FEATURE_IMPORTANCE, totalFeatureImportance.stream().map(TotalFeatureImportance::asMap).collect(Collectors.toList()));
        }

        public Builder setBaselineFeatureImportance(FeatureImportanceBaseline featureImportanceBaseline) {
            if (featureImportanceBaseline == null) {
                return this;
            }
            return this.addToMetadata(TrainedModelConfig.FEATURE_IMPORTANCE_BASELINE, featureImportanceBaseline.asMap());
        }

        public Builder setHyperparameters(List<Hyperparameters> hyperparameters) {
            if (hyperparameters == null) {
                return this;
            }
            return this.addToMetadata(TrainedModelConfig.HYPERPARAMETERS, hyperparameters.stream().map(Hyperparameters::asMap).collect(Collectors.toList()));
        }

        public Builder setModelAliases(Set<String> modelAliases) {
            if (modelAliases == null || modelAliases.isEmpty()) {
                return this;
            }
            return this.addToMetadata(TrainedModelConfig.MODEL_ALIASES, modelAliases.stream().sorted().collect(Collectors.toList()));
        }

        private Builder addToMetadata(String fieldName, Object value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, Object>();
            }
            this.metadata.put(fieldName, value);
            return this;
        }

        public Builder setParsedDefinition(TrainedModelDefinition.Builder definition) {
            if (definition == null) {
                return this;
            }
            this.definition = LazyModelDefinition.fromParsedDefinition(definition.build());
            return this;
        }

        public Builder setDefinitionFromString(String definitionFromString) {
            if (definitionFromString == null) {
                return this;
            }
            this.definition = LazyModelDefinition.fromCompressedString(definitionFromString);
            return this;
        }

        public Builder clearDefinition() {
            this.definition = null;
            return this;
        }

        private Builder setLazyDefinition(TrainedModelDefinition.Builder parsedTrainedModel) {
            if (parsedTrainedModel == null) {
                return this;
            }
            if (this.definition != null) {
                throw new IllegalArgumentException(new ParameterizedMessage("both [{}] and [{}] cannot be set.", (Object)COMPRESSED_DEFINITION.getPreferredName(), (Object)DEFINITION.getPreferredName()).getFormattedMessage());
            }
            this.definition = LazyModelDefinition.fromParsedDefinition(parsedTrainedModel.build());
            return this;
        }

        private Builder setLazyDefinition(String compressedString) {
            if (compressedString == null) {
                return this;
            }
            if (this.definition != null) {
                throw new IllegalArgumentException(new ParameterizedMessage("both [{}] and [{}] cannot be set.", (Object)COMPRESSED_DEFINITION.getPreferredName(), (Object)DEFINITION.getPreferredName()).getFormattedMessage());
            }
            this.definition = LazyModelDefinition.fromCompressedString(compressedString);
            return this;
        }

        public Builder setInput(TrainedModelInput input) {
            this.input = input;
            return this;
        }

        public Builder setEstimatedHeapMemory(long estimatedHeapMemory) {
            this.estimatedHeapMemory = estimatedHeapMemory;
            return this;
        }

        public Builder setEstimatedOperations(long estimatedOperations) {
            this.estimatedOperations = estimatedOperations;
            return this;
        }

        public Builder setLicenseLevel(String licenseLevel) {
            this.licenseLevel = licenseLevel;
            return this;
        }

        public Builder setDefaultFieldMap(Map<String, String> defaultFieldMap) {
            this.defaultFieldMap = defaultFieldMap;
            return this;
        }

        public Builder setInferenceConfig(InferenceConfig inferenceConfig) {
            this.inferenceConfig = inferenceConfig;
            return this;
        }

        public Builder validate() {
            return this.validate(false);
        }

        public Builder validate(boolean forCreation) {
            List badTags;
            ActionRequestValidationException validationException = null;
            if (this.definition == null) {
                validationException = ValidateActions.addValidationError((String)("[" + DEFINITION.getPreferredName() + "] must not be null."), validationException);
            }
            if (this.modelId == null) {
                validationException = ValidateActions.addValidationError((String)("[" + MODEL_ID.getPreferredName() + "] must not be null."), (ActionRequestValidationException)validationException);
            }
            if (this.inferenceConfig == null && forCreation) {
                validationException = ValidateActions.addValidationError((String)("[" + INFERENCE_CONFIG.getPreferredName() + "] must not be null."), (ActionRequestValidationException)validationException);
            }
            if (this.modelId != null && !MlStrings.isValidId(this.modelId)) {
                validationException = ValidateActions.addValidationError((String)Messages.getMessage("Invalid {0}; ''{1}'' can contain lowercase alphanumeric (a-z and 0-9), hyphens or underscores; must start and end with alphanumeric", MODEL_ID.getPreferredName(), this.modelId), (ActionRequestValidationException)validationException);
            }
            if (this.modelId != null && !MlStrings.hasValidLengthForId(this.modelId)) {
                validationException = ValidateActions.addValidationError((String)Messages.getMessage("Invalid {0}; ''{1}'' cannot contain more than {2} characters.", MODEL_ID.getPreferredName(), this.modelId, 64), (ActionRequestValidationException)validationException);
            }
            if (!(badTags = this.tags.stream().filter(tag -> !(MlStrings.isValidId(tag) && MlStrings.hasValidLengthForId(tag))).collect(Collectors.toList())).isEmpty()) {
                validationException = ValidateActions.addValidationError((String)Messages.getMessage("Invalid tags {0}; must only can contain lowercase alphanumeric (a-z and 0-9), hyphens or underscores, must start and end with alphanumeric, and must be less than {1} characters.", badTags, 64), (ActionRequestValidationException)validationException);
            }
            for (String tag2 : this.tags) {
                if (!tag2.equals(this.modelId)) continue;
                validationException = ValidateActions.addValidationError((String)"none of the tags must equal the model_id", (ActionRequestValidationException)validationException);
                break;
            }
            if (this.input != null && this.input.getFieldNames().isEmpty()) {
                validationException = ValidateActions.addValidationError((String)"[input.field_names] must not be empty", (ActionRequestValidationException)validationException);
            }
            if (this.input != null && this.input.getFieldNames().stream().filter(s -> s.contains(".")).flatMap(s -> Arrays.stream(Strings.delimitedListToStringArray((String)s, (String)"."))).anyMatch(String::isEmpty)) {
                validationException = ValidateActions.addValidationError((String)"[input.field_names] must only contain valid dot delimited field names", (ActionRequestValidationException)validationException);
            }
            if (forCreation) {
                validationException = Builder.checkIllegalSetting(this.version, VERSION.getPreferredName(), validationException);
                validationException = Builder.checkIllegalSetting(this.createdBy, CREATED_BY.getPreferredName(), validationException);
                validationException = Builder.checkIllegalSetting(this.createTime, CREATE_TIME.getPreferredName(), validationException);
                validationException = Builder.checkIllegalSetting(this.estimatedHeapMemory, ESTIMATED_HEAP_MEMORY_USAGE_BYTES.getPreferredName(), validationException);
                validationException = Builder.checkIllegalSetting(this.estimatedOperations, ESTIMATED_OPERATIONS.getPreferredName(), validationException);
                validationException = Builder.checkIllegalSetting(this.licenseLevel, LICENSE_LEVEL.getPreferredName(), validationException);
                if (this.metadata != null) {
                    validationException = Builder.checkIllegalSetting(this.metadata.get(TrainedModelConfig.TOTAL_FEATURE_IMPORTANCE), METADATA.getPreferredName() + "." + TrainedModelConfig.TOTAL_FEATURE_IMPORTANCE, validationException);
                    validationException = Builder.checkIllegalSetting(this.metadata.get(TrainedModelConfig.MODEL_ALIASES), METADATA.getPreferredName() + "." + TrainedModelConfig.MODEL_ALIASES, validationException);
                }
            }
            if (validationException != null) {
                throw validationException;
            }
            return this;
        }

        private static ActionRequestValidationException checkIllegalSetting(Object value, String setting, ActionRequestValidationException validationException) {
            if (value != null) {
                return ValidateActions.addValidationError((String)("illegal to set [" + setting + "] at inference model creation"), (ActionRequestValidationException)validationException);
            }
            return validationException;
        }

        public TrainedModelConfig build() {
            return new TrainedModelConfig(this.modelId, this.createdBy == null ? "user" : this.createdBy, this.version == null ? Version.CURRENT : this.version, this.description, this.createTime == null ? Instant.now() : this.createTime, this.definition, this.tags, this.metadata, this.input, this.estimatedHeapMemory == null ? 0L : this.estimatedHeapMemory, this.estimatedOperations == null ? 0L : this.estimatedOperations, this.licenseLevel == null ? License.OperationMode.PLATINUM.description() : this.licenseLevel, this.defaultFieldMap, this.inferenceConfig);
        }
    }
}

