/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.evaluation;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;

public final class EvaluationFields {
    public static final ParseField ACTUAL_FIELD = new ParseField("actual_field", new String[0]);
    public static final ParseField PREDICTED_FIELD = new ParseField("predicted_field", new String[0]);
    public static final ParseField TOP_CLASSES_FIELD = new ParseField("top_classes_field", new String[0]);
    public static final ParseField PREDICTED_CLASS_FIELD = new ParseField("predicted_class_field", new String[0]);
    public static final ParseField PREDICTED_PROBABILITY_FIELD = new ParseField("predicted_probability_field", new String[0]);
    private final String actualField;
    private final String predictedField;
    private final String topClassesField;
    private final String predictedClassField;
    private final String predictedProbabilityField;
    private final boolean predictedProbabilityFieldNested;

    public EvaluationFields(@Nullable String actualField, @Nullable String predictedField, @Nullable String topClassesField, @Nullable String predictedClassField, @Nullable String predictedProbabilityField, boolean predictedProbabilityFieldNested) {
        this.actualField = actualField;
        this.predictedField = predictedField;
        this.topClassesField = topClassesField;
        this.predictedClassField = predictedClassField;
        this.predictedProbabilityField = predictedProbabilityField;
        this.predictedProbabilityFieldNested = predictedProbabilityFieldNested;
    }

    public String getActualField() {
        return this.actualField;
    }

    public String getPredictedField() {
        return this.predictedField;
    }

    public String getTopClassesField() {
        return this.topClassesField;
    }

    public String getPredictedClassField() {
        return this.predictedClassField;
    }

    public String getPredictedProbabilityField() {
        return this.predictedProbabilityField;
    }

    public boolean isPredictedProbabilityFieldNested() {
        return this.predictedProbabilityFieldNested;
    }

    public List<Tuple<String, String>> listPotentiallyRequiredFields() {
        return Arrays.asList(Tuple.tuple((Object)ACTUAL_FIELD.getPreferredName(), (Object)this.actualField), Tuple.tuple((Object)PREDICTED_FIELD.getPreferredName(), (Object)this.predictedField), Tuple.tuple((Object)TOP_CLASSES_FIELD.getPreferredName(), (Object)this.topClassesField), Tuple.tuple((Object)PREDICTED_CLASS_FIELD.getPreferredName(), (Object)this.predictedClassField), Tuple.tuple((Object)PREDICTED_PROBABILITY_FIELD.getPreferredName(), (Object)this.predictedProbabilityField));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EvaluationFields that = (EvaluationFields)o;
        return Objects.equals(that.actualField, this.actualField) && Objects.equals(that.predictedField, this.predictedField) && Objects.equals(that.topClassesField, this.topClassesField) && Objects.equals(that.predictedClassField, this.predictedClassField) && Objects.equals(that.predictedProbabilityField, this.predictedProbabilityField) && Objects.equals(that.predictedProbabilityFieldNested, this.predictedProbabilityFieldNested);
    }

    public int hashCode() {
        return Objects.hash(this.actualField, this.predictedField, this.topClassesField, this.predictedClassField, this.predictedProbabilityField, this.predictedProbabilityFieldNested);
    }
}

