/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.ilm.CheckNotDataStreamWriteIndexStep;
import org.elasticsearch.xpack.core.ilm.GenerateUniqueIndexNameStep;
import org.elasticsearch.xpack.core.ilm.LifecycleAction;
import org.elasticsearch.xpack.core.ilm.ReadOnlyStep;
import org.elasticsearch.xpack.core.ilm.RollupStep;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.UpdateRollupIndexPolicyStep;
import org.elasticsearch.xpack.core.rollup.RollupActionConfig;

public class RollupILMAction
implements LifecycleAction {
    public static final String NAME = "rollup";
    private static final ParseField CONFIG_FIELD = new ParseField("config", new String[0]);
    private static final ParseField POLICY_FIELD = new ParseField("rollup_policy", new String[0]);
    private static final ConstructingObjectParser<RollupILMAction, Void> PARSER = new ConstructingObjectParser("rollup", a -> new RollupILMAction((RollupActionConfig)a[0], (String)a[1]));
    public static final String ROLLUP_INDEX_PREFIX = "rollup-";
    public static final String GENERATE_ROLLUP_STEP_NAME = "generate-rollup-name";
    private final RollupActionConfig config;
    private final String rollupPolicy;

    public static RollupILMAction parse(XContentParser parser) {
        return (RollupILMAction)PARSER.apply(parser, null);
    }

    public RollupILMAction(RollupActionConfig config, @Nullable String rollupPolicy) {
        this.config = config;
        this.rollupPolicy = rollupPolicy;
    }

    public RollupILMAction(StreamInput in) throws IOException {
        this(new RollupActionConfig(in), in.readOptionalString());
    }

    public String getWriteableName() {
        return NAME;
    }

    RollupActionConfig config() {
        return this.config;
    }

    String rollupPolicy() {
        return this.rollupPolicy;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(CONFIG_FIELD.getPreferredName(), (ToXContent)this.config);
        if (this.rollupPolicy != null) {
            builder.field(POLICY_FIELD.getPreferredName(), this.rollupPolicy);
        }
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.config.writeTo(out);
        out.writeOptionalString(this.rollupPolicy);
    }

    @Override
    public boolean isSafeAction() {
        return false;
    }

    @Override
    public List<Step> toSteps(Client client, String phase, Step.StepKey nextStepKey) {
        Step.StepKey checkNotWriteIndex = new Step.StepKey(phase, NAME, "check-not-write-index");
        Step.StepKey readOnlyKey = new Step.StepKey(phase, NAME, "readonly");
        Step.StepKey generateRollupIndexNameKey = new Step.StepKey(phase, NAME, GENERATE_ROLLUP_STEP_NAME);
        Step.StepKey rollupKey = new Step.StepKey(phase, NAME, NAME);
        CheckNotDataStreamWriteIndexStep checkNotWriteIndexStep = new CheckNotDataStreamWriteIndexStep(checkNotWriteIndex, readOnlyKey);
        ReadOnlyStep readOnlyStep = new ReadOnlyStep(readOnlyKey, generateRollupIndexNameKey, client);
        GenerateUniqueIndexNameStep generateRollupIndexNameStep = new GenerateUniqueIndexNameStep(generateRollupIndexNameKey, rollupKey, ROLLUP_INDEX_PREFIX, (rollupIndexName, lifecycleStateBuilder) -> lifecycleStateBuilder.setRollupIndexName((String)rollupIndexName));
        if (this.rollupPolicy == null) {
            RollupStep rollupStep = new RollupStep(rollupKey, nextStepKey, client, this.config);
            return Arrays.asList(checkNotWriteIndexStep, readOnlyStep, generateRollupIndexNameStep, rollupStep);
        }
        Step.StepKey updateRollupIndexPolicyStepKey = new Step.StepKey(phase, NAME, "update-rollup-policy");
        RollupStep rollupStep = new RollupStep(rollupKey, updateRollupIndexPolicyStepKey, client, this.config);
        UpdateRollupIndexPolicyStep updateRollupIndexPolicyStep = new UpdateRollupIndexPolicyStep(updateRollupIndexPolicyStepKey, nextStepKey, client, this.rollupPolicy);
        return Arrays.asList(checkNotWriteIndexStep, readOnlyStep, generateRollupIndexNameStep, rollupStep, updateRollupIndexPolicyStep);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RollupILMAction that = (RollupILMAction)o;
        return Objects.equals(this.config, that.config) && Objects.equals(this.rollupPolicy, that.rollupPolicy);
    }

    public int hashCode() {
        return Objects.hash(this.config, this.rollupPolicy);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> RollupActionConfig.fromXContent(p), CONFIG_FIELD, ObjectParser.ValueType.OBJECT);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), POLICY_FIELD);
    }
}

