/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.vectors.query;

import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.SortField;
import org.elasticsearch.Version;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.sort.BucketedSort;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xpack.vectors.query.VectorDVLeafFieldData;

public class VectorIndexFieldData
implements IndexFieldData<VectorDVLeafFieldData> {
    protected final String fieldName;
    private final boolean isDense;
    protected final ValuesSourceType valuesSourceType;
    private final Version indexVersion;
    private final int dims;

    public VectorIndexFieldData(String fieldName, boolean isDense, ValuesSourceType valuesSourceType, Version indexVersion, int dims) {
        this.fieldName = fieldName;
        this.isDense = isDense;
        this.valuesSourceType = valuesSourceType;
        this.indexVersion = indexVersion;
        this.dims = dims;
    }

    public final String getFieldName() {
        return this.fieldName;
    }

    public ValuesSourceType getValuesSourceType() {
        return this.valuesSourceType;
    }

    public SortField sortField(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
        throw new IllegalArgumentException("Field [" + this.fieldName + "] of type [" + "dense_vector" + "] doesn't support sort");
    }

    public BucketedSort newBucketedSort(BigArrays bigArrays, Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        throw new IllegalArgumentException("only supported on numeric fields");
    }

    public VectorDVLeafFieldData load(LeafReaderContext context) {
        return new VectorDVLeafFieldData(context.reader(), this.fieldName, this.isDense, this.indexVersion, this.dims);
    }

    public VectorDVLeafFieldData loadDirect(LeafReaderContext context) {
        return this.load(context);
    }

    public static class Builder
    implements IndexFieldData.Builder {
        private final String name;
        private final boolean isDense;
        private final ValuesSourceType valuesSourceType;
        private final Version indexVersion;
        private final int dims;

        public Builder(String name, boolean isDense, ValuesSourceType valuesSourceType, Version indexVersion, int dims) {
            this.name = name;
            this.isDense = isDense;
            this.valuesSourceType = valuesSourceType;
            this.indexVersion = indexVersion;
            this.dims = dims;
        }

        public IndexFieldData<?> build(IndexFieldDataCache cache, CircuitBreakerService breakerService) {
            return new VectorIndexFieldData(this.name, this.isDense, this.valuesSourceType, this.indexVersion, this.dims);
        }
    }
}

