/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.ExtensiblePlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.autoscaling.AutoscalingExtension;
import org.elasticsearch.xpack.autoscaling.AutoscalingLicenseChecker;
import org.elasticsearch.xpack.autoscaling.AutoscalingMetadata;
import org.elasticsearch.xpack.autoscaling.action.DeleteAutoscalingPolicyAction;
import org.elasticsearch.xpack.autoscaling.action.GetAutoscalingCapacityAction;
import org.elasticsearch.xpack.autoscaling.action.GetAutoscalingPolicyAction;
import org.elasticsearch.xpack.autoscaling.action.PutAutoscalingPolicyAction;
import org.elasticsearch.xpack.autoscaling.action.TransportDeleteAutoscalingPolicyAction;
import org.elasticsearch.xpack.autoscaling.action.TransportGetAutoscalingCapacityAction;
import org.elasticsearch.xpack.autoscaling.action.TransportGetAutoscalingPolicyAction;
import org.elasticsearch.xpack.autoscaling.action.TransportPutAutoscalingPolicyAction;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingCalculateCapacityService;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingDeciderResult;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingDeciderService;
import org.elasticsearch.xpack.autoscaling.capacity.FixedAutoscalingDeciderService;
import org.elasticsearch.xpack.autoscaling.capacity.memory.AutoscalingMemoryInfoService;
import org.elasticsearch.xpack.autoscaling.existence.FrozenExistenceDeciderService;
import org.elasticsearch.xpack.autoscaling.rest.RestDeleteAutoscalingPolicyHandler;
import org.elasticsearch.xpack.autoscaling.rest.RestGetAutoscalingCapacityHandler;
import org.elasticsearch.xpack.autoscaling.rest.RestGetAutoscalingPolicyHandler;
import org.elasticsearch.xpack.autoscaling.rest.RestPutAutoscalingPolicyHandler;
import org.elasticsearch.xpack.autoscaling.shards.FrozenShardsDeciderService;
import org.elasticsearch.xpack.autoscaling.storage.FrozenStorageDeciderService;
import org.elasticsearch.xpack.autoscaling.storage.ProactiveStorageDeciderService;
import org.elasticsearch.xpack.autoscaling.storage.ReactiveStorageDeciderService;

public class Autoscaling
extends Plugin
implements ActionPlugin,
ExtensiblePlugin,
AutoscalingExtension {
    private final List<AutoscalingExtension> autoscalingExtensions;
    private final SetOnce<ClusterService> clusterService = new SetOnce();
    private final SetOnce<AllocationDeciders> allocationDeciders = new SetOnce();
    private final AutoscalingLicenseChecker autoscalingLicenseChecker;

    public Autoscaling() {
        this(new AutoscalingLicenseChecker());
    }

    Autoscaling(AutoscalingLicenseChecker autoscalingLicenseChecker) {
        this.autoscalingExtensions = new ArrayList<AutoscalingExtension>(org.elasticsearch.core.List.of((Object)this));
        this.autoscalingLicenseChecker = Objects.requireNonNull(autoscalingLicenseChecker);
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        this.clusterService.set((Object)clusterService);
        return org.elasticsearch.core.List.of((Object[])new Object[]{new AutoscalingCalculateCapacityService.Holder(this), this.autoscalingLicenseChecker, new AutoscalingMemoryInfoService(clusterService, client)});
    }

    public List<Setting<?>> getSettings() {
        return org.elasticsearch.core.List.of(AutoscalingMemoryInfoService.FETCH_TIMEOUT);
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return org.elasticsearch.core.List.of((Object[])new ActionPlugin.ActionHandler[]{new ActionPlugin.ActionHandler((ActionType)GetAutoscalingCapacityAction.INSTANCE, TransportGetAutoscalingCapacityAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteAutoscalingPolicyAction.INSTANCE, TransportDeleteAutoscalingPolicyAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetAutoscalingPolicyAction.INSTANCE, TransportGetAutoscalingPolicyAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)PutAutoscalingPolicyAction.INSTANCE, TransportPutAutoscalingPolicyAction.class, new Class[0])});
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController controller, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return org.elasticsearch.core.List.of((Object[])new RestHandler[]{new RestGetAutoscalingCapacityHandler(), new RestDeleteAutoscalingPolicyHandler(), new RestGetAutoscalingPolicyHandler(), new RestPutAutoscalingPolicyHandler()});
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return org.elasticsearch.core.List.of((Object[])new NamedWriteableRegistry.Entry[]{new NamedWriteableRegistry.Entry(Metadata.Custom.class, "autoscaling", AutoscalingMetadata::new), new NamedWriteableRegistry.Entry(NamedDiff.class, "autoscaling", AutoscalingMetadata.AutoscalingMetadataDiff::new), new NamedWriteableRegistry.Entry(AutoscalingDeciderResult.Reason.class, "fixed", FixedAutoscalingDeciderService.FixedReason::new), new NamedWriteableRegistry.Entry(AutoscalingDeciderResult.Reason.class, "reactive_storage", ReactiveStorageDeciderService.ReactiveReason::new), new NamedWriteableRegistry.Entry(AutoscalingDeciderResult.Reason.class, "proactive_storage", ProactiveStorageDeciderService.ProactiveReason::new), new NamedWriteableRegistry.Entry(AutoscalingDeciderResult.Reason.class, "frozen_shards", FrozenShardsDeciderService.FrozenShardsReason::new), new NamedWriteableRegistry.Entry(AutoscalingDeciderResult.Reason.class, "frozen_storage", FrozenStorageDeciderService.FrozenReason::new), new NamedWriteableRegistry.Entry(AutoscalingDeciderResult.Reason.class, "frozen_existence", FrozenExistenceDeciderService.FrozenExistenceReason::new)});
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        return org.elasticsearch.core.List.of((Object)new NamedXContentRegistry.Entry(Metadata.Custom.class, new ParseField("autoscaling", new String[0]), AutoscalingMetadata::parse));
    }

    public void loadExtensions(ExtensiblePlugin.ExtensionLoader loader) {
        loader.loadExtensions(AutoscalingExtension.class).forEach(this.autoscalingExtensions::add);
    }

    @Override
    public Collection<AutoscalingDeciderService> deciders() {
        assert (this.allocationDeciders.get() != null);
        return org.elasticsearch.core.List.of((Object[])new AutoscalingDeciderService[]{new FixedAutoscalingDeciderService(), new ReactiveStorageDeciderService(((ClusterService)this.clusterService.get()).getSettings(), ((ClusterService)this.clusterService.get()).getClusterSettings(), (AllocationDeciders)this.allocationDeciders.get()), new ProactiveStorageDeciderService(((ClusterService)this.clusterService.get()).getSettings(), ((ClusterService)this.clusterService.get()).getClusterSettings(), (AllocationDeciders)this.allocationDeciders.get()), new FrozenShardsDeciderService(), new FrozenStorageDeciderService(), new FrozenExistenceDeciderService()});
    }

    public Set<AutoscalingDeciderService> createDeciderServices(AllocationDeciders allocationDeciders) {
        this.allocationDeciders.set((Object)allocationDeciders);
        return this.autoscalingExtensions.stream().flatMap(p -> p.deciders().stream()).collect(Collectors.toSet());
    }

    static {
        String property = System.getProperty("es.autoscaling_feature_flag_registered");
        if (property != null) {
            throw new IllegalArgumentException("es.autoscaling_feature_flag_registered is no longer supported");
        }
    }
}

