/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.fielddata;

import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ByteBuffersDataOutput;

public enum DimensionalShapeType {
    POINT,
    LINE,
    POLYGON;

    private static DimensionalShapeType[] values;

    public static DimensionalShapeType fromOrdinalByte(byte ordinal) {
        return values[Byte.toUnsignedInt(ordinal)];
    }

    public void writeTo(ByteBuffersDataOutput out) {
        out.writeByte((byte)this.ordinal());
    }

    public static DimensionalShapeType readFrom(ByteArrayDataInput in) {
        return DimensionalShapeType.fromOrdinalByte(in.readByte());
    }

    static {
        values = DimensionalShapeType.values();
    }
}

