/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.vectors.mapper;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.xpack.vectors.mapper.VectorEncoderDecoder;
import org.elasticsearch.xpack.vectors.query.VectorIndexFieldData;

@Deprecated
public class SparseVectorFieldMapper
extends FieldMapper {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(SparseVectorFieldMapper.class);
    public static final String DEPRECATION_MESSAGE = "The [sparse_vector] field type is deprecated and will be removed in 8.0.";
    public static final String CONTENT_TYPE = "sparse_vector";
    public static short MAX_DIMS_COUNT = (short)1024;
    public static int MAX_DIMS_NUMBER = 65535;
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> {
        deprecationLogger.deprecate(DeprecationCategory.API, CONTENT_TYPE, DEPRECATION_MESSAGE, new Object[0]);
        return new Builder((String)n, c.indexVersionCreated());
    }, SparseVectorFieldMapper.notInMultiFields((String)"sparse_vector"));
    private final Version indexCreatedVersion;

    private SparseVectorFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Version indexCreatedVersion) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        this.indexCreatedVersion = indexCreatedVersion;
    }

    public SparseVectorFieldType fieldType() {
        return (SparseVectorFieldType)super.fieldType();
    }

    public void parse(ParseContext context) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)context.parser().currentToken(), (XContentParser)context.parser());
        int[] dims = new int[]{};
        float[] values = new float[]{};
        int dimCount = 0;
        int dim = 0;
        XContentParser.Token token = context.parser().nextToken();
        while (token != XContentParser.Token.END_OBJECT) {
            block9: {
                if (token == XContentParser.Token.FIELD_NAME) {
                    try {
                        dim = Integer.parseInt(context.parser().currentName());
                        if (dim < 0 || dim > MAX_DIMS_NUMBER) {
                            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "]'s dimension number must be a non-negative integer value not exceeding [" + MAX_DIMS_NUMBER + "], got [" + dim + "]");
                        }
                        break block9;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "]'s dimensions should be integers represented as strings, but got [" + context.parser().currentName() + "]", e);
                    }
                }
                if (token == XContentParser.Token.VALUE_NUMBER) {
                    float value = context.parser().floatValue(true);
                    if (dims.length <= dimCount) {
                        values = ArrayUtil.grow((float[])values, (int)(dimCount + 1));
                        dims = ArrayUtil.grow((int[])dims, (int)(dimCount + 1));
                    }
                    dims[dimCount] = dim;
                    values[dimCount] = value;
                    if (dimCount++ >= MAX_DIMS_COUNT) {
                        throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] has exceeded the maximum allowed number of dimensions of [" + MAX_DIMS_COUNT + "]");
                    }
                } else {
                    throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] takes an object that maps a dimension number to a float, but got unexpected token [" + token + "]");
                }
            }
            token = context.parser().nextToken();
        }
        BytesRef br = VectorEncoderDecoder.encodeSparseVector(this.indexCreatedVersion, dims, values, dimCount);
        BinaryDocValuesField field = new BinaryDocValuesField(this.fieldType().name(), br);
        context.doc().addWithKey((Object)this.fieldType().name(), (IndexableField)field);
    }

    protected void parseCreateField(ParseContext context) {
        throw new AssertionError((Object)"parse is implemented directly");
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.indexCreatedVersion).init(this);
    }

    public static final class SparseVectorFieldType
    extends MappedFieldType {
        private final Version indexVersionCreated;

        public SparseVectorFieldType(String name, Version indexVersionCreated, Map<String, String> meta) {
            super(name, false, false, true, TextSearchInfo.NONE, meta);
            this.indexVersionCreated = indexVersionCreated;
        }

        public String typeName() {
            return SparseVectorFieldMapper.CONTENT_TYPE;
        }

        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support docvalue_fields or aggregations");
        }

        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new SourceValueFetcher(this.name(), context, false){

                protected Object parseSourceValue(Object value) {
                    return value;
                }
            };
        }

        public Query existsQuery(SearchExecutionContext context) {
            return new DocValuesFieldExistsQuery(this.name());
        }

        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            return new VectorIndexFieldData.Builder(this.name(), false, (ValuesSourceType)CoreValuesSourceType.KEYWORD, this.indexVersionCreated, -1);
        }

        public boolean isAggregatable() {
            return false;
        }

        public Query termQuery(Object value, SearchExecutionContext context) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support queries");
        }
    }

    public static class Builder
    extends FieldMapper.Builder {
        final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        final Version indexCreatedVersion;

        public Builder(String name, Version indexCreatedVersion) {
            super(name);
            this.indexCreatedVersion = indexCreatedVersion;
        }

        protected List<FieldMapper.Parameter<?>> getParameters() {
            return Collections.singletonList(this.meta);
        }

        public SparseVectorFieldMapper build(ContentPath contentPath) {
            return new SparseVectorFieldMapper(this.name, new SparseVectorFieldType(this.buildFullName(contentPath), this.indexCreatedVersion, (Map)this.meta.getValue()), this.multiFieldsBuilder.build((Mapper.Builder)this, contentPath), this.copyTo.build(), this.indexCreatedVersion);
        }
    }
}

