/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression;

import java.util.Collections;
import java.util.List;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.NameId;
import org.elasticsearch.xpack.ql.expression.NamedExpression;
import org.elasticsearch.xpack.ql.expression.Nullability;
import org.elasticsearch.xpack.ql.expression.ReferenceAttribute;
import org.elasticsearch.xpack.ql.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;

public class Alias
extends NamedExpression {
    private final Expression child;
    private final String qualifier;
    private Attribute lazyAttribute;

    public Alias(Source source, String name, Expression child) {
        this(source, name, null, child, null);
    }

    public Alias(Source source, String name, String qualifier, Expression child) {
        this(source, name, qualifier, child, null);
    }

    public Alias(Source source, String name, String qualifier, Expression child, NameId id) {
        this(source, name, qualifier, child, id, false);
    }

    public Alias(Source source, String name, String qualifier, Expression child, NameId id, boolean synthetic) {
        super(source, name, Collections.singletonList(child), id, synthetic);
        this.child = child;
        this.qualifier = qualifier;
    }

    @Override
    protected NodeInfo<Alias> info() {
        return NodeInfo.create(this, Alias::new, this.name(), this.qualifier, this.child, this.id(), this.synthetic());
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new Alias(this.source(), this.name(), this.qualifier, newChildren.get(0), this.id(), this.synthetic());
    }

    public Expression child() {
        return this.child;
    }

    public String qualifier() {
        return this.qualifier;
    }

    public String qualifiedName() {
        return this.qualifier == null ? this.name() : this.qualifier + "." + this.name();
    }

    @Override
    public Nullability nullable() {
        return this.child.nullable();
    }

    @Override
    public DataType dataType() {
        return this.child.dataType();
    }

    @Override
    public Attribute toAttribute() {
        if (this.lazyAttribute == null) {
            this.lazyAttribute = this.resolved() ? new ReferenceAttribute(this.source(), this.name(), this.dataType(), this.qualifier, this.nullable(), this.id(), this.synthetic()) : new UnresolvedAttribute(this.source(), this.name(), this.qualifier);
        }
        return this.lazyAttribute;
    }

    @Override
    public String toString() {
        return this.child + " AS " + this.name() + "#" + this.id();
    }
}

