/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.transforms;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.transform.TransformField;

public class SettingsConfig
implements Writeable,
ToXContentObject {
    public static final ConstructingObjectParser<SettingsConfig, Void> STRICT_PARSER = SettingsConfig.createParser(false);
    public static final ConstructingObjectParser<SettingsConfig, Void> LENIENT_PARSER = SettingsConfig.createParser(true);
    private static final int DEFAULT_MAX_PAGE_SEARCH_SIZE = -1;
    private static final float DEFAULT_DOCS_PER_SECOND = -1.0f;
    private static final int DEFAULT_DATES_AS_EPOCH_MILLIS = -1;
    private final Integer maxPageSearchSize;
    private final Float docsPerSecond;
    private final Integer datesAsEpochMillis;

    private static ConstructingObjectParser<SettingsConfig, Void> createParser(boolean lenient) {
        ConstructingObjectParser<SettingsConfig, Void> parser = new ConstructingObjectParser<SettingsConfig, Void>("transform_config_settings", lenient, args -> new SettingsConfig((Integer)args[0], (Float)args[1], (Integer)args[2]));
        parser.declareIntOrNull(ConstructingObjectParser.optionalConstructorArg(), -1, TransformField.MAX_PAGE_SEARCH_SIZE);
        parser.declareFloatOrNull(ConstructingObjectParser.optionalConstructorArg(), -1.0f, TransformField.DOCS_PER_SECOND);
        parser.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> p.currentToken() == XContentParser.Token.VALUE_NULL ? -1 : (p.booleanValue() ? 1 : 0), TransformField.DATES_AS_EPOCH_MILLIS, ObjectParser.ValueType.BOOLEAN_OR_NULL);
        return parser;
    }

    public SettingsConfig() {
        this(null, null, (Integer)null);
    }

    public SettingsConfig(Integer maxPageSearchSize, Float docsPerSecond, Boolean datesAsEpochMillis) {
        this(maxPageSearchSize, docsPerSecond, datesAsEpochMillis == null ? null : Integer.valueOf(datesAsEpochMillis != false ? 1 : 0));
    }

    public SettingsConfig(Integer maxPageSearchSize, Float docsPerSecond, Integer datesAsEpochMillis) {
        this.maxPageSearchSize = maxPageSearchSize;
        this.docsPerSecond = docsPerSecond;
        this.datesAsEpochMillis = datesAsEpochMillis;
    }

    public SettingsConfig(StreamInput in) throws IOException {
        this.maxPageSearchSize = in.readOptionalInt();
        this.docsPerSecond = in.readOptionalFloat();
        this.datesAsEpochMillis = in.getVersion().onOrAfter(Version.V_7_11_0) ? in.readOptionalInt() : Integer.valueOf(-1);
    }

    public Integer getMaxPageSearchSize() {
        return this.maxPageSearchSize;
    }

    public Float getDocsPerSecond() {
        return this.docsPerSecond;
    }

    public Boolean getDatesAsEpochMillis() {
        return this.datesAsEpochMillis != null ? Boolean.valueOf(this.datesAsEpochMillis > 0) : null;
    }

    public Integer getDatesAsEpochMillisForUpdate() {
        return this.datesAsEpochMillis;
    }

    public ActionRequestValidationException validate(ActionRequestValidationException validationException) {
        if (this.maxPageSearchSize != null && (this.maxPageSearchSize < 10 || this.maxPageSearchSize > 10000)) {
            validationException = ValidateActions.addValidationError("settings.max_page_search_size [" + this.maxPageSearchSize + "] must be greater than 10 and less than 10,000", validationException);
        }
        return validationException;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalInt(this.maxPageSearchSize);
        out.writeOptionalFloat(this.docsPerSecond);
        if (out.getVersion().onOrAfter(Version.V_7_11_0)) {
            out.writeOptionalInt(this.datesAsEpochMillis);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.maxPageSearchSize != null && !this.maxPageSearchSize.equals(-1)) {
            builder.field(TransformField.MAX_PAGE_SEARCH_SIZE.getPreferredName(), this.maxPageSearchSize);
        }
        if (this.docsPerSecond != null && !this.docsPerSecond.equals(Float.valueOf(-1.0f))) {
            builder.field(TransformField.DOCS_PER_SECOND.getPreferredName(), this.docsPerSecond);
        }
        if (this.datesAsEpochMillis != null && !this.datesAsEpochMillis.equals(-1)) {
            builder.field(TransformField.DATES_AS_EPOCH_MILLIS.getPreferredName(), this.datesAsEpochMillis > 0);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        SettingsConfig that = (SettingsConfig)other;
        return Objects.equals(this.maxPageSearchSize, that.maxPageSearchSize) && Objects.equals(this.docsPerSecond, that.docsPerSecond) && Objects.equals(this.datesAsEpochMillis, that.datesAsEpochMillis);
    }

    public int hashCode() {
        return Objects.hash(this.maxPageSearchSize, this.docsPerSecond, this.datesAsEpochMillis);
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }

    public static SettingsConfig fromXContent(XContentParser parser, boolean lenient) throws IOException {
        return lenient ? LENIENT_PARSER.apply(parser, null) : STRICT_PARSER.apply(parser, null);
    }

    public static class Builder {
        private Integer maxPageSearchSize;
        private Float docsPerSecond;
        private Integer datesAsEpochMillis;

        public Builder() {
        }

        public Builder(SettingsConfig base) {
            this.maxPageSearchSize = base.maxPageSearchSize;
            this.docsPerSecond = base.docsPerSecond;
            this.datesAsEpochMillis = base.datesAsEpochMillis;
        }

        public Builder setMaxPageSearchSize(Integer maxPageSearchSize) {
            this.maxPageSearchSize = maxPageSearchSize == null ? -1 : maxPageSearchSize;
            return this;
        }

        public Builder setRequestsPerSecond(Float docsPerSecond) {
            this.docsPerSecond = Float.valueOf(docsPerSecond == null ? -1.0f : docsPerSecond.floatValue());
            return this;
        }

        public Builder setDatesAsEpochMillis(Boolean datesAsEpochMillis) {
            this.datesAsEpochMillis = datesAsEpochMillis == null ? -1 : (datesAsEpochMillis != false ? 1 : 0);
            return this;
        }

        public Builder update(SettingsConfig update) {
            if (update.getDocsPerSecond() != null) {
                Float f = this.docsPerSecond = update.getDocsPerSecond().equals(Float.valueOf(-1.0f)) ? null : update.getDocsPerSecond();
            }
            if (update.getMaxPageSearchSize() != null) {
                Integer n = this.maxPageSearchSize = update.getMaxPageSearchSize().equals(-1) ? null : update.getMaxPageSearchSize();
            }
            if (update.getDatesAsEpochMillisForUpdate() != null) {
                this.datesAsEpochMillis = update.getDatesAsEpochMillisForUpdate().equals(-1) ? null : update.getDatesAsEpochMillisForUpdate();
            }
            return this;
        }

        public SettingsConfig build() {
            return new SettingsConfig(this.maxPageSearchSize, this.docsPerSecond, this.datesAsEpochMillis);
        }
    }
}

