/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.index;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.apache.lucene.util.automaton.Automaton;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.xpack.core.security.support.Automatons;

public final class RestrictedIndicesNames {
    public static final String INTERNAL_SECURITY_MAIN_INDEX_6 = ".security-6";
    public static final String INTERNAL_SECURITY_MAIN_INDEX_7 = ".security-7";
    public static final String SECURITY_MAIN_ALIAS = ".security";
    public static final String INTERNAL_SECURITY_TOKENS_INDEX_7 = ".security-tokens-7";
    public static final String SECURITY_TOKENS_ALIAS = ".security-tokens";
    public static final String ASYNC_SEARCH_PREFIX = ".async-search";
    private static final Automaton ASYNC_SEARCH_AUTOMATON = Automatons.patterns(".async-search*");
    public static final Set<String> RESTRICTED_NAMES = Collections.unmodifiableSet(Sets.newHashSet(".security", ".security-6", ".security-7", ".security-tokens-7", ".security-tokens"));
    public static final Automaton NAMES_AUTOMATON = Automatons.unionAndMinimize(Arrays.asList(Automatons.patterns(RESTRICTED_NAMES), ASYNC_SEARCH_AUTOMATON));

    public static boolean isRestricted(String concreteIndexName) {
        return RESTRICTED_NAMES.contains(concreteIndexName) || concreteIndexName.startsWith(ASYNC_SEARCH_PREFIX);
    }

    private RestrictedIndicesNames() {
    }
}

