/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.store;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.permission.Role;
import org.elasticsearch.xpack.core.security.authz.privilege.ConfigurableClusterPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.ConfigurableClusterPrivileges;
import org.elasticsearch.xpack.core.security.authz.store.RoleRetrievalResult;
import org.elasticsearch.xpack.core.security.support.MetadataUtils;

public class ReservedRolesStore
implements BiConsumer<Set<String>, ActionListener<RoleRetrievalResult>> {
    public static final String LEGACY_ALERTS_INDEX = ".siem-signals*";
    public static final String ALERTS_INDEX = ".alerts*";
    public static final RoleDescriptor SUPERUSER_ROLE_DESCRIPTOR = new RoleDescriptor("superuser", new String[]{"all"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices("*").privileges("all").allowRestrictedIndices(true).build()}, new RoleDescriptor.ApplicationResourcePrivileges[]{RoleDescriptor.ApplicationResourcePrivileges.builder().application("*").privileges("*").resources("*").build()}, null, new String[]{"*"}, MetadataUtils.DEFAULT_RESERVED_METADATA, Collections.emptyMap());
    public static final Role SUPERUSER_ROLE = Role.builder(SUPERUSER_ROLE_DESCRIPTOR, null).build();
    private static final Map<String, RoleDescriptor> RESERVED_ROLES = ReservedRolesStore.initializeReservedRoles();

    private static Map<String, RoleDescriptor> initializeReservedRoles() {
        return MapBuilder.newMapBuilder().put("superuser", SUPERUSER_ROLE_DESCRIPTOR).put("transport_client", new RoleDescriptor("transport_client", new String[]{"transport_client"}, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put("kibana_admin", ReservedRolesStore.kibanaAdminUser("kibana_admin", MetadataUtils.DEFAULT_RESERVED_METADATA)).put("kibana_user", ReservedRolesStore.kibanaAdminUser("kibana_user", MetadataUtils.getDeprecatedReservedMetadata("Please use the [kibana_admin] role instead"))).put("monitoring_user", new RoleDescriptor("monitoring_user", new String[]{"cluster:monitor/main", "cluster:monitor/xpack/info", "cluster:monitor/remote/info"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".monitoring-*").privileges("read", "read_cross_cluster").build(), RoleDescriptor.IndicesPrivileges.builder().indices("metricbeat-*").privileges("read", "read_cross_cluster").build()}, new RoleDescriptor.ApplicationResourcePrivileges[]{RoleDescriptor.ApplicationResourcePrivileges.builder().application("kibana-*").resources("*").privileges("reserved_monitoring").build()}, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA, null)).put("remote_monitoring_agent", new RoleDescriptor("remote_monitoring_agent", new String[]{"manage_index_templates", "manage_ingest_pipelines", "monitor", "cluster:admin/ilm/get", "cluster:admin/ilm/put", "cluster:monitor/xpack/watcher/watch/get", "cluster:admin/xpack/watcher/watch/put", "cluster:admin/xpack/watcher/watch/delete"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".monitoring-*").privileges("all").build(), RoleDescriptor.IndicesPrivileges.builder().indices("metricbeat-*").privileges("index", "create_index", "view_index_metadata", "indices:admin/aliases").build()}, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put("remote_monitoring_collector", new RoleDescriptor("remote_monitoring_collector", new String[]{"monitor"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices("*").privileges("monitor").allowRestrictedIndices(true).build(), RoleDescriptor.IndicesPrivileges.builder().indices(".kibana*").privileges("read").build()}, null, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA, null)).put("ingest_admin", new RoleDescriptor("ingest_admin", new String[]{"manage_index_templates", "manage_pipeline"}, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put("reporting_user", new RoleDescriptor("reporting_user", null, null, null, null, null, MetadataUtils.getDeprecatedReservedMetadata("Please use Kibana feature privileges instead"), null)).put("kibana_dashboard_only_user", new RoleDescriptor("kibana_dashboard_only_user", null, null, new RoleDescriptor.ApplicationResourcePrivileges[]{RoleDescriptor.ApplicationResourcePrivileges.builder().application("kibana-.kibana").resources("*").privileges("read").build()}, null, null, MetadataUtils.getDeprecatedReservedMetadata("Please use Kibana feature privileges instead"), null)).put("kibana_system", new RoleDescriptor("kibana_system", new String[]{"monitor", "manage_index_templates", "cluster:admin/xpack/monitoring/bulk", "manage_saml", "manage_token", "manage_oidc", "cluster:admin/xpack/security/api_key/invalidate", "grant_api_key", "cluster:admin/xpack/security/privilege/builtin/get", "delegate_pki", "cluster:admin/ilm/get", "cluster:admin/ilm/put", "manage_ml", "cluster:admin/analyze", "monitor_text_structure", "cancel_task"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".kibana*", ".reporting-*").privileges("all").build(), RoleDescriptor.IndicesPrivileges.builder().indices(".monitoring-*").privileges("read", "read_cross_cluster").build(), RoleDescriptor.IndicesPrivileges.builder().indices(".management-beats").privileges("create_index", "read", "write").build(), RoleDescriptor.IndicesPrivileges.builder().indices(".ml-anomalies*", ".ml-stats-*").privileges("read").build(), RoleDescriptor.IndicesPrivileges.builder().indices(".ml-annotations*", ".ml-notifications*").privileges("read", "write").build(), RoleDescriptor.IndicesPrivileges.builder().indices(".apm-agent-configuration").privileges("all").build(), RoleDescriptor.IndicesPrivileges.builder().indices(".apm-custom-link").privileges("all").build(), RoleDescriptor.IndicesPrivileges.builder().indices("apm-*").privileges("read", "read_cross_cluster").build(), RoleDescriptor.IndicesPrivileges.builder().indices("*").privileges("view_index_metadata", "monitor").build(), RoleDescriptor.IndicesPrivileges.builder().indices(".logs-endpoint.diagnostic.collection-*").privileges("read").build(), RoleDescriptor.IndicesPrivileges.builder().indices(".fleet*").privileges("all").build(), RoleDescriptor.IndicesPrivileges.builder().indices(LEGACY_ALERTS_INDEX).privileges("all").build(), RoleDescriptor.IndicesPrivileges.builder().indices(ALERTS_INDEX).privileges("all").build(), RoleDescriptor.IndicesPrivileges.builder().indices("metrics-endpoint.policy-*").privileges("read").build(), RoleDescriptor.IndicesPrivileges.builder().indices("metrics-endpoint.metrics-*").privileges("read").build()}, null, new ConfigurableClusterPrivilege[]{new ConfigurableClusterPrivileges.ManageApplicationPrivileges(Collections.singleton("kibana-*"))}, null, MetadataUtils.DEFAULT_RESERVED_METADATA, null)).put("logstash_system", new RoleDescriptor("logstash_system", new String[]{"monitor", "cluster:admin/xpack/monitoring/bulk"}, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put("beats_admin", new RoleDescriptor("beats_admin", null, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".management-beats").privileges("all").build()}, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put("beats_system", new RoleDescriptor("beats_system", new String[]{"monitor", "cluster:admin/xpack/monitoring/bulk"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".monitoring-beats-*").privileges("create_index", "create").build()}, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put("apm_system", new RoleDescriptor("apm_system", new String[]{"monitor", "cluster:admin/xpack/monitoring/bulk"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".monitoring-beats-*").privileges("create_index", "create_doc").build()}, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put("apm_user", new RoleDescriptor("apm_user", null, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices("apm-*").privileges("read", "view_index_metadata").build(), RoleDescriptor.IndicesPrivileges.builder().indices("logs-apm.*").privileges("read", "view_index_metadata").build(), RoleDescriptor.IndicesPrivileges.builder().indices("logs-apm-*").privileges("read", "view_index_metadata").build(), RoleDescriptor.IndicesPrivileges.builder().indices("metrics-apm.*").privileges("read", "view_index_metadata").build(), RoleDescriptor.IndicesPrivileges.builder().indices("metrics-apm-*").privileges("read", "view_index_metadata").build(), RoleDescriptor.IndicesPrivileges.builder().indices("traces-apm.*").privileges("read", "view_index_metadata").build(), RoleDescriptor.IndicesPrivileges.builder().indices("traces-apm-*").privileges("read", "view_index_metadata").build(), RoleDescriptor.IndicesPrivileges.builder().indices(".ml-anomalies*").privileges("read", "view_index_metadata").build(), RoleDescriptor.IndicesPrivileges.builder().indices("observability-annotations").privileges("read", "view_index_metadata").build()}, new RoleDescriptor.ApplicationResourcePrivileges[]{RoleDescriptor.ApplicationResourcePrivileges.builder().application("kibana-*").resources("*").privileges("reserved_ml_apm_user").build()}, null, null, MetadataUtils.getDeprecatedReservedMetadata("This role will be removed in 8.0"), null)).put("machine_learning_user", new RoleDescriptor("machine_learning_user", new String[]{"monitor_ml"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".ml-anomalies*", ".ml-notifications*").privileges("view_index_metadata", "read").build(), RoleDescriptor.IndicesPrivileges.builder().indices(".ml-annotations*").privileges("view_index_metadata", "read", "write").build()}, new RoleDescriptor.ApplicationResourcePrivileges[]{RoleDescriptor.ApplicationResourcePrivileges.builder().application("kibana-*").resources("*").privileges("reserved_ml_user").build()}, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA, null)).put("machine_learning_admin", new RoleDescriptor("machine_learning_admin", new String[]{"manage_ml"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".ml-anomalies*", ".ml-notifications*", ".ml-state*", ".ml-meta*", ".ml-stats-*").privileges("view_index_metadata", "read").build(), RoleDescriptor.IndicesPrivileges.builder().indices(".ml-annotations*").privileges("view_index_metadata", "read", "write").build()}, new RoleDescriptor.ApplicationResourcePrivileges[]{RoleDescriptor.ApplicationResourcePrivileges.builder().application("kibana-*").resources("*").privileges("reserved_ml_admin").build()}, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA, null)).put("data_frame_transforms_admin", new RoleDescriptor("data_frame_transforms_admin", new String[]{"manage_data_frame_transforms"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".transform-notifications-*", ".data-frame-notifications-*", ".transform-notifications-read").privileges("view_index_metadata", "read").build()}, new RoleDescriptor.ApplicationResourcePrivileges[]{RoleDescriptor.ApplicationResourcePrivileges.builder().application("kibana-*").resources("*").privileges("reserved_ml_user").build()}, null, null, MetadataUtils.getDeprecatedReservedMetadata("Please use the [transform_admin] role instead"), null)).put("data_frame_transforms_user", new RoleDescriptor("data_frame_transforms_user", new String[]{"monitor_data_frame_transforms"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".transform-notifications-*", ".data-frame-notifications-*", ".transform-notifications-read").privileges("view_index_metadata", "read").build()}, new RoleDescriptor.ApplicationResourcePrivileges[]{RoleDescriptor.ApplicationResourcePrivileges.builder().application("kibana-*").resources("*").privileges("reserved_ml_user").build()}, null, null, MetadataUtils.getDeprecatedReservedMetadata("Please use the [transform_user] role instead"), null)).put("transform_admin", new RoleDescriptor("transform_admin", new String[]{"manage_transform"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".transform-notifications-*", ".data-frame-notifications-*", ".transform-notifications-read").privileges("view_index_metadata", "read").build()}, null, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA, null)).put("transform_user", new RoleDescriptor("transform_user", new String[]{"monitor_transform"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".transform-notifications-*", ".data-frame-notifications-*", ".transform-notifications-read").privileges("view_index_metadata", "read").build()}, null, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA, null)).put("watcher_admin", new RoleDescriptor("watcher_admin", new String[]{"manage_watcher"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".watches", ".triggered_watches", ".watcher-history-*").privileges("read").build()}, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put("watcher_user", new RoleDescriptor("watcher_user", new String[]{"monitor_watcher"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".watches").privileges("read").build(), RoleDescriptor.IndicesPrivileges.builder().indices(".watcher-history-*").privileges("read").build()}, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put("logstash_admin", new RoleDescriptor("logstash_admin", new String[]{"manage_logstash_pipelines"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".logstash*").privileges("create", "delete", "index", "manage", "read").build()}, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put("rollup_user", new RoleDescriptor("rollup_user", new String[]{"monitor_rollup"}, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put("rollup_admin", new RoleDescriptor("rollup_admin", new String[]{"manage_rollup"}, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put("snapshot_user", new RoleDescriptor("snapshot_user", new String[]{"create_snapshot", "cluster:admin/repository/get"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices("*").privileges("view_index_metadata").allowRestrictedIndices(true).build()}, null, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA, null)).put("enrich_user", new RoleDescriptor("enrich_user", new String[]{"manage_enrich", "manage_ingest_pipelines", "monitor"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".enrich-*").privileges("manage", "read", "write").build()}, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put("viewer", ReservedRolesStore.buildViewerRoleDescriptor()).put("editor", ReservedRolesStore.buildEditorRoleDescriptor()).immutableMap();
    }

    private static RoleDescriptor buildViewerRoleDescriptor() {
        return new RoleDescriptor("viewer", new String[0], new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices("/~(([.]|ilm-history-).*)/").privileges("read", "view_index_metadata").build(), RoleDescriptor.IndicesPrivileges.builder().indices(".siem-signals-*").privileges("read", "view_index_metadata").build()}, new RoleDescriptor.ApplicationResourcePrivileges[]{RoleDescriptor.ApplicationResourcePrivileges.builder().application("kibana-.kibana").resources("*").privileges("read").build(), RoleDescriptor.ApplicationResourcePrivileges.builder().application("kibana-*").resources("*").privileges("reserved_ml_user").build()}, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA, null);
    }

    private static RoleDescriptor buildEditorRoleDescriptor() {
        return new RoleDescriptor("editor", new String[0], new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices("/~(([.]|ilm-history-).*)/").privileges("read", "view_index_metadata").build(), RoleDescriptor.IndicesPrivileges.builder().indices("observability-annotations").privileges("read", "view_index_metadata", "write").build(), RoleDescriptor.IndicesPrivileges.builder().indices(".siem-signals-*", ".lists-*", ".items-*").privileges("read", "view_index_metadata", "write", "maintenance").build()}, new RoleDescriptor.ApplicationResourcePrivileges[]{RoleDescriptor.ApplicationResourcePrivileges.builder().application("kibana-.kibana").resources("*").privileges("all").build(), RoleDescriptor.ApplicationResourcePrivileges.builder().application("kibana-*").resources("*").privileges("reserved_ml_admin").build()}, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA, null);
    }

    private static RoleDescriptor kibanaAdminUser(String name, Map<String, Object> metadata) {
        return new RoleDescriptor(name, null, null, new RoleDescriptor.ApplicationResourcePrivileges[]{RoleDescriptor.ApplicationResourcePrivileges.builder().application("kibana-.kibana").resources("*").privileges("all").build()}, null, null, metadata, null);
    }

    public static boolean isReserved(String role) {
        return RESERVED_ROLES.containsKey(role) || "_system".equals(role) || "_xpack".equals(role) || "_async_search".equals(role);
    }

    public Map<String, Object> usageStats() {
        return Collections.emptyMap();
    }

    public RoleDescriptor roleDescriptor(String role) {
        return RESERVED_ROLES.get(role);
    }

    public Collection<RoleDescriptor> roleDescriptors() {
        return RESERVED_ROLES.values();
    }

    public static Set<String> names() {
        return RESERVED_ROLES.keySet();
    }

    @Override
    public void accept(Set<String> roleNames, ActionListener<RoleRetrievalResult> listener) {
        Set<RoleDescriptor> descriptors = roleNames.stream().map(RESERVED_ROLES::get).filter(Objects::nonNull).collect(Collectors.toSet());
        listener.onResponse(RoleRetrievalResult.success(descriptors));
    }

    public String toString() {
        return "reserved roles store";
    }
}

