/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.config;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.job.config.Operator;

public class RuleCondition
implements ToXContentObject,
Writeable {
    public static final ParseField RULE_CONDITION_FIELD = new ParseField("rule_condition", new String[0]);
    public static final ParseField APPLIES_TO_FIELD = new ParseField("applies_to", new String[0]);
    public static final ParseField VALUE_FIELD = new ParseField("value", new String[0]);
    public static final ConstructingObjectParser<RuleCondition, Void> LENIENT_PARSER = RuleCondition.createParser(true);
    public static final ConstructingObjectParser<RuleCondition, Void> STRICT_PARSER = RuleCondition.createParser(false);
    private final AppliesTo appliesTo;
    private final Operator operator;
    private final double value;

    private static ConstructingObjectParser<RuleCondition, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser<RuleCondition, Void> parser = new ConstructingObjectParser<RuleCondition, Void>(RULE_CONDITION_FIELD.getPreferredName(), ignoreUnknownFields, a -> new RuleCondition((AppliesTo)a[0], (Operator)a[1], (Double)a[2]));
        parser.declareString(ConstructingObjectParser.constructorArg(), AppliesTo::fromString, APPLIES_TO_FIELD);
        parser.declareString(ConstructingObjectParser.constructorArg(), Operator::fromString, Operator.OPERATOR_FIELD);
        parser.declareDouble(ConstructingObjectParser.constructorArg(), VALUE_FIELD);
        return parser;
    }

    public RuleCondition(StreamInput in) throws IOException {
        this.appliesTo = AppliesTo.readFromStream(in);
        this.operator = Operator.readFromStream(in);
        this.value = in.readDouble();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.appliesTo.writeTo(out);
        this.operator.writeTo(out);
        out.writeDouble(this.value);
    }

    public RuleCondition(AppliesTo appliesTo, Operator operator, double value) {
        this.appliesTo = appliesTo;
        this.operator = operator;
        this.value = value;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(APPLIES_TO_FIELD.getPreferredName(), this.appliesTo);
        builder.field(Operator.OPERATOR_FIELD.getPreferredName(), this.operator);
        builder.field(VALUE_FIELD.getPreferredName(), this.value);
        builder.endObject();
        return builder;
    }

    public AppliesTo getAppliesTo() {
        return this.appliesTo;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public double getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RuleCondition)) {
            return false;
        }
        RuleCondition other = (RuleCondition)obj;
        return this.appliesTo == other.appliesTo && this.operator == other.operator && this.value == other.value;
    }

    public int hashCode() {
        return Objects.hash(this.appliesTo, this.operator, this.value);
    }

    public static RuleCondition createTime(Operator operator, long epochSeconds) {
        return new RuleCondition(AppliesTo.TIME, operator, epochSeconds);
    }

    public static enum AppliesTo implements Writeable
    {
        ACTUAL,
        TYPICAL,
        DIFF_FROM_TYPICAL,
        TIME;


        public static AppliesTo fromString(String value) {
            return AppliesTo.valueOf(value.toUpperCase(Locale.ROOT));
        }

        public static AppliesTo readFromStream(StreamInput in) throws IOException {
            return in.readEnum(AppliesTo.class);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeEnum(this);
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

