/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.explain;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.core.Nullable;

public class FieldSelection
implements ToXContentObject,
Writeable {
    private static final ParseField NAME = new ParseField("name", new String[0]);
    private static final ParseField MAPPING_TYPES = new ParseField("mapping_types", new String[0]);
    private static final ParseField IS_INCLUDED = new ParseField("is_included", new String[0]);
    private static final ParseField IS_REQUIRED = new ParseField("is_required", new String[0]);
    private static final ParseField FEATURE_TYPE = new ParseField("feature_type", new String[0]);
    private static final ParseField REASON = new ParseField("reason", new String[0]);
    public static final ConstructingObjectParser<FieldSelection, Void> PARSER = new ConstructingObjectParser("field_selection", a -> new FieldSelection((String)a[0], new HashSet<String>((List)a[1]), (Boolean)a[2], (Boolean)a[3], (FeatureType)((Object)((Object)a[4])), (String)a[5]));
    private final String name;
    private final Set<String> mappingTypes;
    private final boolean isIncluded;
    private final boolean isRequired;
    private final FeatureType featureType;
    private final String reason;

    public static FieldSelection included(String name, Set<String> mappingTypes, boolean isRequired, FeatureType featureType) {
        return new FieldSelection(name, mappingTypes, true, isRequired, featureType, null);
    }

    public static FieldSelection excluded(String name, Set<String> mappingTypes, String reason) {
        return new FieldSelection(name, mappingTypes, false, false, null, reason);
    }

    FieldSelection(String name, Set<String> mappingTypes, boolean isIncluded, boolean isRequired, @Nullable FeatureType featureType, @Nullable String reason) {
        this.name = Objects.requireNonNull(name);
        this.mappingTypes = Collections.unmodifiableSet(mappingTypes);
        this.isIncluded = isIncluded;
        this.isRequired = isRequired;
        this.featureType = featureType;
        this.reason = reason;
    }

    public FieldSelection(StreamInput in) throws IOException {
        this.name = in.readString();
        this.mappingTypes = Collections.unmodifiableSet(in.readSet(StreamInput::readString));
        this.isIncluded = in.readBoolean();
        this.isRequired = in.readBoolean();
        boolean hasFeatureType = in.readBoolean();
        this.featureType = hasFeatureType ? in.readEnum(FeatureType.class) : null;
        this.reason = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeCollection(this.mappingTypes, StreamOutput::writeString);
        out.writeBoolean(this.isIncluded);
        out.writeBoolean(this.isRequired);
        if (this.featureType == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeEnum(this.featureType);
        }
        out.writeOptionalString(this.reason);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NAME.getPreferredName(), this.name);
        builder.field(MAPPING_TYPES.getPreferredName(), this.mappingTypes);
        builder.field(IS_INCLUDED.getPreferredName(), this.isIncluded);
        builder.field(IS_REQUIRED.getPreferredName(), this.isRequired);
        if (this.featureType != null) {
            builder.field(FEATURE_TYPE.getPreferredName(), (Object)this.featureType);
        }
        if (this.reason != null) {
            builder.field(REASON.getPreferredName(), this.reason);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldSelection that = (FieldSelection)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.mappingTypes, that.mappingTypes) && this.isIncluded == that.isIncluded && this.isRequired == that.isRequired && Objects.equals((Object)this.featureType, (Object)that.featureType) && Objects.equals(this.reason, that.reason);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.mappingTypes, this.isIncluded, this.isRequired, this.featureType, this.reason});
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getMappingTypes() {
        return this.mappingTypes;
    }

    public boolean isIncluded() {
        return this.isIncluded;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    @Nullable
    public FeatureType getFeatureType() {
        return this.featureType;
    }

    @Nullable
    public String getReason() {
        return this.reason;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME);
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), MAPPING_TYPES);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), IS_INCLUDED);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), IS_REQUIRED);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), FeatureType::fromString, FEATURE_TYPE);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), REASON);
    }

    public static enum FeatureType {
        CATEGORICAL,
        NUMERICAL;


        public static FeatureType fromString(String value) {
            return FeatureType.valueOf(value.toUpperCase(Locale.ROOT));
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

