/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.ilm.AsyncActionStep;
import org.elasticsearch.xpack.core.ilm.LifecycleExecutionState;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.rollup.RollupActionConfig;
import org.elasticsearch.xpack.core.rollup.action.RollupAction;

public class RollupStep
extends AsyncActionStep {
    public static final String NAME = "rollup";
    public static final String ROLLUP_INDEX_NAME_PREFIX = "rollup-";
    private final RollupActionConfig config;

    public RollupStep(Step.StepKey key, Step.StepKey nextStepKey, Client client, RollupActionConfig config) {
        super(key, nextStepKey, client);
        this.config = config;
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    public void performAction(IndexMetadata indexMetadata, ClusterState currentState, ClusterStateObserver observer, ActionListener<Boolean> listener) {
        String policyName = indexMetadata.getSettings().get("index.lifecycle.name");
        String indexName = indexMetadata.getIndex().getName();
        LifecycleExecutionState lifecycleState = LifecycleExecutionState.fromIndexMetadata(indexMetadata);
        String rollupIndexName = lifecycleState.getRollupIndexName();
        if (!Strings.hasText(rollupIndexName)) {
            listener.onFailure(new IllegalStateException("rollup index name was not generated for policy [" + policyName + "] and index [" + indexName + "]"));
            return;
        }
        RollupAction.Request request = (RollupAction.Request)new RollupAction.Request(indexName, rollupIndexName, this.config).masterNodeTimeout(TimeValue.MAX_VALUE);
        this.getClient().execute(RollupAction.INSTANCE, request, ActionListener.wrap(response -> listener.onResponse(true), listener::onFailure));
    }

    public RollupActionConfig getConfig() {
        return this.config;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.config);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RollupStep other = (RollupStep)obj;
        return super.equals(obj) && Objects.equals(this.config, other.config);
    }
}

