/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.readonly.AddIndexBlockAction;
import org.elasticsearch.action.admin.indices.readonly.AddIndexBlockRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.ilm.AsyncActionStep;
import org.elasticsearch.xpack.core.ilm.Step;

public class ReadOnlyStep
extends AsyncActionStep {
    public static final String NAME = "readonly";

    public ReadOnlyStep(Step.StepKey key, Step.StepKey nextStepKey, Client client) {
        super(key, nextStepKey, client);
    }

    @Override
    public void performAction(IndexMetadata indexMetadata, ClusterState currentState, ClusterStateObserver observer, ActionListener<Boolean> listener) {
        this.getClient().admin().indices().execute(AddIndexBlockAction.INSTANCE, (AddIndexBlockRequest)new AddIndexBlockRequest(IndexMetadata.APIBlock.WRITE, indexMetadata.getIndex().getName()).masterNodeTimeout(TimeValue.MAX_VALUE), ActionListener.wrap(response -> {
            if (!response.isAcknowledged()) {
                throw new ElasticsearchException("read only add block index request failed to be acknowledged", new Object[0]);
            }
            listener.onResponse(true);
        }, listener::onFailure));
    }

    @Override
    public boolean isRetryable() {
        return true;
    }
}

