/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import org.elasticsearch.action.admin.indices.stats.IndexShardStats;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.store.StoreStats;
import org.elasticsearch.search.aggregations.metrics.TDigestState;
import org.elasticsearch.xpack.core.DataTier;
import org.elasticsearch.xpack.core.DataTiersFeatureSetUsage;
import org.elasticsearch.xpack.core.XPackFeatureSet;

public class DataTiersFeatureSet
implements XPackFeatureSet {
    private final Client client;
    private final ClusterService clusterService;

    @Inject
    public DataTiersFeatureSet(Client client, ClusterService clusterService) {
        this.client = client;
        this.clusterService = clusterService;
    }

    @Override
    public String name() {
        return "data_tiers";
    }

    @Override
    public boolean available() {
        return true;
    }

    @Override
    public boolean enabled() {
        return true;
    }

    @Override
    public Map<String, Object> nativeCodeInfo() {
        return null;
    }

    @Override
    public void usage(ActionListener<XPackFeatureSet.Usage> listener) {
        ClusterState state = this.clusterService.state();
        this.client.admin().cluster().prepareNodesStats(new String[0]).all().setIndices(CommonStatsFlags.ALL).execute(ActionListener.wrap(nodesStatsResponse -> {
            RoutingNodes routingNodes = state.getRoutingNodes();
            Map<String, List<NodeStats>> tierSpecificNodeStats = DataTiersFeatureSet.separateTiers(nodesStatsResponse);
            Map<String, DataTiersFeatureSetUsage.TierSpecificStats> tierSpecificStats = tierSpecificNodeStats.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, ns -> this.calculateStats((List)ns.getValue(), routingNodes)));
            listener.onResponse(new DataTiersFeatureSetUsage(tierSpecificStats));
        }, listener::onFailure));
    }

    static Map<String, List<NodeStats>> separateTiers(NodesStatsResponse nodesStatsResponse) {
        HashMap<String, List<NodeStats>> responses = new HashMap<String, List<NodeStats>>();
        DataTier.ALL_DATA_TIERS.forEach(tier -> responses.put((String)tier, nodesStatsResponse.getNodes().stream().filter(stats -> stats.getNode().getRoles().stream().map(DiscoveryNodeRole::roleName).anyMatch(rn -> rn.equals(tier))).collect(Collectors.toList())));
        return responses;
    }

    private DataTiersFeatureSetUsage.TierSpecificStats calculateStats(List<NodeStats> nodesStats, RoutingNodes routingNodes) {
        int nodeCount = 0;
        int indexCount = 0;
        int totalShardCount = 0;
        long totalByteCount = 0L;
        long docCount = 0L;
        AtomicInteger primaryShardCount = new AtomicInteger(0);
        AtomicLong primaryByteCount = new AtomicLong(0L);
        TDigestState valueSketch = new TDigestState(1000.0);
        for (NodeStats nodeStats : nodesStats) {
            ++nodeCount;
            totalByteCount += nodeStats.getIndices().getStore().getSizeInBytes();
            docCount += nodeStats.getIndices().getDocs().getCount();
            String nodeId = nodeStats.getNode().getId();
            RoutingNode node = routingNodes.node(nodeId);
            if (node == null) continue;
            totalShardCount += node.shardsWithState(ShardRoutingState.STARTED).size();
            Set<Index> indicesOnNode = node.shardsWithState(ShardRoutingState.STARTED).stream().map(ShardRouting::index).collect(Collectors.toSet());
            indexCount += indicesOnNode.size();
            indicesOnNode.forEach(index -> {
                List<IndexShardStats> allShardStats = nodeStats.getIndices().getShardStats((Index)index);
                if (allShardStats != null) {
                    allShardStats.stream().filter(shardStats -> shardStats.getPrimary().getStore() != null).forEach(shardStats -> {
                        StoreStats primaryStoreStats = shardStats.getPrimary().getStore();
                        primaryShardCount.incrementAndGet();
                        long primarySize = primaryStoreStats.getSizeInBytes();
                        primaryByteCount.addAndGet(primarySize);
                        valueSketch.add(primarySize);
                    });
                }
            });
        }
        long primaryShardSizeMedian = (long)valueSketch.quantile(0.5);
        long primaryShardSizeMAD = DataTiersFeatureSet.computeMedianAbsoluteDeviation(valueSketch);
        return new DataTiersFeatureSetUsage.TierSpecificStats(nodeCount, indexCount, totalShardCount, primaryShardCount.get(), docCount, totalByteCount, primaryByteCount.get(), primaryShardSizeMedian, primaryShardSizeMAD);
    }

    static long computeMedianAbsoluteDeviation(TDigestState valuesSketch) {
        if (valuesSketch.size() == 0L) {
            return 0L;
        }
        double approximateMedian = valuesSketch.quantile(0.5);
        TDigestState approximatedDeviationsSketch = new TDigestState(valuesSketch.compression());
        valuesSketch.centroids().forEach(centroid -> {
            double deviation = Math.abs(approximateMedian - centroid.mean());
            approximatedDeviationsSketch.add(deviation, centroid.count());
        });
        return (long)approximatedDeviationsSketch.quantile(0.5);
    }
}

