/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.List;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.ParsedMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;

public class ParsedDateHistogram
extends ParsedMultiBucketAggregation<ParsedBucket>
implements Histogram {
    private static final ObjectParser<ParsedDateHistogram, Void> PARSER = new ObjectParser(ParsedDateHistogram.class.getSimpleName(), true, ParsedDateHistogram::new);

    @Override
    public String getType() {
        return "date_histogram";
    }

    @Override
    public List<? extends Histogram.Bucket> getBuckets() {
        return this.buckets;
    }

    public static ParsedDateHistogram fromXContent(XContentParser parser, String name) throws IOException {
        ParsedDateHistogram aggregation = PARSER.parse(parser, null);
        aggregation.setName(name);
        return aggregation;
    }

    static {
        ParsedDateHistogram.declareMultiBucketAggregationFields(PARSER, parser -> ParsedBucket.fromXContent(parser, false), parser -> ParsedBucket.fromXContent(parser, true));
    }

    public static class ParsedBucket
    extends ParsedMultiBucketAggregation.ParsedBucket
    implements Histogram.Bucket {
        private Long key;

        @Override
        public Object getKey() {
            if (this.key != null) {
                return Instant.ofEpochMilli(this.key).atZone(ZoneOffset.UTC);
            }
            return null;
        }

        @Override
        public String getKeyAsString() {
            String keyAsString = super.getKeyAsString();
            if (keyAsString != null) {
                return keyAsString;
            }
            if (this.key != null) {
                return Long.toString(this.key);
            }
            return null;
        }

        @Override
        protected XContentBuilder keyToXContent(XContentBuilder builder) throws IOException {
            return builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.key);
        }

        static ParsedBucket fromXContent(XContentParser parser, boolean keyed) throws IOException {
            return ParsedBucket.parseXContent(parser, keyed, ParsedBucket::new, (p, bucket) -> {
                bucket.key = p.longValue();
            });
        }
    }
}

