/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.composite;

import java.io.IOException;
import java.util.function.LongConsumer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.bucket.composite.SingleDimensionValuesSource;
import org.elasticsearch.search.aggregations.bucket.composite.SortedDocsProducer;
import org.elasticsearch.search.aggregations.bucket.composite.TermsSortedDocsProducer;

class OrdinalValuesSource
extends SingleDimensionValuesSource<BytesRef> {
    private final LongConsumer breakerConsumer;
    private final CheckedFunction<LeafReaderContext, SortedSetDocValues, IOException> docValuesFunc;
    private SortedSetDocValues lookup;
    private int leafReaderOrd = -1;
    private LongArray valuesOrd;
    private ObjectArray<BytesRef> valuesUnmapped;
    private int numSlots = 0;
    private Long currentValueOrd;
    private BytesRef currentValueUnmapped;
    private Long afterValueOrd;
    private Long lastLookupOrd;
    private BytesRef lastLookupValue;

    OrdinalValuesSource(BigArrays bigArrays, LongConsumer breakerConsumer, MappedFieldType type, CheckedFunction<LeafReaderContext, SortedSetDocValues, IOException> docValuesFunc, DocValueFormat format, boolean missingBucket, int size, int reverseMul) {
        super(bigArrays, format, type, missingBucket, size, reverseMul);
        this.breakerConsumer = breakerConsumer;
        this.docValuesFunc = docValuesFunc;
        this.valuesOrd = bigArrays.newLongArray(Math.min(size, 100), false);
        this.valuesUnmapped = bigArrays.newObjectArray(Math.min(size, 100));
    }

    private boolean invariant() {
        assert ((long)this.numSlots <= this.valuesOrd.size() && this.valuesOrd.size() == this.valuesOrd.size());
        for (int i = 0; i < this.numSlots; ++i) {
            assert (this.ordAndValueConsistency(this.valuesOrd.get(i), this.valuesUnmapped.get(i)));
        }
        if (this.currentValueOrd != null) assert (this.ordAndValueConsistency(this.currentValueOrd, this.currentValueUnmapped));
        if (this.lastLookupOrd != null) assert (this.lastLookupOrd >= 0L && this.lastLookupValue != null);
        return true;
    }

    private boolean ordAndValueConsistency(long ordinal, BytesRef value) {
        block6: {
            assert (ordinal != Long.MIN_VALUE || this.missingBucket);
            assert ((ordinal == Long.MIN_VALUE || ordinal >= 0L) == (value == null));
            try {
                if (ordinal >= 0L) assert (this.lookup.lookupOrd(ordinal) != null);
                if (value != null) assert (this.lookup.lookupTerm(value) == ordinal);
            }
            catch (IOException e) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError((Object)e);
            }
        }
        return true;
    }

    @Override
    void copyCurrent(int slot) {
        this.numSlots = Math.max(this.numSlots, slot + 1);
        this.valuesOrd = this.bigArrays.grow(this.valuesOrd, (long)this.numSlots);
        this.valuesUnmapped = this.bigArrays.grow(this.valuesUnmapped, (long)this.numSlots);
        assert (this.currentValueUnmapped == null);
        this.valuesOrd.set(slot, this.currentValueOrd);
        this.setValueWithBreaking(slot, this.currentValueUnmapped);
    }

    private void setValueWithBreaking(long index, BytesRef newValue) {
        BytesRef previousValue;
        long previousSize;
        long newSize = newValue == null ? 0L : (long)newValue.length;
        long delta = newSize - (previousSize = (previousValue = this.valuesUnmapped.get(index)) == null ? 0L : (long)previousValue.length);
        if (delta != 0L) {
            this.breakerConsumer.accept(delta);
        }
        this.valuesUnmapped.set(index, newValue);
    }

    @Override
    int compare(int from, int to) {
        assert (from < this.numSlots && to < this.numSlots);
        return this.compareInternal(this.valuesOrd.get(from), this.valuesOrd.get(to), this.valuesUnmapped.get(from), this.valuesUnmapped.get(to)) * this.reverseMul;
    }

    @Override
    int compareCurrent(int slot) {
        assert (this.currentValueOrd != null);
        assert (slot < this.numSlots);
        return this.compareInternal(this.currentValueOrd, this.valuesOrd.get(slot), this.currentValueUnmapped, this.valuesUnmapped.get(slot)) * this.reverseMul;
    }

    @Override
    int compareCurrentWithAfter() {
        assert (this.currentValueOrd != null && this.afterValueOrd != null);
        return this.compareInternal(this.currentValueOrd, this.afterValueOrd, this.currentValueUnmapped, (BytesRef)this.afterValue) * this.reverseMul;
    }

    @Override
    int hashCode(int slot) {
        assert (slot < this.numSlots);
        return Long.hashCode(this.valuesOrd.get(slot));
    }

    @Override
    int hashCodeCurrent() {
        assert (this.currentValueOrd != null);
        return Long.hashCode(this.currentValueOrd);
    }

    private int compareInternal(long ord1, long ord2, BytesRef bytesRef1, BytesRef bytesRef2) {
        if (ord1 >= 0L && ord2 >= 0L) {
            return Long.compare(ord1, ord2);
        }
        if (ord1 == Long.MIN_VALUE || ord2 == Long.MIN_VALUE) {
            return Long.compare(ord1, ord2);
        }
        if (ord1 < 0L && ord2 < 0L) {
            if (ord1 == ord2) {
                assert (bytesRef1 != null && bytesRef2 != null);
                return bytesRef1.compareTo(bytesRef2);
            }
            return Long.compare(-ord1 - 1L, -ord2 - 1L);
        }
        if (ord1 < 0L) {
            assert (ord1 < 0L && ord2 >= 0L);
            int cmp = Long.compare(-ord1 - 1L, ord2);
            if (cmp == 0) {
                return -1;
            }
            return cmp;
        }
        assert (ord1 >= 0L && ord2 < 0L);
        int cmp = Long.compare(ord1, -ord2 - 1L);
        if (cmp == 0) {
            return 1;
        }
        return cmp;
    }

    @Override
    void setAfter(Comparable value) {
        assert (this.invariant());
        if (this.missingBucket && value == null) {
            this.afterValue = null;
            this.afterValueOrd = Long.MIN_VALUE;
        } else if (value.getClass() == String.class || this.missingBucket && this.fieldType == null) {
            this.afterValue = this.format.parseBytesRef(value.toString());
            this.afterValueOrd = null;
        } else {
            throw new IllegalArgumentException("invalid value, expected string, got " + value.getClass().getSimpleName());
        }
        assert (this.invariant());
    }

    @Override
    BytesRef toComparable(int slot) throws IOException {
        assert (slot < this.numSlots);
        long ord = this.valuesOrd.get(slot);
        if (ord == Long.MIN_VALUE) {
            assert (this.missingBucket);
            return null;
        }
        if (ord < 0L) {
            return this.valuesUnmapped.get(slot);
        }
        if (this.lastLookupOrd != null && ord == this.lastLookupOrd) {
            assert (ord >= 0L);
            return this.lastLookupValue;
        }
        assert (ord >= 0L);
        this.lastLookupOrd = ord;
        this.lastLookupValue = BytesRef.deepCopyOf(this.lookup.lookupOrd(ord));
        return this.lastLookupValue;
    }

    @Override
    LeafBucketCollector getLeafCollector(LeafReaderContext context, final LeafBucketCollector next) throws IOException {
        boolean leafReaderContextChanged;
        boolean bl = leafReaderContextChanged = context.ord != this.leafReaderOrd;
        assert (!leafReaderContextChanged || this.invariant());
        final SortedSetDocValues dvs = this.docValuesFunc.apply(context);
        if (leafReaderContextChanged) {
            this.remapOrdinals(this.lookup, dvs);
            this.leafReaderOrd = context.ord;
        }
        this.lookup = dvs;
        assert (!leafReaderContextChanged || this.invariant());
        return new LeafBucketCollector(){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                assert (dvs == OrdinalValuesSource.this.lookup);
                if (dvs.advanceExact(doc)) {
                    long ord;
                    while ((ord = dvs.nextOrd()) != -1L) {
                        OrdinalValuesSource.this.currentValueOrd = ord;
                        OrdinalValuesSource.this.currentValueUnmapped = null;
                        next.collect(doc, bucket);
                    }
                } else if (OrdinalValuesSource.this.missingBucket) {
                    OrdinalValuesSource.this.currentValueOrd = Long.MIN_VALUE;
                    OrdinalValuesSource.this.currentValueUnmapped = null;
                    next.collect(doc, bucket);
                }
            }
        };
    }

    @Override
    LeafBucketCollector getLeafCollector(Comparable value, LeafReaderContext context, final LeafBucketCollector next) throws IOException {
        boolean leafReaderContextChanged;
        boolean bl = leafReaderContextChanged = context.ord != this.leafReaderOrd;
        assert (!leafReaderContextChanged || this.invariant());
        if (value.getClass() != BytesRef.class) {
            throw new IllegalArgumentException("Expected BytesRef, got " + value.getClass());
        }
        final BytesRef term = (BytesRef)value;
        final SortedSetDocValues dvs = this.docValuesFunc.apply(context);
        if (leafReaderContextChanged) {
            this.remapOrdinals(this.lookup, dvs);
            this.leafReaderOrd = context.ord;
        }
        this.lookup = dvs;
        assert (!leafReaderContextChanged || this.invariant());
        return new LeafBucketCollector(){
            boolean currentValueIsSet = false;

            @Override
            public void collect(int doc, long bucket) throws IOException {
                assert (dvs == OrdinalValuesSource.this.lookup);
                if (!this.currentValueIsSet && dvs.advanceExact(doc)) {
                    long ord;
                    while ((ord = dvs.nextOrd()) != -1L) {
                        if (!term.equals(dvs.lookupOrd(ord))) continue;
                        this.currentValueIsSet = true;
                        OrdinalValuesSource.this.currentValueOrd = ord;
                        OrdinalValuesSource.this.currentValueUnmapped = null;
                        break;
                    }
                }
                assert (this.currentValueIsSet);
                next.collect(doc, bucket);
            }
        };
    }

    private void remapOrdinals(SortedSetDocValues oldMapping, SortedSetDocValues newMapping) throws IOException {
        for (int i = 0; i < this.numSlots; ++i) {
            long newOrd;
            long oldOrd = this.valuesOrd.get(i);
            if (oldOrd == Long.MIN_VALUE) continue;
            if (oldOrd >= 0L) {
                BytesRef newVal = oldMapping.lookupOrd(oldOrd);
                newOrd = newMapping.lookupTerm(newVal);
                if (newOrd < 0L) {
                    this.setValueWithBreaking(i, BytesRef.deepCopyOf(newVal));
                }
            } else {
                newOrd = newMapping.lookupTerm(this.valuesUnmapped.get(i));
                if (newOrd >= 0L) {
                    this.setValueWithBreaking(i, null);
                }
            }
            this.valuesOrd.set(i, newOrd);
        }
        if (this.currentValueOrd != null && this.currentValueOrd != Long.MIN_VALUE) {
            long newOrd;
            if (this.currentValueOrd >= 0L) {
                BytesRef newVal = oldMapping.lookupOrd(this.currentValueOrd);
                newOrd = newMapping.lookupTerm(newVal);
                if (newOrd < 0L) {
                    this.currentValueUnmapped = BytesRef.deepCopyOf(newVal);
                }
            } else {
                newOrd = newMapping.lookupTerm(this.currentValueUnmapped);
                if (newOrd >= 0L) {
                    this.currentValueUnmapped = null;
                }
            }
            this.currentValueOrd = newOrd;
        }
        if (this.afterValue != null) {
            this.afterValueOrd = newMapping.lookupTerm((BytesRef)this.afterValue);
        }
        this.lastLookupOrd = null;
        this.lastLookupValue = null;
    }

    @Override
    public boolean requiresRehashingWhenSwitchingLeafReaders() {
        return true;
    }

    @Override
    SortedDocsProducer createSortedDocsProducerOrNull(IndexReader reader, Query query) {
        if (!this.checkIfSortedDocsIsApplicable(reader, this.fieldType) || !(this.fieldType instanceof StringFieldType) || query != null && query.getClass() != MatchAllDocsQuery.class) {
            return null;
        }
        return new TermsSortedDocsProducer(this.fieldType.name());
    }

    @Override
    public void close() {
        Releasables.close(this.valuesOrd, this.valuesUnmapped);
    }
}

