/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.DelayedBucket;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;

public class TopBucketBuilder<B extends InternalMultiBucketAggregation.InternalBucket> {
    private final Consumer<DelayedBucket<B>> nonCompetitive;
    private final PriorityQueue<DelayedBucket<B>> queue;

    public TopBucketBuilder(int size, final BucketOrder order, Consumer<DelayedBucket<B>> nonCompetitive) {
        this.nonCompetitive = nonCompetitive;
        this.queue = new PriorityQueue<DelayedBucket<B>>(size){
            private final Comparator<DelayedBucket<? extends MultiBucketsAggregation.Bucket>> comparator;
            {
                super(arg0);
                this.comparator = order.delayedBucketComparator();
            }

            @Override
            protected boolean lessThan(DelayedBucket<B> a, DelayedBucket<B> b) {
                return this.comparator.compare(a, b) > 0;
            }
        };
    }

    public void add(DelayedBucket<B> bucket) {
        DelayedBucket<B> removed = this.queue.insertWithOverflow(bucket);
        if (removed != null) {
            this.nonCompetitive.accept(removed);
            removed.nonCompetitive();
        }
    }

    public List<B> build() {
        ArrayList<B> result = new ArrayList<B>(this.queue.size());
        for (int i = this.queue.size() - 1; i >= 0; --i) {
            result.add(this.queue.pop().reduced());
        }
        Collections.reverse(result);
        return result;
    }
}

