/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.MapXContentParser;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.ArraySourceValueFetcher;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;

public abstract class AbstractGeometryFieldMapper<T>
extends FieldMapper {
    private final Explicit<Boolean> ignoreMalformed;
    private final Explicit<Boolean> ignoreZValue;
    private final Parser<T> parser;

    public static FieldMapper.Parameter<Explicit<Boolean>> ignoreMalformedParam(Function<FieldMapper, Explicit<Boolean>> initializer, boolean ignoreMalformedByDefault) {
        return FieldMapper.Parameter.explicitBoolParam("ignore_malformed", true, initializer, ignoreMalformedByDefault);
    }

    public static FieldMapper.Parameter<Explicit<Boolean>> ignoreZValueParam(Function<FieldMapper, Explicit<Boolean>> initializer) {
        return FieldMapper.Parameter.explicitBoolParam("ignore_z_value", true, initializer, true);
    }

    protected AbstractGeometryFieldMapper(String simpleName, MappedFieldType mappedFieldType, Map<String, NamedAnalyzer> indexAnalyzers, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> ignoreZValue, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Parser<T> parser) {
        super(simpleName, mappedFieldType, indexAnalyzers, multiFields, copyTo, false, null);
        this.ignoreMalformed = ignoreMalformed;
        this.ignoreZValue = ignoreZValue;
        this.parser = parser;
    }

    protected AbstractGeometryFieldMapper(String simpleName, MappedFieldType mappedFieldType, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> ignoreZValue, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Parser<T> parser) {
        this(simpleName, mappedFieldType, Collections.emptyMap(), ignoreMalformed, ignoreZValue, multiFields, copyTo, parser);
    }

    protected AbstractGeometryFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Parser<T> parser, String onScriptError) {
        super(simpleName, mappedFieldType, Collections.emptyMap(), multiFields, copyTo, true, onScriptError);
        this.ignoreMalformed = new Explicit<Boolean>(false, true);
        this.ignoreZValue = new Explicit<Boolean>(false, true);
        this.parser = parser;
    }

    @Override
    public AbstractGeometryFieldType<T> fieldType() {
        return (AbstractGeometryFieldType)this.mappedFieldType;
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        throw new UnsupportedOperationException("Parsing is implemented in parse(), this method should NEVER be called");
    }

    protected abstract void index(ParseContext var1, T var2) throws IOException;

    @Override
    public final void parse(ParseContext context) throws IOException {
        if (this.hasScript) {
            throw new MapperParsingException("failed to parse field [" + this.fieldType().name() + "] of type + " + this.contentType() + "]", new IllegalArgumentException("Cannot index data directly into a field with a [script] parameter"));
        }
        this.parser.parse(context.parser(), v -> this.index(context, v), e -> {
            if (!this.ignoreMalformed()) {
                throw new MapperParsingException("failed to parse field [" + this.fieldType().name() + "] of type [" + this.contentType() + "]", (Throwable)e);
            }
            context.addIgnoredField(this.fieldType().name());
        });
    }

    public boolean ignoreMalformed() {
        return this.ignoreMalformed.value();
    }

    public boolean ignoreZValue() {
        return this.ignoreZValue.value();
    }

    @Override
    public final boolean parsesArrayValue() {
        return true;
    }

    public static abstract class Parser<T> {
        public abstract void parse(XContentParser var1, CheckedConsumer<T, IOException> var2, Consumer<Exception> var3) throws IOException;

        private void fetchFromSource(Object sourceMap, Consumer<Object> consumer, Function<T, Object> formatter) {
            try (XContentParser parser = MapXContentParser.wrapObject(sourceMap);){
                this.parse(parser, v -> consumer.accept(formatter.apply(v)), e -> {});
            }
            catch (IOException e2) {
                throw new UncheckedIOException(e2);
            }
        }
    }

    public static abstract class AbstractGeometryFieldType<T>
    extends MappedFieldType {
        protected final Parser<T> geometryParser;

        protected AbstractGeometryFieldType(String name, boolean indexed, boolean stored, boolean hasDocValues, Parser<T> geometryParser, Map<String, String> meta) {
            super(name, indexed, stored, hasDocValues, TextSearchInfo.NONE, meta);
            this.geometryParser = geometryParser;
        }

        @Override
        public final Query termQuery(Object value, SearchExecutionContext context) {
            throw new IllegalArgumentException("Geometry fields do not support exact searching, use dedicated geometry queries instead: [" + this.name() + "]");
        }

        protected abstract Function<T, Object> getFormatter(String var1);

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            final Function<T, Object> formatter = this.getFormatter(format != null ? format : "geojson");
            return new ArraySourceValueFetcher(this.name(), context){

                @Override
                protected Object parseSourceValue(Object value) {
                    ArrayList values = new ArrayList();
                    geometryParser.fetchFromSource(value, values::add, formatter);
                    return values;
                }
            };
        }
    }
}

