/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec;

import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.lucene87.Lucene87Codec;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.codec.PerFieldMappingPostingFormatCodec;
import org.elasticsearch.index.mapper.MapperService;

public class CodecService {
    private final Map<String, Codec> codecs;
    public static final String DEFAULT_CODEC = "default";
    public static final String BEST_COMPRESSION_CODEC = "best_compression";
    public static final String LUCENE_DEFAULT_CODEC = "lucene_default";

    public CodecService(@Nullable MapperService mapperService, Logger logger) {
        MapBuilder<String, Codec> codecs = MapBuilder.newMapBuilder();
        if (mapperService == null) {
            codecs.put(DEFAULT_CODEC, new Lucene87Codec());
            codecs.put(BEST_COMPRESSION_CODEC, new Lucene87Codec(Lucene87Codec.Mode.BEST_COMPRESSION));
        } else {
            codecs.put(DEFAULT_CODEC, new PerFieldMappingPostingFormatCodec(Lucene87Codec.Mode.BEST_SPEED, mapperService, logger));
            codecs.put(BEST_COMPRESSION_CODEC, new PerFieldMappingPostingFormatCodec(Lucene87Codec.Mode.BEST_COMPRESSION, mapperService, logger));
        }
        codecs.put(LUCENE_DEFAULT_CODEC, Codec.getDefault());
        for (String codec : Codec.availableCodecs()) {
            codecs.put(codec, Codec.forName(codec));
        }
        this.codecs = codecs.immutableMap();
    }

    public Codec codec(String name) {
        Codec codec = this.codecs.get(name);
        if (codec == null) {
            throw new IllegalArgumentException("failed to find codec [" + name + "]");
        }
        return codec;
    }

    public String[] availableCodecs() {
        return this.codecs.keySet().toArray(new String[0]);
    }
}

