/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.WrappedRunnable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.http.HttpTransportSettings;

public final class ThreadContext
implements Writeable {
    public static final String PREFIX = "request.headers";
    public static final Setting<Settings> DEFAULT_HEADERS_SETTING = Setting.groupSetting("request.headers.", Setting.Property.NodeScope);
    public static final String ACTION_ORIGIN_TRANSIENT_NAME = "action.origin";
    private static final Logger logger = LogManager.getLogger(ThreadContext.class);
    private static final ThreadContextStruct DEFAULT_CONTEXT = new ThreadContextStruct();
    private final Map<String, String> defaultHeader;
    private final ThreadLocal<ThreadContextStruct> threadLocal;
    private final int maxWarningHeaderCount;
    private final long maxWarningHeaderSize;
    private static final Collector<String, Set<String>, Set<String>> LINKED_HASH_SET_COLLECTOR = new LinkedHashSetCollector<String>();

    public ThreadContext(Settings settings) {
        this.defaultHeader = ThreadContext.buildDefaultHeaders(settings);
        this.threadLocal = ThreadLocal.withInitial(() -> DEFAULT_CONTEXT);
        this.maxWarningHeaderCount = HttpTransportSettings.SETTING_HTTP_MAX_WARNING_HEADER_COUNT.get(settings);
        this.maxWarningHeaderSize = HttpTransportSettings.SETTING_HTTP_MAX_WARNING_HEADER_SIZE.get(settings).getBytes();
    }

    public StoredContext stashContext() {
        ThreadContextStruct context = this.threadLocal.get();
        if (context.requestHeaders.containsKey("X-Opaque-Id")) {
            ThreadContextStruct threadContextStruct = ThreadContext.DEFAULT_CONTEXT.putHeaders(MapBuilder.newMapBuilder().put("X-Opaque-Id", (String)context.requestHeaders.get("X-Opaque-Id")).immutableMap());
            this.threadLocal.set(threadContextStruct);
        } else {
            this.threadLocal.set(DEFAULT_CONTEXT);
        }
        return () -> this.threadLocal.set(context);
    }

    public Writeable captureAsWriteable() {
        ThreadContextStruct context = this.threadLocal.get();
        return out -> context.writeTo(out, this.defaultHeader);
    }

    public StoredContext stashWithOrigin(String origin) {
        StoredContext storedContext = this.stashContext();
        this.putTransient(ACTION_ORIGIN_TRANSIENT_NAME, origin);
        return storedContext;
    }

    public StoredContext stashAndMergeHeaders(Map<String, String> headers) {
        ThreadContextStruct context = this.threadLocal.get();
        HashMap<String, String> newHeader = new HashMap<String, String>(headers);
        newHeader.putAll(context.requestHeaders);
        this.threadLocal.set(ThreadContext.DEFAULT_CONTEXT.putHeaders(newHeader));
        return () -> this.threadLocal.set(context);
    }

    public StoredContext newStoredContext(boolean preserveResponseHeaders) {
        return this.newStoredContext(preserveResponseHeaders, Collections.emptyList());
    }

    public StoredContext newStoredContext(boolean preserveResponseHeaders, Collection<String> transientHeadersToClear) {
        ThreadContextStruct originalContext = this.threadLocal.get();
        HashMap newTransientHeaders = null;
        for (String transientHeaderToClear : transientHeadersToClear) {
            if (!originalContext.transientHeaders.containsKey(transientHeaderToClear)) continue;
            if (newTransientHeaders == null) {
                newTransientHeaders = new HashMap(originalContext.transientHeaders);
            }
            newTransientHeaders.remove(transientHeaderToClear);
        }
        if (newTransientHeaders != null) {
            ThreadContextStruct threadContextStruct = new ThreadContextStruct(originalContext.requestHeaders, originalContext.responseHeaders, newTransientHeaders, originalContext.isSystemContext, originalContext.warningHeadersSize);
            this.threadLocal.set(threadContextStruct);
        }
        ThreadContextStruct newContext = this.threadLocal.get();
        return () -> {
            if (preserveResponseHeaders && this.threadLocal.get() != newContext) {
                this.threadLocal.set(originalContext.putResponseHeaders(this.threadLocal.get().responseHeaders));
            } else {
                this.threadLocal.set(originalContext);
            }
        };
    }

    public Supplier<StoredContext> newRestorableContext(boolean preserveResponseHeaders) {
        return this.wrapRestorable(this.newStoredContext(preserveResponseHeaders));
    }

    public Supplier<StoredContext> wrapRestorable(StoredContext storedContext) {
        return () -> {
            StoredContext context = this.newStoredContext(false);
            storedContext.restore();
            return context;
        };
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.threadLocal.get().writeTo(out, this.defaultHeader);
    }

    public void readHeaders(StreamInput in) throws IOException {
        this.setHeaders(ThreadContext.readHeadersFromStream(in));
    }

    public void setHeaders(Tuple<Map<String, String>, Map<String, Set<String>>> headerTuple) {
        Map<String, String> requestHeaders = headerTuple.v1();
        Map<String, Set<String>> responseHeaders = headerTuple.v2();
        ThreadContextStruct struct = requestHeaders.isEmpty() && responseHeaders.isEmpty() ? ThreadContextStruct.EMPTY : new ThreadContextStruct(requestHeaders, responseHeaders, Collections.emptyMap(), false);
        this.threadLocal.set(struct);
    }

    public static Tuple<Map<String, String>, Map<String, Set<String>>> readHeadersFromStream(StreamInput in) throws IOException {
        Map<String, String> requestHeaders = in.readMap(StreamInput::readString, StreamInput::readString);
        Map<String, Set> responseHeaders = in.readMap(StreamInput::readString, input -> {
            int size = input.readVInt();
            if (size == 0) {
                return Collections.emptySet();
            }
            if (size == 1) {
                return Collections.singleton(input.readString());
            }
            LinkedHashSet<String> values = new LinkedHashSet<String>(size);
            for (int i = 0; i < size; ++i) {
                String value = input.readString();
                boolean added = values.add(value);
                assert (added) : value;
            }
            return values;
        });
        return new Tuple<Map<String, String>, Map<String, Set<String>>>(requestHeaders, responseHeaders);
    }

    public String getHeader(String key) {
        String value = (String)this.threadLocal.get().requestHeaders.get(key);
        if (value == null) {
            return this.defaultHeader.get(key);
        }
        return value;
    }

    public Map<String, String> getHeaders() {
        HashMap<String, String> map = new HashMap<String, String>(this.defaultHeader);
        map.putAll(this.threadLocal.get().requestHeaders);
        return Collections.unmodifiableMap(map);
    }

    public Map<String, String> getRequestHeadersOnly() {
        return Collections.unmodifiableMap(new HashMap(this.threadLocal.get().requestHeaders));
    }

    public Map<String, List<String>> getResponseHeaders() {
        Map responseHeaders = this.threadLocal.get().responseHeaders;
        HashMap map = new HashMap(responseHeaders.size());
        for (Map.Entry entry : responseHeaders.entrySet()) {
            map.put((String)entry.getKey(), Collections.unmodifiableList(new ArrayList((Collection)entry.getValue())));
        }
        return Collections.unmodifiableMap(map);
    }

    public void copyHeaders(Iterable<Map.Entry<String, String>> headers) {
        this.threadLocal.set(this.threadLocal.get().copyHeaders(headers));
    }

    public void putHeader(String key, String value) {
        this.threadLocal.set(this.threadLocal.get().putRequest(key, value));
    }

    public void putHeader(Map<String, String> header) {
        this.threadLocal.set(this.threadLocal.get().putHeaders(header));
    }

    public void putTransient(String key, Object value) {
        this.threadLocal.set(this.threadLocal.get().putTransient(key, value));
    }

    public <T> T getTransient(String key) {
        return (T)this.threadLocal.get().transientHeaders.get(key);
    }

    public void addResponseHeader(String key, String value) {
        this.addResponseHeader(key, value, v -> v);
    }

    public void addResponseHeader(String key, String value, Function<String, String> uniqueValue) {
        this.threadLocal.set(this.threadLocal.get().putResponse(key, value, uniqueValue, this.maxWarningHeaderCount, this.maxWarningHeaderSize));
    }

    public Runnable preserveContext(Runnable command) {
        if (command instanceof ContextPreservingAbstractRunnable) {
            return command;
        }
        if (command instanceof ContextPreservingRunnable) {
            return command;
        }
        if (command instanceof AbstractRunnable) {
            return new ContextPreservingAbstractRunnable((AbstractRunnable)command);
        }
        return new ContextPreservingRunnable(command);
    }

    public Runnable unwrap(Runnable command) {
        if (command instanceof WrappedRunnable) {
            return ((WrappedRunnable)command).unwrap();
        }
        return command;
    }

    boolean isDefaultContext() {
        return this.threadLocal.get() == DEFAULT_CONTEXT;
    }

    public void markAsSystemContext() {
        this.threadLocal.set(this.threadLocal.get().setSystemContext());
    }

    public boolean isSystemContext() {
        return this.threadLocal.get().isSystemContext;
    }

    public static Map<String, String> buildDefaultHeaders(Settings settings) {
        Settings headers = DEFAULT_HEADERS_SETTING.get(settings);
        if (headers == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> defaultHeader = new HashMap<String, String>();
        for (String key : headers.names()) {
            defaultHeader.put(key, headers.get(key));
        }
        return Collections.unmodifiableMap(defaultHeader);
    }

    private static final class ThreadContextStruct {
        private static final ThreadContextStruct EMPTY = new ThreadContextStruct(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), false);
        private final Map<String, String> requestHeaders;
        private final Map<String, Object> transientHeaders;
        private final Map<String, Set<String>> responseHeaders;
        private final boolean isSystemContext;
        private final long warningHeadersSize;

        private ThreadContextStruct setSystemContext() {
            if (this.isSystemContext) {
                return this;
            }
            return new ThreadContextStruct(this.requestHeaders, this.responseHeaders, this.transientHeaders, true);
        }

        private ThreadContextStruct(Map<String, String> requestHeaders, Map<String, Set<String>> responseHeaders, Map<String, Object> transientHeaders, boolean isSystemContext) {
            this.requestHeaders = requestHeaders;
            this.responseHeaders = responseHeaders;
            this.transientHeaders = transientHeaders;
            this.isSystemContext = isSystemContext;
            this.warningHeadersSize = 0L;
        }

        private ThreadContextStruct(Map<String, String> requestHeaders, Map<String, Set<String>> responseHeaders, Map<String, Object> transientHeaders, boolean isSystemContext, long warningHeadersSize) {
            this.requestHeaders = requestHeaders;
            this.responseHeaders = responseHeaders;
            this.transientHeaders = transientHeaders;
            this.isSystemContext = isSystemContext;
            this.warningHeadersSize = warningHeadersSize;
        }

        private ThreadContextStruct() {
            this(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), false);
        }

        private ThreadContextStruct putRequest(String key, String value) {
            HashMap<String, String> newRequestHeaders = new HashMap<String, String>(this.requestHeaders);
            ThreadContextStruct.putSingleHeader(key, value, newRequestHeaders);
            return new ThreadContextStruct(newRequestHeaders, this.responseHeaders, this.transientHeaders, this.isSystemContext);
        }

        private static <T> void putSingleHeader(String key, T value, Map<String, T> newHeaders) {
            if (newHeaders.putIfAbsent(key, value) != null) {
                throw new IllegalArgumentException("value for key [" + key + "] already present");
            }
        }

        private ThreadContextStruct putHeaders(Map<String, String> headers) {
            if (headers.isEmpty()) {
                return this;
            }
            HashMap<String, String> newHeaders = new HashMap<String, String>(this.requestHeaders);
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                ThreadContextStruct.putSingleHeader(entry.getKey(), entry.getValue(), newHeaders);
            }
            return new ThreadContextStruct(newHeaders, this.responseHeaders, this.transientHeaders, this.isSystemContext);
        }

        private ThreadContextStruct putResponseHeaders(Map<String, Set<String>> headers) {
            assert (headers != null);
            if (headers.isEmpty()) {
                return this;
            }
            HashMap<String, Set<String>> newResponseHeaders = new HashMap<String, Set<String>>(this.responseHeaders);
            for (Map.Entry<String, Set<String>> entry : headers.entrySet()) {
                String key = entry.getKey();
                Set existingValues = (Set)newResponseHeaders.get(key);
                if (existingValues != null) {
                    Set newValues = (Set)Stream.concat(entry.getValue().stream(), existingValues.stream()).collect(LINKED_HASH_SET_COLLECTOR);
                    newResponseHeaders.put(key, Collections.unmodifiableSet(newValues));
                    continue;
                }
                newResponseHeaders.put(key, entry.getValue());
            }
            return new ThreadContextStruct(this.requestHeaders, newResponseHeaders, this.transientHeaders, this.isSystemContext);
        }

        private ThreadContextStruct putResponse(String key, String value, Function<String, String> uniqueValue, int maxWarningHeaderCount, long maxWarningHeaderSize) {
            HashMap<String, Set<String>> newResponseHeaders;
            Set<String> existingValues;
            assert (value != null);
            long newWarningHeaderSize = this.warningHeadersSize;
            if (key.equals("Warning") && maxWarningHeaderSize != -1L) {
                if (this.warningHeadersSize > maxWarningHeaderSize) {
                    logger.warn("Dropping a warning header, as their total size reached the maximum allowed of [" + maxWarningHeaderSize + "] bytes set in [" + HttpTransportSettings.SETTING_HTTP_MAX_WARNING_HEADER_SIZE.getKey() + "]!");
                    return this;
                }
                if ((newWarningHeaderSize += (long)("Warning".getBytes(StandardCharsets.UTF_8).length + value.getBytes(StandardCharsets.UTF_8).length)) > maxWarningHeaderSize) {
                    logger.warn("Dropping a warning header, as their total size reached the maximum allowed of [" + maxWarningHeaderSize + "] bytes set in [" + HttpTransportSettings.SETTING_HTTP_MAX_WARNING_HEADER_SIZE.getKey() + "]!");
                    return new ThreadContextStruct(this.requestHeaders, this.responseHeaders, this.transientHeaders, this.isSystemContext, newWarningHeaderSize);
                }
            }
            if ((existingValues = this.responseHeaders.get(key)) != null) {
                if (existingValues.contains(uniqueValue.apply(value))) {
                    return this;
                }
                Set newValues = (Set)Stream.concat(existingValues.stream(), Stream.of(value)).collect(LINKED_HASH_SET_COLLECTOR);
                newResponseHeaders = new HashMap<String, Set<String>>(this.responseHeaders);
                newResponseHeaders.put(key, Collections.unmodifiableSet(newValues));
            } else {
                newResponseHeaders = new HashMap<String, Set<String>>(this.responseHeaders);
                newResponseHeaders.put(key, Collections.singleton(value));
            }
            if (key.equals("Warning") && maxWarningHeaderCount != -1) {
                int warningHeaderCount;
                int n = warningHeaderCount = newResponseHeaders.containsKey("Warning") ? ((Set)newResponseHeaders.get("Warning")).size() : 0;
                if (warningHeaderCount > maxWarningHeaderCount) {
                    logger.warn("Dropping a warning header, as their total count reached the maximum allowed of [" + maxWarningHeaderCount + "] set in [" + HttpTransportSettings.SETTING_HTTP_MAX_WARNING_HEADER_COUNT.getKey() + "]!");
                    return this;
                }
            }
            return new ThreadContextStruct(this.requestHeaders, newResponseHeaders, this.transientHeaders, this.isSystemContext, newWarningHeaderSize);
        }

        private ThreadContextStruct putTransient(String key, Object value) {
            HashMap<String, Object> newTransient = new HashMap<String, Object>(this.transientHeaders);
            ThreadContextStruct.putSingleHeader(key, value, newTransient);
            return new ThreadContextStruct(this.requestHeaders, this.responseHeaders, newTransient, this.isSystemContext);
        }

        private ThreadContextStruct copyHeaders(Iterable<Map.Entry<String, String>> headers) {
            HashMap<String, String> newHeaders = new HashMap<String, String>();
            for (Map.Entry<String, String> header : headers) {
                newHeaders.put(header.getKey(), header.getValue());
            }
            return this.putHeaders(newHeaders);
        }

        private void writeTo(StreamOutput out, Map<String, String> defaultHeaders) throws IOException {
            Map<String, String> requestHeaders;
            if (defaultHeaders.isEmpty()) {
                requestHeaders = this.requestHeaders;
            } else {
                requestHeaders = new HashMap<String, String>(defaultHeaders);
                requestHeaders.putAll(this.requestHeaders);
            }
            out.writeVInt(requestHeaders.size());
            for (Map.Entry<String, String> entry : requestHeaders.entrySet()) {
                out.writeString(entry.getKey());
                out.writeString(entry.getValue());
            }
            out.writeMap(this.responseHeaders, StreamOutput::writeString, StreamOutput::writeStringCollection);
        }
    }

    @FunctionalInterface
    public static interface StoredContext
    extends AutoCloseable {
        @Override
        public void close();

        default public void restore() {
            this.close();
        }
    }

    private class ContextPreservingAbstractRunnable
    extends AbstractRunnable
    implements WrappedRunnable {
        private final AbstractRunnable in;
        private final StoredContext creatorsContext;
        private StoredContext threadsOriginalContext = null;

        private ContextPreservingAbstractRunnable(AbstractRunnable in) {
            this.creatorsContext = ThreadContext.this.newStoredContext(false);
            this.in = in;
        }

        @Override
        public boolean isForceExecution() {
            return this.in.isForceExecution();
        }

        @Override
        public void onAfter() {
            try {
                this.in.onAfter();
            }
            finally {
                if (this.threadsOriginalContext != null) {
                    this.threadsOriginalContext.restore();
                }
            }
        }

        @Override
        public void onFailure(Exception e) {
            this.in.onFailure(e);
        }

        @Override
        public void onRejection(Exception e) {
            this.in.onRejection(e);
        }

        @Override
        protected void doRun() throws Exception {
            this.threadsOriginalContext = ThreadContext.this.stashContext();
            this.creatorsContext.restore();
            this.in.doRun();
        }

        public String toString() {
            return this.in.toString();
        }

        @Override
        public AbstractRunnable unwrap() {
            return this.in;
        }
    }

    private class ContextPreservingRunnable
    implements WrappedRunnable {
        private final Runnable in;
        private final StoredContext ctx;

        private ContextPreservingRunnable(Runnable in) {
            this.ctx = ThreadContext.this.newStoredContext(false);
            this.in = in;
        }

        @Override
        public void run() {
            try (StoredContext ignore = ThreadContext.this.stashContext();){
                this.ctx.restore();
                this.in.run();
            }
        }

        public String toString() {
            return this.in.toString();
        }

        @Override
        public Runnable unwrap() {
            return this.in;
        }
    }

    private static class LinkedHashSetCollector<T>
    implements Collector<T, Set<T>, Set<T>> {
        private static final Set<Collector.Characteristics> CHARACTERISTICS = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.IDENTITY_FINISH));

        private LinkedHashSetCollector() {
        }

        @Override
        public Supplier<Set<T>> supplier() {
            return LinkedHashSet::new;
        }

        @Override
        public BiConsumer<Set<T>, T> accumulator() {
            return Set::add;
        }

        @Override
        public BinaryOperator<Set<T>> combiner() {
            return (left, right) -> {
                left.addAll(right);
                return left;
            };
        }

        @Override
        public Function<Set<T>, Set<T>> finisher() {
            return Function.identity();
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return CHARACTERISTICS;
        }
    }
}

