/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.elasticsearch.Version;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Releasable;

public abstract class DelayableWriteable<T extends Writeable>
implements Writeable,
Releasable {
    public static <T extends Writeable> DelayableWriteable<T> referencing(T reference) {
        return new Referencing(reference, null);
    }

    public static <T extends Writeable> DelayableWriteable<T> delayed(Writeable.Reader<T> reader, StreamInput in) throws IOException {
        return new Serialized(reader, in.getVersion(), in.namedWriteableRegistry(), in.readReleasableBytesReference());
    }

    private DelayableWriteable() {
    }

    public abstract Serialized<T> asSerialized(Writeable.Reader<T> var1, NamedWriteableRegistry var2);

    public abstract T expand();

    abstract boolean isSerialized();

    public abstract long getSerializedSize();

    public static long getSerializedSize(Writeable ref) {
        long l;
        CountingStreamOutput out = new CountingStreamOutput();
        try {
            out.setVersion(Version.CURRENT);
            ref.writeTo(out);
            l = out.size;
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exc) {
                throw new UncheckedIOException(exc);
            }
        }
        out.close();
        return l;
    }

    private static class Referencing<T extends Writeable>
    extends DelayableWriteable<T> {
        private final T reference;

        private Referencing(T reference) {
            this.reference = reference;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeBytesReference(this.writeToBuffer(out.getVersion()).bytes());
        }

        @Override
        public T expand() {
            return this.reference;
        }

        @Override
        public Serialized<T> asSerialized(Writeable.Reader<T> reader, NamedWriteableRegistry registry) {
            BytesStreamOutput buffer;
            try {
                buffer = this.writeToBuffer(Version.CURRENT);
            }
            catch (IOException e) {
                throw new RuntimeException("unexpected error writing writeable to buffer", e);
            }
            return new Serialized(reader, Version.CURRENT, registry, ReleasableBytesReference.wrap(buffer.bytes()));
        }

        @Override
        boolean isSerialized() {
            return false;
        }

        @Override
        public long getSerializedSize() {
            return DelayableWriteable.getSerializedSize(this.reference);
        }

        private BytesStreamOutput writeToBuffer(Version version) throws IOException {
            try (BytesStreamOutput buffer = new BytesStreamOutput();){
                buffer.setVersion(version);
                this.reference.writeTo(buffer);
                BytesStreamOutput bytesStreamOutput = buffer;
                return bytesStreamOutput;
            }
        }

        @Override
        public void close() {
        }

        /* synthetic */ Referencing(Writeable x0, 1 x1) {
            this(x0);
        }
    }

    public static class Serialized<T extends Writeable>
    extends DelayableWriteable<T> {
        private final Writeable.Reader<T> reader;
        private final Version serializedAtVersion;
        private final NamedWriteableRegistry registry;
        private final ReleasableBytesReference serialized;

        private Serialized(Writeable.Reader<T> reader, Version serializedAtVersion, NamedWriteableRegistry registry, ReleasableBytesReference serialized) {
            this.reader = reader;
            this.serializedAtVersion = serializedAtVersion;
            this.registry = registry;
            this.serialized = serialized;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (out.getVersion() == this.serializedAtVersion) {
                out.writeBytesReference(this.serialized);
            } else {
                Serialized.referencing(this.expand()).writeTo(out);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public T expand() {
            try (StreamInput in = this.registry == null ? this.serialized.streamInput() : new NamedWriteableAwareStreamInput(this.serialized.streamInput(), this.registry);){
                in.setVersion(this.serializedAtVersion);
                Writeable writeable = (Writeable)this.reader.read(in);
                return (T)writeable;
            }
            catch (IOException e) {
                throw new RuntimeException("unexpected error expanding serialized delayed writeable", e);
            }
        }

        @Override
        public Serialized<T> asSerialized(Writeable.Reader<T> reader, NamedWriteableRegistry registry) {
            return this;
        }

        @Override
        boolean isSerialized() {
            return true;
        }

        @Override
        public long getSerializedSize() {
            return this.serialized.length();
        }

        @Override
        public void close() {
            this.serialized.close();
        }
    }

    private static class CountingStreamOutput
    extends StreamOutput {
        long size = 0L;

        private CountingStreamOutput() {
        }

        @Override
        public void writeByte(byte b) throws IOException {
            ++this.size;
        }

        @Override
        public void writeBytes(byte[] b, int offset, int length) throws IOException {
            this.size += (long)length;
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void reset() throws IOException {
            this.size = 0L;
        }

        public long length() {
            return this.size;
        }
    }
}

