/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.ActiveShardsObserver;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.ClusterStateUpdateRequest;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataCreateDataStreamService;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Map;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;

public class MetadataMigrateToDataStreamService {
    private static final Logger logger = LogManager.getLogger(MetadataMigrateToDataStreamService.class);
    private final ClusterService clusterService;
    private final ActiveShardsObserver activeShardsObserver;
    private final IndicesService indexServices;
    private final ThreadContext threadContext;
    private final MetadataCreateIndexService metadataCreateIndexService;

    public MetadataMigrateToDataStreamService(ThreadPool threadPool, ClusterService clusterService, IndicesService indexServices, MetadataCreateIndexService metadataCreateIndexService) {
        this.clusterService = clusterService;
        this.indexServices = indexServices;
        this.activeShardsObserver = new ActiveShardsObserver(clusterService, threadPool);
        this.threadContext = threadPool.getThreadContext();
        this.metadataCreateIndexService = metadataCreateIndexService;
    }

    public void migrateToDataStream(final MigrateToDataStreamClusterStateUpdateRequest request, ActionListener<AcknowledgedResponse> finalListener) {
        this.metadataCreateIndexService.getSystemIndices().validateDataStreamAccess(request.aliasName, this.threadContext);
        final AtomicReference writeIndexRef = new AtomicReference();
        ActionListener<AcknowledgedResponse> listener = ActionListener.wrap(response -> {
            if (response.isAcknowledged()) {
                String writeIndexName = (String)writeIndexRef.get();
                assert (writeIndexName != null);
                this.activeShardsObserver.waitForActiveShards(new String[]{writeIndexName}, ActiveShardCount.DEFAULT, request.masterNodeTimeout(), shardsAcked -> finalListener.onResponse(AcknowledgedResponse.TRUE), finalListener::onFailure);
            } else {
                finalListener.onResponse(AcknowledgedResponse.FALSE);
            }
        }, finalListener::onFailure);
        this.clusterService.submitStateUpdateTask("migrate-to-data-stream [" + request.aliasName + "]", new AckedClusterStateUpdateTask(Priority.HIGH, request, listener){

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                ClusterState clusterState = MetadataMigrateToDataStreamService.migrateToDataStream(currentState, indexMetadata -> {
                    try {
                        return MetadataMigrateToDataStreamService.this.indexServices.createIndexMapperService((IndexMetadata)indexMetadata);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                }, request, MetadataMigrateToDataStreamService.this.threadContext, MetadataMigrateToDataStreamService.this.metadataCreateIndexService);
                writeIndexRef.set(clusterState.metadata().dataStreams().get(request.aliasName).getWriteIndex().getName());
                return clusterState;
            }
        });
    }

    static ClusterState migrateToDataStream(ClusterState currentState, Function<IndexMetadata, MapperService> mapperSupplier, MigrateToDataStreamClusterStateUpdateRequest request, ThreadContext threadContext, MetadataCreateIndexService metadataCreateIndexService) throws Exception {
        if (currentState.nodes().getMinNodeVersion().before(Version.V_7_11_0)) {
            throw new IllegalStateException("data stream migration requires minimum node version of " + Version.V_7_11_0);
        }
        MetadataMigrateToDataStreamService.validateRequest(currentState, request);
        IndexAbstraction.Alias alias = (IndexAbstraction.Alias)currentState.metadata().getIndicesLookup().get(request.aliasName);
        MetadataMigrateToDataStreamService.validateBackingIndices(currentState, request.aliasName);
        Metadata.Builder mb = Metadata.builder(currentState.metadata());
        for (IndexMetadata im : alias.getIndices()) {
            MetadataMigrateToDataStreamService.prepareBackingIndex(mb, im, request.aliasName, mapperSupplier);
        }
        currentState = ClusterState.builder(currentState).metadata(mb).build();
        IndexMetadata writeIndex = alias.getWriteIndex();
        List<IndexMetadata> backingIndices = alias.getIndices().stream().filter(x -> writeIndex == null || !x.getIndex().getName().equals(writeIndex.getIndex().getName())).collect(Collectors.toList());
        logger.info("submitting request to migrate alias [{}] to a data stream", (Object)request.aliasName);
        return MetadataCreateDataStreamService.createDataStream(metadataCreateIndexService, currentState, request.aliasName, backingIndices, writeIndex);
    }

    static void validateRequest(ClusterState currentState, MigrateToDataStreamClusterStateUpdateRequest request) {
        IndexAbstraction ia = (IndexAbstraction)currentState.metadata().getIndicesLookup().get(request.aliasName);
        if (ia == null || ia.getType() != IndexAbstraction.Type.ALIAS) {
            throw new IllegalArgumentException("alias [" + request.aliasName + "] does not exist");
        }
        if (ia.getWriteIndex() == null) {
            throw new IllegalArgumentException("alias [" + request.aliasName + "] must specify a write index");
        }
        AliasMetadata aliasMetadata = AliasMetadata.getFirstAliasMetadata(ia);
        assert (aliasMetadata != null) : "alias metadata may not be null";
        if (aliasMetadata.filteringRequired() || aliasMetadata.getIndexRouting() != null || aliasMetadata.getSearchRouting() != null) {
            throw new IllegalArgumentException("alias [" + request.aliasName + "] may not have custom filtering or routing");
        }
    }

    private static void prepareBackingIndex(Metadata.Builder b, IndexMetadata im, String dataStreamName, Function<IndexMetadata, MapperService> mapperSupplier) throws IOException {
        MappingMetadata mm = im.mapping();
        if (mm == null) {
            throw new IllegalArgumentException("backing index [" + im.getIndex().getName() + "] must have mappings for a timestamp field");
        }
        MapperService mapperService = mapperSupplier.apply(im);
        mapperService.merge(im, MapperService.MergeReason.MAPPING_RECOVERY);
        mapperService.merge("_doc", Map.of("_data_stream_timestamp", Map.of("enabled", true)), MapperService.MergeReason.MAPPING_UPDATE);
        DocumentMapper mapper = mapperService.documentMapper();
        b.put(IndexMetadata.builder(im).removeAlias(dataStreamName).settings(Settings.builder().put(im.getSettings()).put("index.hidden", "true").build()).settingsVersion(im.getSettingsVersion() + 1L).mappingVersion(im.getMappingVersion() + 1L).putMapping(new MappingMetadata(mapper)));
    }

    static void validateBackingIndices(ClusterState currentState, String dataStreamName) {
        IndexAbstraction ia = (IndexAbstraction)currentState.metadata().getIndicesLookup().get(dataStreamName);
        if (ia == null || ia.getType() != IndexAbstraction.Type.ALIAS) {
            throw new IllegalArgumentException("alias [" + dataStreamName + "] does not exist");
        }
        IndexAbstraction.Alias alias = (IndexAbstraction.Alias)ia;
        ArrayList<String> indicesWithOtherAliases = new ArrayList<String>();
        for (IndexMetadata im : alias.getIndices()) {
            if (im.getAliases().size() <= 1 && im.getAliases().containsKey(alias.getName())) continue;
            indicesWithOtherAliases.add(im.getIndex().getName());
        }
        if (indicesWithOtherAliases.size() > 0) {
            throw new IllegalArgumentException("other aliases referencing indices [" + Strings.collectionToCommaDelimitedString(indicesWithOtherAliases) + "] must be removed before migrating to a data stream");
        }
    }

    public static final class MigrateToDataStreamClusterStateUpdateRequest
    extends ClusterStateUpdateRequest {
        private final String aliasName;

        public MigrateToDataStreamClusterStateUpdateRequest(String aliasName, TimeValue masterNodeTimeout, TimeValue timeout) {
            this.aliasName = aliasName;
            this.masterNodeTimeout(masterNodeTimeout);
            this.ackTimeout(timeout);
        }
    }
}

