/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.state;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;

public class ClusterStateRequest
extends MasterNodeReadRequest<ClusterStateRequest>
implements IndicesRequest.Replaceable {
    public static final TimeValue DEFAULT_WAIT_FOR_NODE_TIMEOUT = TimeValue.timeValueMinutes(1L);
    private boolean routingTable = true;
    private boolean nodes = true;
    private boolean metadata = true;
    private boolean blocks = true;
    private boolean customs = true;
    private Long waitForMetadataVersion;
    private TimeValue waitForTimeout = DEFAULT_WAIT_FOR_NODE_TIMEOUT;
    private String[] indices = Strings.EMPTY_ARRAY;
    private IndicesOptions indicesOptions = IndicesOptions.lenientExpandOpen();

    public ClusterStateRequest() {
    }

    public ClusterStateRequest(StreamInput in) throws IOException {
        super(in);
        this.routingTable = in.readBoolean();
        this.nodes = in.readBoolean();
        this.metadata = in.readBoolean();
        this.blocks = in.readBoolean();
        this.customs = in.readBoolean();
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        if (in.getVersion().onOrAfter(Version.V_6_6_0)) {
            this.waitForTimeout = in.readTimeValue();
            this.waitForMetadataVersion = in.readOptionalLong();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.routingTable);
        out.writeBoolean(this.nodes);
        out.writeBoolean(this.metadata);
        out.writeBoolean(this.blocks);
        out.writeBoolean(this.customs);
        out.writeStringArray(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
        if (out.getVersion().onOrAfter(Version.V_6_6_0)) {
            out.writeTimeValue(this.waitForTimeout);
            out.writeOptionalLong(this.waitForMetadataVersion);
        }
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    public ClusterStateRequest all() {
        this.routingTable = true;
        this.nodes = true;
        this.metadata = true;
        this.blocks = true;
        this.customs = true;
        this.indices = Strings.EMPTY_ARRAY;
        return this;
    }

    public ClusterStateRequest clear() {
        this.routingTable = false;
        this.nodes = false;
        this.metadata = false;
        this.blocks = false;
        this.customs = false;
        this.indices = Strings.EMPTY_ARRAY;
        return this;
    }

    public boolean routingTable() {
        return this.routingTable;
    }

    public ClusterStateRequest routingTable(boolean routingTable) {
        this.routingTable = routingTable;
        return this;
    }

    public boolean nodes() {
        return this.nodes;
    }

    public ClusterStateRequest nodes(boolean nodes) {
        this.nodes = nodes;
        return this;
    }

    public boolean metadata() {
        return this.metadata;
    }

    public ClusterStateRequest metadata(boolean metadata) {
        this.metadata = metadata;
        return this;
    }

    public boolean blocks() {
        return this.blocks;
    }

    public ClusterStateRequest blocks(boolean blocks) {
        this.blocks = blocks;
        return this;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public ClusterStateRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public final ClusterStateRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    @Override
    public boolean includeDataStreams() {
        return true;
    }

    public ClusterStateRequest customs(boolean customs) {
        this.customs = customs;
        return this;
    }

    public boolean customs() {
        return this.customs;
    }

    public TimeValue waitForTimeout() {
        return this.waitForTimeout;
    }

    public ClusterStateRequest waitForTimeout(TimeValue waitForTimeout) {
        this.waitForTimeout = waitForTimeout;
        return this;
    }

    public Long waitForMetadataVersion() {
        return this.waitForMetadataVersion;
    }

    public ClusterStateRequest waitForMetadataVersion(long waitForMetadataVersion) {
        if (waitForMetadataVersion < 1L) {
            throw new IllegalArgumentException("provided waitForMetadataVersion should be >= 1, but instead is [" + waitForMetadataVersion + "]");
        }
        this.waitForMetadataVersion = waitForMetadataVersion;
        return this;
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new CancellableTask(id, type, action, this.getDescription(), parentTaskId, headers){

            @Override
            public boolean shouldCancelChildrenOnCancellation() {
                return true;
            }
        };
    }

    @Override
    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder("cluster state [");
        if (this.routingTable) {
            stringBuilder.append("routing table, ");
        }
        if (this.nodes) {
            stringBuilder.append("nodes, ");
        }
        if (this.metadata) {
            stringBuilder.append("metadata, ");
        }
        if (this.blocks) {
            stringBuilder.append("blocks, ");
        }
        if (this.customs) {
            stringBuilder.append("customs, ");
        }
        if (this.local) {
            stringBuilder.append("local, ");
        }
        if (this.waitForMetadataVersion != null) {
            stringBuilder.append("wait for metadata version [").append(this.waitForMetadataVersion).append("] with timeout [").append(this.waitForTimeout).append("], ");
        }
        if (this.indices.length > 0) {
            stringBuilder.append("indices ").append(Arrays.toString(this.indices)).append(", ");
        }
        stringBuilder.append("master timeout [").append(this.masterNodeTimeout).append("]]");
        return stringBuilder.toString();
    }
}

