/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.action;

import java.time.Clock;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.discovery.MasterNotDiscoveredException;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.transform.action.UpdateTransformAction;
import org.elasticsearch.xpack.core.transform.action.ValidateTransformAction;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfigUpdate;
import org.elasticsearch.xpack.core.transform.transforms.TransformDestIndexSettings;
import org.elasticsearch.xpack.core.transform.transforms.TransformState;
import org.elasticsearch.xpack.core.transform.transforms.TransformTaskState;
import org.elasticsearch.xpack.core.transform.transforms.persistence.TransformInternalIndexConstants;
import org.elasticsearch.xpack.transform.TransformServices;
import org.elasticsearch.xpack.transform.action.TransformConfigLinter;
import org.elasticsearch.xpack.transform.action.TransformPrivilegeChecker;
import org.elasticsearch.xpack.transform.notifications.TransformAuditor;
import org.elasticsearch.xpack.transform.persistence.SeqNoPrimaryTermAndIndex;
import org.elasticsearch.xpack.transform.persistence.TransformConfigManager;
import org.elasticsearch.xpack.transform.persistence.TransformIndex;
import org.elasticsearch.xpack.transform.transforms.Function;
import org.elasticsearch.xpack.transform.transforms.FunctionFactory;
import org.elasticsearch.xpack.transform.transforms.TransformTask;

public class TransportUpdateTransformAction
extends TransportTasksAction<TransformTask, UpdateTransformAction.Request, UpdateTransformAction.Response, UpdateTransformAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportUpdateTransformAction.class);
    private final XPackLicenseState licenseState;
    private final Client client;
    private final TransformConfigManager transformConfigManager;
    private final SecurityContext securityContext;
    private final TransformAuditor auditor;
    private final ThreadPool threadPool;
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    @Inject
    public TransportUpdateTransformAction(Settings settings, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService, XPackLicenseState licenseState, TransformServices transformServices, Client client, IngestService ingestService) {
        this("cluster:admin/transform/update", settings, transportService, threadPool, actionFilters, indexNameExpressionResolver, clusterService, licenseState, transformServices, client, ingestService);
    }

    protected TransportUpdateTransformAction(String name, Settings settings, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService, XPackLicenseState licenseState, TransformServices transformServices, Client client, IngestService ingestService) {
        super(name, clusterService, transportService, actionFilters, UpdateTransformAction.Request::fromStreamWithBWC, UpdateTransformAction.Response::fromStreamWithBWC, UpdateTransformAction.Response::fromStreamWithBWC, "same");
        this.licenseState = licenseState;
        this.client = client;
        this.transformConfigManager = transformServices.getConfigManager();
        this.securityContext = (Boolean)XPackSettings.SECURITY_ENABLED.get(settings) != false ? new SecurityContext(settings, threadPool.getThreadContext()) : null;
        this.auditor = transformServices.getAuditor();
        this.threadPool = threadPool;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    protected void doExecute(Task task, UpdateTransformAction.Request request, ActionListener<UpdateTransformAction.Response> listener) {
        ClusterState clusterState = this.clusterService.state();
        XPackPlugin.checkReadyForXPackCustomMetadata((ClusterState)clusterState);
        DiscoveryNodes nodes = clusterState.nodes();
        if (!nodes.isLocalNodeElectedMaster()) {
            if (nodes.getMasterNode() == null) {
                listener.onFailure((Exception)new MasterNotDiscoveredException());
            } else {
                this.transportService.sendRequest(nodes.getMasterNode(), this.actionName, (TransportRequest)request, (TransportResponseHandler)new ActionListenerResponseHandler(listener, UpdateTransformAction.Response::fromStreamWithBWC));
            }
            return;
        }
        Map filteredHeaders = ClientHelper.filterSecurityHeaders((Map)this.threadPool.getThreadContext().getHeaders());
        TransformConfigUpdate update = request.getUpdate();
        update.setHeaders(filteredHeaders);
        this.transformConfigManager.getTransformConfigurationForUpdate(request.getId(), (ActionListener<Tuple<TransformConfig, SeqNoPrimaryTermAndIndex>>)ActionListener.wrap(configAndVersion -> {
            ActionListener updateListener;
            TransformConfig oldConfig = (TransformConfig)configAndVersion.v1();
            TransformConfig config = TransformConfig.rewriteForUpdate((TransformConfig)oldConfig);
            if (config.getVersion() != null && config.getVersion().onOrAfter(TransformInternalIndexConstants.INDEX_VERSION_LAST_CHANGED) && config.equals((Object)oldConfig) && update.isNoop(config)) {
                listener.onResponse((Object)new UpdateTransformAction.Response(config));
                return;
            }
            TransformConfig updatedConfig = update.apply(config);
            if (update.changesSettings(config)) {
                PersistentTasksCustomMetadata tasksMetadata = PersistentTasksCustomMetadata.getPersistentTasksCustomMetadata((ClusterState)clusterState);
                PersistentTasksCustomMetadata.PersistentTask transformTask = tasksMetadata.getTask(request.getId());
                if (transformTask != null && transformTask.isAssigned() && transformTask.getState() instanceof TransformState && ((TransformState)transformTask.getState()).getTaskState() != TransformTaskState.FAILED && clusterState.nodes().get(transformTask.getExecutorNode()).getVersion().onOrAfter(Version.V_7_8_0)) {
                    request.setNodes(new String[]{transformTask.getExecutorNode()});
                    updateListener = ActionListener.wrap(updateResponse -> {
                        request.setConfig(updateResponse.getConfig());
                        super.doExecute(task, (BaseTasksRequest)request, listener);
                    }, arg_0 -> ((ActionListener)listener).onFailure(arg_0));
                } else {
                    updateListener = listener;
                }
            } else {
                updateListener = listener;
            }
            ActionListener validateTransformListener = ActionListener.wrap(validationResponse -> this.updateTransform(request, updatedConfig, validationResponse.getDestIndexMappings(), (SeqNoPrimaryTermAndIndex)configAndVersion.v2(), clusterState, (ActionListener<UpdateTransformAction.Response>)updateListener), arg_0 -> ((ActionListener)listener).onFailure(arg_0));
            ActionListener checkPrivilegesListener = ActionListener.wrap(aVoid -> this.client.execute((ActionType)ValidateTransformAction.INSTANCE, (ActionRequest)new ValidateTransformAction.Request(updatedConfig, request.isDeferValidation()), validateTransformListener), arg_0 -> ((ActionListener)listener).onFailure(arg_0));
            if (this.licenseState.isSecurityEnabled() && !request.isDeferValidation()) {
                TransformPrivilegeChecker.checkPrivileges("update", this.securityContext, this.indexNameExpressionResolver, clusterState, this.client, updatedConfig, true, (ActionListener<Void>)checkPrivilegesListener);
            } else {
                checkPrivilegesListener.onResponse(null);
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    protected void taskOperation(UpdateTransformAction.Request request, TransformTask transformTask, ActionListener<UpdateTransformAction.Response> listener) {
        transformTask.applyNewSettings(request.getConfig().getSettings());
        listener.onResponse((Object)new UpdateTransformAction.Response(request.getConfig()));
    }

    protected UpdateTransformAction.Response newResponse(UpdateTransformAction.Request request, List<UpdateTransformAction.Response> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        return tasks.get(0);
    }

    private void updateTransform(UpdateTransformAction.Request request, TransformConfig config, Map<String, String> mappings, SeqNoPrimaryTermAndIndex seqNoPrimaryTermAndIndex, ClusterState clusterState, ActionListener<UpdateTransformAction.Response> listener) {
        Function function = FunctionFactory.create(config);
        ActionListener putTransformConfigurationListener = ActionListener.wrap(putTransformConfigurationResult -> {
            this.auditor.info(config.getId(), "Updated transform.");
            List<String> warnings = TransformConfigLinter.getWarnings(function, config.getSource(), config.getSyncConfig());
            for (String warning : warnings) {
                logger.warn((Message)new ParameterizedMessage("[{}] {}", (Object)config.getId(), (Object)warning));
                this.auditor.warning(config.getId(), warning);
            }
            this.transformConfigManager.deleteOldTransformConfigurations(request.getId(), (ActionListener<Boolean>)ActionListener.wrap(r -> {
                logger.trace("[{}] successfully deleted old transform configurations", (Object)request.getId());
                listener.onResponse((Object)new UpdateTransformAction.Response(config));
            }, e -> {
                logger.warn(LoggerMessageFormat.format((String)"[{}] failed deleting old transform configurations.", (String)request.getId(), (Object[])new Object[0]), (Throwable)e);
                listener.onResponse((Object)new UpdateTransformAction.Response(config));
            }));
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener createDestinationListener = ActionListener.wrap(createDestResponse -> this.transformConfigManager.updateTransformConfiguration(config, seqNoPrimaryTermAndIndex, (ActionListener<Boolean>)putTransformConfigurationListener), arg_0 -> listener.onFailure(arg_0));
        String[] dest = this.indexNameExpressionResolver.concreteIndexNames(clusterState, IndicesOptions.lenientExpandOpen(), new String[]{config.getDestination().getIndex()});
        String[] src = this.indexNameExpressionResolver.concreteIndexNames(clusterState, IndicesOptions.lenientExpandOpen(), true, config.getSource().getIndex());
        if (PersistentTasksCustomMetadata.getTaskWithId((ClusterState)clusterState, (String)request.getId()) != null && dest.length == 0 && src.length > 0) {
            this.createDestinationIndex(config, mappings, (ActionListener<Boolean>)createDestinationListener);
        } else {
            createDestinationListener.onResponse(null);
        }
    }

    private void createDestinationIndex(TransformConfig config, Map<String, String> mappings, ActionListener<Boolean> listener) {
        TransformDestIndexSettings generatedDestIndexSettings = TransformIndex.createTransformDestIndexSettings(mappings, config.getId(), Clock.systemUTC());
        TransformIndex.createDestinationIndex(this.client, config, generatedDestIndexSettings, listener);
    }
}

