/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.gen.script;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.xpack.ql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.Check;

public final class Scripts {
    public static final String DOC_VALUE = "doc[{}].value";
    public static final String QL_SCRIPTS = "{ql}";
    public static final String EQL_SCRIPTS = "{eql}";
    public static final String SQL_SCRIPTS = "{sql}";
    public static final String PARAM = "{}";
    public static final String INTERNAL_QL_SCRIPT_UTILS = "InternalQlScriptUtils";
    public static final String INTERNAL_EQL_SCRIPT_UTILS = "InternalEqlScriptUtils";
    public static final String INTERNAL_SQL_SCRIPT_UTILS = "InternalSqlScriptUtils";
    private static final int PKG_LENGTH = "org.elasticsearch.xpack.".length();
    static final Map<Pattern, String> FORMATTING_PATTERNS = Collections.unmodifiableMap(Stream.of(new AbstractMap.SimpleEntry<String, String>("doc[{}].value", "{ql}.docValue(doc,{})"), new AbstractMap.SimpleEntry<String, String>("{ql}", "InternalQlScriptUtils"), new AbstractMap.SimpleEntry<String, String>("{eql}", "InternalEqlScriptUtils"), new AbstractMap.SimpleEntry<String, String>("{sql}", "InternalSqlScriptUtils"), new AbstractMap.SimpleEntry<String, String>("{}", "params.%s")).collect(Collectors.toMap(e -> Pattern.compile((String)e.getKey(), 16), Map.Entry::getValue, (a, b) -> a, LinkedHashMap::new)));

    private Scripts() {
    }

    public static String formatTemplate(String template) {
        for (Map.Entry<Pattern, String> entry : FORMATTING_PATTERNS.entrySet()) {
            template = entry.getKey().matcher(template).replaceAll(entry.getValue());
        }
        return template;
    }

    public static ScriptTemplate nullSafeFilter(ScriptTemplate script) {
        return new ScriptTemplate(Scripts.formatTemplate(String.format(Locale.ROOT, "{ql}.nullSafeFilter(%s)", script.template())), script.params(), DataTypes.BOOLEAN);
    }

    public static ScriptTemplate nullSafeSort(ScriptTemplate script) {
        String methodName = script.outputType().isNumeric() ? "nullSafeSortNumeric" : "nullSafeSortString";
        return new ScriptTemplate(Scripts.formatTemplate(String.format(Locale.ROOT, "{ql}.%s(%s)", methodName, script.template())), script.params(), script.outputType());
    }

    public static ScriptTemplate and(ScriptTemplate left, ScriptTemplate right) {
        return Scripts.binaryMethod(QL_SCRIPTS, "and", left, right, DataTypes.BOOLEAN);
    }

    public static ScriptTemplate or(ScriptTemplate left, ScriptTemplate right) {
        return Scripts.binaryMethod(QL_SCRIPTS, "or", left, right, DataTypes.BOOLEAN);
    }

    public static ScriptTemplate binaryMethod(String prefix, String methodName, ScriptTemplate leftScript, ScriptTemplate rightScript, DataType dataType) {
        return new ScriptTemplate(String.format(Locale.ROOT, Scripts.formatTemplate("%s.%s(%s,%s)"), Scripts.formatTemplate(prefix), methodName, leftScript.template(), rightScript.template()), ParamsBuilder.paramsBuilder().script(leftScript.params()).script(rightScript.params()).build(), dataType);
    }

    public static String classPackageAsPrefix(Class<?> function) {
        String prefix = function.getPackage().getName().substring(PKG_LENGTH);
        int index = prefix.indexOf(46);
        Check.isTrue(index > 0, "invalid package {}", prefix);
        return "{" + prefix.substring(0, index) + "}";
    }
}

