/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.allocation;

import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.plugins.IndexStorePlugin;
import org.elasticsearch.snapshots.SearchableSnapshotsSettings;
import org.elasticsearch.xpack.searchablesnapshots.SearchableSnapshots;
import org.elasticsearch.xpack.searchablesnapshots.allocation.SearchableSnapshotIndexEventListener;
import org.elasticsearch.xpack.searchablesnapshots.cache.full.CacheService;
import org.elasticsearch.xpack.searchablesnapshots.cache.shared.FrozenCacheService;

public class SearchableSnapshotIndexFoldersDeletionListener
implements IndexStorePlugin.IndexFoldersDeletionListener {
    private static final Logger logger = LogManager.getLogger(SearchableSnapshotIndexEventListener.class);
    private final Supplier<CacheService> cacheService;
    private final Supplier<FrozenCacheService> frozenCacheService;

    public SearchableSnapshotIndexFoldersDeletionListener(Supplier<CacheService> cacheService, Supplier<FrozenCacheService> frozenCacheService) {
        this.cacheService = Objects.requireNonNull(cacheService);
        this.frozenCacheService = Objects.requireNonNull(frozenCacheService);
    }

    public void beforeIndexFoldersDeleted(Index index, IndexSettings indexSettings, Path[] indexPaths) {
        if (SearchableSnapshotsSettings.isSearchableSnapshotStore((Settings)indexSettings.getSettings())) {
            for (int shard = 0; shard < indexSettings.getNumberOfShards(); ++shard) {
                this.markShardAsEvictedInCache(new ShardId(index, shard), indexSettings);
            }
        }
    }

    public void beforeShardFoldersDeleted(ShardId shardId, IndexSettings indexSettings, Path[] shardPaths) {
        if (SearchableSnapshotsSettings.isSearchableSnapshotStore((Settings)indexSettings.getSettings())) {
            this.markShardAsEvictedInCache(shardId, indexSettings);
        }
    }

    private void markShardAsEvictedInCache(ShardId shardId, IndexSettings indexSettings) {
        CacheService cacheService = this.cacheService.get();
        assert (cacheService != null) : "cache service not initialized";
        logger.debug("{} marking shard as evicted in searchable snapshots cache (reason: cache files deleted from disk)", (Object)shardId);
        cacheService.markShardAsEvictedInCache((String)SearchableSnapshots.SNAPSHOT_SNAPSHOT_ID_SETTING.get(indexSettings.getSettings()), (String)SearchableSnapshots.SNAPSHOT_INDEX_NAME_SETTING.get(indexSettings.getSettings()), shardId);
        FrozenCacheService frozenCacheService = this.frozenCacheService.get();
        assert (frozenCacheService != null) : "frozen cache service not initialized";
        frozenCacheService.markShardAsEvictedInCache((String)SearchableSnapshots.SNAPSHOT_SNAPSHOT_ID_SETTING.get(indexSettings.getSettings()), (String)SearchableSnapshots.SNAPSHOT_INDEX_NAME_SETTING.get(indexSettings.getSettings()), shardId);
    }
}

