/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.parser;

import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.elasticsearch.xpack.eql.expression.function.EqlFunctionResolution;
import org.elasticsearch.xpack.eql.expression.function.scalar.string.Match;
import org.elasticsearch.xpack.eql.expression.function.scalar.string.Wildcard;
import org.elasticsearch.xpack.eql.expression.predicate.operator.comparison.InsensitiveEquals;
import org.elasticsearch.xpack.eql.expression.predicate.operator.comparison.InsensitiveWildcardEquals;
import org.elasticsearch.xpack.eql.parser.EqlBaseParser;
import org.elasticsearch.xpack.eql.parser.IdentifierBuilder;
import org.elasticsearch.xpack.eql.parser.ParserParams;
import org.elasticsearch.xpack.eql.parser.ParsingException;
import org.elasticsearch.xpack.ql.QlIllegalArgumentException;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.ql.expression.function.Function;
import org.elasticsearch.xpack.ql.expression.function.FunctionResolutionStrategy;
import org.elasticsearch.xpack.ql.expression.function.UnresolvedFunction;
import org.elasticsearch.xpack.ql.expression.predicate.Predicates;
import org.elasticsearch.xpack.ql.expression.predicate.logical.And;
import org.elasticsearch.xpack.ql.expression.predicate.logical.Not;
import org.elasticsearch.xpack.ql.expression.predicate.logical.Or;
import org.elasticsearch.xpack.ql.expression.predicate.operator.arithmetic.Add;
import org.elasticsearch.xpack.ql.expression.predicate.operator.arithmetic.Div;
import org.elasticsearch.xpack.ql.expression.predicate.operator.arithmetic.Mod;
import org.elasticsearch.xpack.ql.expression.predicate.operator.arithmetic.Mul;
import org.elasticsearch.xpack.ql.expression.predicate.operator.arithmetic.Neg;
import org.elasticsearch.xpack.ql.expression.predicate.operator.arithmetic.Sub;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.Equals;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.GreaterThan;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.GreaterThanOrEqual;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.In;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.LessThan;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.LessThanOrEqual;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.NotEquals;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.StringUtils;

public class ExpressionBuilder
extends IdentifierBuilder {
    protected final ParserParams params;

    public ExpressionBuilder(ParserParams params) {
        this.params = params;
    }

    protected Expression expression(ParseTree ctx) {
        return this.typedParsing(ctx, Expression.class);
    }

    protected List<Expression> expressions(List<? extends ParserRuleContext> contexts) {
        return this.visitList(contexts, Expression.class);
    }

    @Override
    public Expression visitSingleExpression(EqlBaseParser.SingleExpressionContext ctx) {
        return this.expression((ParseTree)ctx.expression());
    }

    @Override
    public List<Attribute> visitJoinKeys(EqlBaseParser.JoinKeysContext ctx) {
        try {
            return ctx != null ? this.visitList(ctx.expression(), Attribute.class) : Collections.emptyList();
        }
        catch (ClassCastException ex) {
            Source source = ExpressionBuilder.source(ctx);
            throw new ParsingException(source, "Unsupported join key ", source.text());
        }
    }

    @Override
    public Expression visitArithmeticUnary(EqlBaseParser.ArithmeticUnaryContext ctx) {
        Expression expr = this.expression((ParseTree)ctx.operatorExpression());
        Source source = ExpressionBuilder.source(ctx);
        int type = ctx.operator.getType();
        return type == 31 ? new Neg(source, expr) : expr;
    }

    @Override
    public Expression visitArithmeticBinary(EqlBaseParser.ArithmeticBinaryContext ctx) {
        Expression left = this.expression((ParseTree)ctx.left);
        Expression right = this.expression((ParseTree)ctx.right);
        Source source = ExpressionBuilder.source(ctx);
        int type = ctx.operator.getType();
        switch (type) {
            case 32: {
                return new Mul(source, left, right);
            }
            case 33: {
                return new Div(source, left, right);
            }
            case 34: {
                return new Mod(source, left, right);
            }
            case 30: {
                return new Add(source, left, right);
            }
            case 31: {
                return new Sub(source, left, right);
            }
        }
        throw new ParsingException(source, "Unknown arithmetic {}", source.text());
    }

    @Override
    public Literal visitBooleanValue(EqlBaseParser.BooleanValueContext ctx) {
        Source source = ExpressionBuilder.source(ctx);
        return new Literal(source, (Object)(ctx.TRUE() != null ? 1 : 0), DataTypes.BOOLEAN);
    }

    @Override
    public Expression visitComparison(EqlBaseParser.ComparisonContext ctx) {
        Expression left = this.expression((ParseTree)ctx.left);
        Expression right = this.expression((ParseTree)ctx.right);
        TerminalNode op = (TerminalNode)ctx.comparisonOperator().getChild(0);
        Source source = ExpressionBuilder.source(ctx);
        ZoneId zoneId = this.params.zoneId();
        switch (op.getSymbol().getType()) {
            case 24: {
                return new Equals(source, left, right, zoneId);
            }
            case 25: {
                return new NotEquals(source, left, right, zoneId);
            }
            case 26: {
                return new LessThan(source, left, right, zoneId);
            }
            case 27: {
                return new LessThanOrEqual(source, left, right, zoneId);
            }
            case 28: {
                return new GreaterThan(source, left, right, zoneId);
            }
            case 29: {
                return new GreaterThanOrEqual(source, left, right, zoneId);
            }
        }
        throw new ParsingException(source, "Unknown operator {}", source.text());
    }

    @Override
    public Expression visitOperatorExpressionDefault(EqlBaseParser.OperatorExpressionDefaultContext ctx) {
        Expression expr = this.expression((ParseTree)ctx.primaryExpression());
        Source source = ExpressionBuilder.source(ctx);
        ZoneId zoneId = this.params.zoneId();
        EqlBaseParser.PredicateContext predicate = ctx.predicate();
        if (predicate == null) {
            return expr;
        }
        switch (predicate.kind.getType()) {
            case 22: {
                return this.combineExpressions(predicate.constant(), c -> new InsensitiveWildcardEquals(source, expr, (Expression)c, zoneId));
            }
            case 8: 
            case 9: {
                return new Wildcard(source, expr, this.expressions(predicate.constant()), predicate.kind.getType() == 9);
            }
            case 15: 
            case 16: {
                return new Match(source, expr, this.expressions(predicate.constant()), predicate.kind.getType() == 16);
            }
            case 6: {
                Expression insensitiveIn = this.combineExpressions(predicate.expression(), c -> new InsensitiveEquals(source, expr, (Expression)c, zoneId));
                return predicate.NOT() != null ? new Not(source, insensitiveIn) : insensitiveIn;
            }
            case 5: {
                List<Expression> container = this.expressions(predicate.expression());
                In checkInSet = new In(source, expr, container, zoneId);
                return predicate.NOT() != null ? new Not(source, (Expression)checkInSet) : checkInSet;
            }
        }
        throw new ParsingException(source, "Unknown predicate {}", source.text());
    }

    private Expression combineExpressions(List<? extends ParserRuleContext> expressions, java.util.function.Function<Expression, Expression> mapper) {
        return Predicates.combineOr(this.expressions(expressions).stream().map(mapper::apply).collect(Collectors.toList()));
    }

    @Override
    public Literal visitDecimalLiteral(EqlBaseParser.DecimalLiteralContext ctx) {
        Source source = ExpressionBuilder.source(ctx);
        String text = ctx.getText();
        try {
            return new Literal(source, (Object)StringUtils.parseDouble((String)text), DataTypes.DOUBLE);
        }
        catch (QlIllegalArgumentException siae) {
            throw new ParsingException(source, siae.getMessage(), new Object[0]);
        }
    }

    @Override
    public UnresolvedAttribute visitDereference(EqlBaseParser.DereferenceContext ctx) {
        return new UnresolvedAttribute(ExpressionBuilder.source(ctx), this.visitQualifiedName(ctx.qualifiedName()));
    }

    @Override
    public Function visitFunctionExpression(EqlBaseParser.FunctionExpressionContext ctx) {
        Source source = ExpressionBuilder.source(ctx);
        String name = ctx.name.getText();
        List<Expression> arguments = this.expressions(ctx.expression());
        FunctionResolutionStrategy strategy = FunctionResolutionStrategy.DEFAULT;
        if (name.endsWith("~")) {
            name = name.substring(0, name.length() - 1);
            strategy = EqlFunctionResolution.CASE_INSENSITIVE;
        }
        return new UnresolvedFunction(source, name, strategy, arguments);
    }

    @Override
    public Literal visitIntegerLiteral(EqlBaseParser.IntegerLiteralContext ctx) {
        long value;
        Source source = ExpressionBuilder.source(ctx);
        String text = ctx.getText();
        try {
            value = StringUtils.parseLong((String)text);
        }
        catch (QlIllegalArgumentException siae) {
            try {
                return new Literal(source, (Object)StringUtils.parseDouble((String)text), DataTypes.DOUBLE);
            }
            catch (QlIllegalArgumentException qlIllegalArgumentException) {
                throw new ParsingException(source, siae.getMessage(), new Object[0]);
            }
        }
        Number val = value;
        DataType type = DataTypes.LONG;
        if ((long)((int)value) == value) {
            type = DataTypes.INTEGER;
            val = (int)value;
        }
        return new Literal(source, (Object)val, type);
    }

    @Override
    public Expression visitLogicalBinary(EqlBaseParser.LogicalBinaryContext ctx) {
        int type = ctx.operator.getType();
        Source source = ExpressionBuilder.source(ctx);
        Expression left = this.expression((ParseTree)ctx.left);
        Expression right = this.expression((ParseTree)ctx.right);
        if (type == 1) {
            return new And(source, left, right);
        }
        return new Or(source, left, right);
    }

    @Override
    public Not visitLogicalNot(EqlBaseParser.LogicalNotContext ctx) {
        return new Not(ExpressionBuilder.source(ctx), this.expression((ParseTree)ctx.booleanExpression()));
    }

    @Override
    public Literal visitNullLiteral(EqlBaseParser.NullLiteralContext ctx) {
        Source source = ExpressionBuilder.source(ctx);
        return new Literal(source, null, DataTypes.NULL);
    }

    @Override
    public Expression visitParenthesizedExpression(EqlBaseParser.ParenthesizedExpressionContext ctx) {
        return this.expression((ParseTree)ctx.expression());
    }

    @Override
    public Literal visitString(EqlBaseParser.StringContext ctx) {
        Source source = ExpressionBuilder.source(ctx);
        return new Literal(source, (Object)ExpressionBuilder.unquoteString(source), DataTypes.KEYWORD);
    }
}

