/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.parser;

import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.elasticsearch.xpack.eql.parser.EqlBaseBaseVisitor;
import org.elasticsearch.xpack.eql.parser.ParsingException;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.tree.Location;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.util.Check;

abstract class AbstractBuilder
extends EqlBaseBaseVisitor<Object> {
    AbstractBuilder() {
    }

    public Object visit(ParseTree tree) {
        Object result = super.visit(tree);
        Check.notNull((Object)result, (String)"Don't know how to handle context [{}] with value [{}]", (Object[])new Object[]{tree.getClass(), tree.getText()});
        return result;
    }

    protected <T> T typedParsing(ParseTree ctx, Class<T> type) {
        Object result = ctx.accept((ParseTreeVisitor)this);
        if (type.isInstance(result)) {
            return (T)result;
        }
        throw new ParsingException(AbstractBuilder.source(ctx), "Invalid query '{}'[{}] given; expected {} but found {}", ctx.getText(), ctx.getClass().getSimpleName(), type.getSimpleName(), result != null ? result.getClass().getSimpleName() : "null");
    }

    protected LogicalPlan plan(ParseTree ctx) {
        return this.typedParsing(ctx, LogicalPlan.class);
    }

    protected List<LogicalPlan> plans(List<? extends ParserRuleContext> ctxs) {
        return this.visitList(ctxs, LogicalPlan.class);
    }

    protected <T> List<T> visitList(List<? extends ParserRuleContext> contexts, Class<T> clazz) {
        ArrayList<T> results = new ArrayList<T>(contexts.size());
        for (ParserRuleContext parserRuleContext : contexts) {
            results.add(clazz.cast(this.visit((ParseTree)parserRuleContext)));
        }
        return results;
    }

    static Source source(ParseTree ctx) {
        if (ctx instanceof ParserRuleContext) {
            return AbstractBuilder.source((ParserRuleContext)ctx);
        }
        return Source.EMPTY;
    }

    static Source source(TerminalNode terminalNode) {
        Check.notNull((Object)terminalNode, (String)"terminalNode is null");
        return AbstractBuilder.source(terminalNode.getSymbol());
    }

    static Source source(ParserRuleContext parserRuleContext) {
        Check.notNull((Object)parserRuleContext, (String)"parserRuleContext is null");
        Token start = parserRuleContext.start;
        Token stop = parserRuleContext.stop != null ? parserRuleContext.stop : start;
        Interval interval = new Interval(start.getStartIndex(), stop.getStopIndex());
        String text = start.getInputStream().getText(interval);
        return new Source(new Location(start.getLine(), start.getCharPositionInLine()), text);
    }

    static Source source(Token token) {
        Check.notNull((Object)token, (String)"token is null");
        String text = token.getInputStream().getText(new Interval(token.getStartIndex(), token.getStopIndex()));
        return new Source(new Location(token.getLine(), token.getCharPositionInLine()), text);
    }

    Source source(ParserRuleContext begin, ParserRuleContext end) {
        Check.notNull((Object)begin, (String)"begin is null");
        Check.notNull((Object)end, (String)"end is null");
        Token start = begin.start;
        Token stop = end.stop != null ? end.stop : begin.stop;
        Interval interval = new Interval(start.getStartIndex(), stop.getStopIndex());
        String text = start.getInputStream().getText(interval);
        return new Source(new Location(start.getLine(), start.getCharPositionInLine()), text);
    }

    static Source source(TerminalNode begin, ParserRuleContext end) {
        Check.notNull((Object)begin, (String)"begin is null");
        Check.notNull((Object)end, (String)"end is null");
        Token start = begin.getSymbol();
        Token stop = end.stop != null ? end.stop : start;
        String text = start.getInputStream().getText(new Interval(start.getStartIndex(), stop.getStopIndex()));
        return new Source(new Location(start.getLine(), start.getCharPositionInLine()), text);
    }

    static String text(ParseTree node) {
        return node == null ? null : node.getText();
    }

    public static String unquoteString(Source source) {
        String text = source.text();
        if (text == null) {
            return null;
        }
        if (text.startsWith("?")) {
            throw new ParsingException(source, "Use triple double quotes [\"\"\"] to define unescaped string literals, not [?{}]", Character.valueOf(text.charAt(1)));
        }
        if (text.startsWith("\"\"\"")) {
            return text.substring(3, text.length() - 3);
        }
        AbstractBuilder.checkForSingleQuotedString(source, text, 0);
        text = text.substring(1, text.length() - 1);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < text.length()) {
            if (text.charAt(i) == '\\') {
                switch (text.charAt(++i)) {
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'b': {
                        sb.append('\b');
                        break;
                    }
                    case 'f': {
                        sb.append('\f');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case '\"': {
                        sb.append('\"');
                        break;
                    }
                    case '\'': {
                        sb.append('\'');
                        break;
                    }
                    case 'u': {
                        ++i;
                        i = AbstractBuilder.handleUnicodePoints(source, sb, text, i);
                        break;
                    }
                    case '\\': {
                        sb.append('\\');
                        break;
                    }
                    default: {
                        sb.append('\\').append(text.charAt(i));
                    }
                }
                ++i;
                continue;
            }
            sb.append(text.charAt(i++));
        }
        return sb.toString();
    }

    private static int handleUnicodePoints(Source source, StringBuilder sb, String text, int i) {
        int startIdx = i + 1;
        int endIdx = text.indexOf(125, startIdx);
        String unicodeSequence = text.substring(startIdx, endIdx);
        int length = unicodeSequence.length();
        if (length < 2 || length > 8) {
            throw new ParsingException(source, "Unicode sequence should use [2-8] hex digits, [{}] has [{}]", text.substring(startIdx - 3, endIdx + 1), length);
        }
        sb.append(AbstractBuilder.hexToUnicode(source, unicodeSequence));
        return endIdx;
    }

    private static String hexToUnicode(Source source, String hex) {
        try {
            int code = Integer.parseInt(hex, 16);
            if (code >= 55296 && code <= 57343) {
                throw new ParsingException(source, "Invalid unicode character code, [{}] is a surrogate code", hex);
            }
            return String.valueOf(Character.toChars(code));
        }
        catch (IllegalArgumentException e) {
            throw new ParsingException(source, "Invalid unicode character code [{}]", hex);
        }
    }

    private static void checkForSingleQuotedString(Source source, String text, int i) {
        if (text.charAt(i) == '\'') {
            throw new ParsingException(source, "Use double quotes [\"] to define string literals, not single quotes [']", new Object[0]);
        }
    }

    public Object visitTerminal(TerminalNode node) {
        Source source = AbstractBuilder.source(node);
        throw new ParsingException(source, "Does not know how to handle {}", source.text());
    }
}

