/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.search;

import java.util.Objects;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;

public class Ordinal
implements Comparable<Ordinal>,
Accountable {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(Ordinal.class);
    private final long timestamp;
    private final Comparable<Object> tiebreaker;
    private final long implicitTiebreaker;

    public Ordinal(long timestamp, Comparable<Object> tiebreaker, long implicitTiebreaker) {
        this.timestamp = timestamp;
        this.tiebreaker = tiebreaker;
        this.implicitTiebreaker = implicitTiebreaker;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public Comparable<Object> tiebreaker() {
        return this.tiebreaker;
    }

    public long implicitTiebreaker() {
        return this.implicitTiebreaker;
    }

    public long ramBytesUsed() {
        return SHALLOW_SIZE;
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.tiebreaker, this.implicitTiebreaker);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Ordinal other = (Ordinal)obj;
        return Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.tiebreaker, other.tiebreaker) && Objects.equals(this.implicitTiebreaker, other.implicitTiebreaker);
    }

    public String toString() {
        return "[" + this.timestamp + "][" + (this.tiebreaker != null ? this.tiebreaker.toString() : "") + "][" + this.implicitTiebreaker + "]";
    }

    @Override
    public int compareTo(Ordinal o) {
        if (this.timestamp < o.timestamp) {
            return -1;
        }
        if (this.timestamp == o.timestamp) {
            if (this.tiebreaker != null) {
                if (o.tiebreaker != null) {
                    if (this.tiebreaker.compareTo(o.tiebreaker) == 0) {
                        return Long.compare(this.implicitTiebreaker, o.implicitTiebreaker);
                    }
                    return this.tiebreaker.compareTo(o.tiebreaker);
                }
                return -1;
            }
            if (o.tiebreaker == null) {
                return Long.compare(this.implicitTiebreaker, o.implicitTiebreaker);
            }
        }
        return 1;
    }

    public boolean between(Ordinal left, Ordinal right) {
        return this.compareTo(left) <= 0 && this.compareTo(right) >= 0 || this.compareTo(right) <= 0 && this.compareTo(left) >= 0;
    }

    public boolean before(Ordinal other) {
        return this.compareTo(other) < 0;
    }

    public boolean beforeOrAt(Ordinal other) {
        return this.compareTo(other) <= 0;
    }

    public boolean after(Ordinal other) {
        return this.compareTo(other) > 0;
    }

    public boolean afterOrAt(Ordinal other) {
        return this.compareTo(other) >= 0;
    }

    public Object[] toArray() {
        Object[] objectArray;
        if (this.tiebreaker != null) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = this.timestamp;
            objectArray2[1] = this.tiebreaker;
            objectArray = objectArray2;
            objectArray2[2] = this.implicitTiebreaker;
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = this.timestamp;
            objectArray = objectArray3;
            objectArray3[1] = this.implicitTiebreaker;
        }
        return objectArray;
    }
}

