/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.assembler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.eql.EqlIllegalArgumentException;
import org.elasticsearch.xpack.eql.execution.assembler.BoxedQueryRequest;
import org.elasticsearch.xpack.eql.execution.assembler.Criterion;
import org.elasticsearch.xpack.eql.execution.assembler.Executable;
import org.elasticsearch.xpack.eql.execution.search.Limit;
import org.elasticsearch.xpack.eql.execution.search.PITAwareQueryClient;
import org.elasticsearch.xpack.eql.execution.search.QueryRequest;
import org.elasticsearch.xpack.eql.execution.search.RuntimeUtils;
import org.elasticsearch.xpack.eql.execution.search.extractor.FieldHitExtractor;
import org.elasticsearch.xpack.eql.execution.search.extractor.ImplicitTiebreakerHitExtractor;
import org.elasticsearch.xpack.eql.execution.search.extractor.TimestampFieldHitExtractor;
import org.elasticsearch.xpack.eql.execution.sequence.SequenceMatcher;
import org.elasticsearch.xpack.eql.execution.sequence.TumblingWindow;
import org.elasticsearch.xpack.eql.plan.physical.EsQueryExec;
import org.elasticsearch.xpack.eql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.eql.querydsl.container.FieldExtractorRegistry;
import org.elasticsearch.xpack.eql.session.EqlConfiguration;
import org.elasticsearch.xpack.eql.session.EqlSession;
import org.elasticsearch.xpack.ql.execution.search.extractor.AbstractFieldHitExtractor;
import org.elasticsearch.xpack.ql.execution.search.extractor.HitExtractor;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.NamedExpression;
import org.elasticsearch.xpack.ql.expression.Order;

public class ExecutionManager {
    private final EqlSession session;
    private final EqlConfiguration cfg;

    public ExecutionManager(EqlSession eqlSession) {
        this.session = eqlSession;
        this.cfg = eqlSession.configuration();
    }

    public Executable assemble(List<List<Attribute>> listOfKeys, List<PhysicalPlan> plans, Attribute timestamp, Attribute tiebreaker, Order.OrderDirection direction, TimeValue maxSpan, Limit limit) {
        FieldExtractorRegistry extractorRegistry = new FieldExtractorRegistry();
        boolean descending = direction == Order.OrderDirection.DESC;
        HitExtractor tsExtractor = this.timestampExtractor(this.hitExtractor((Expression)timestamp, extractorRegistry));
        HitExtractor tbExtractor = Expressions.isPresent((NamedExpression)tiebreaker) ? this.hitExtractor((Expression)tiebreaker, extractorRegistry) : null;
        HitExtractor itbExtractor = ImplicitTiebreakerHitExtractor.INSTANCE;
        String timestampName = Expressions.name((Expression)timestamp);
        ArrayList<Criterion<BoxedQueryRequest>> criteria = new ArrayList<Criterion<BoxedQueryRequest>>(plans.size() - 1);
        for (int i = 0; i < plans.size(); ++i) {
            PhysicalPlan query;
            List<Attribute> keys = listOfKeys.get(i);
            List<HitExtractor> keyExtractors = this.hitExtractors(keys, extractorRegistry);
            ArrayList<String> keyFields = new ArrayList<String>(keyExtractors.size());
            for (HitExtractor extractor : keyExtractors) {
                if (!(extractor instanceof AbstractFieldHitExtractor)) continue;
                AbstractFieldHitExtractor hitExtractor = (AbstractFieldHitExtractor)extractor;
                if (hitExtractor.hitName() == null) {
                    keyFields.add(hitExtractor.fieldName());
                    continue;
                }
                keyFields = Collections.emptyList();
                break;
            }
            if ((query = plans.get(i)) instanceof EsQueryExec) {
                SearchSourceBuilder source = ((EsQueryExec)query).source(this.session, false);
                QueryRequest original = () -> source;
                BoxedQueryRequest boxedRequest = new BoxedQueryRequest(original, timestampName, keyFields);
                Criterion<BoxedQueryRequest> criterion = new Criterion<BoxedQueryRequest>(i, boxedRequest, keyExtractors, tsExtractor, tbExtractor, itbExtractor, i == 0 && descending);
                criteria.add(criterion);
                continue;
            }
            if (i != plans.size() - 1) {
                throw new EqlIllegalArgumentException("Expected a query but got [{}]", query.getClass());
            }
            criteria.add(null);
        }
        int completionStage = criteria.size() - 1;
        SequenceMatcher matcher = new SequenceMatcher(completionStage, descending, maxSpan, limit, this.session.circuitBreaker());
        TumblingWindow w = new TumblingWindow(new PITAwareQueryClient(this.session), criteria.subList(0, completionStage), (Criterion)criteria.get(completionStage), matcher);
        return w;
    }

    private HitExtractor timestampExtractor(HitExtractor hitExtractor) {
        if (hitExtractor instanceof FieldHitExtractor) {
            FieldHitExtractor fe = (FieldHitExtractor)hitExtractor;
            return fe instanceof TimestampFieldHitExtractor ? hitExtractor : new TimestampFieldHitExtractor(fe);
        }
        throw new EqlIllegalArgumentException("Unexpected extractor [{}]", hitExtractor);
    }

    private HitExtractor hitExtractor(Expression exp, FieldExtractorRegistry registry) {
        return RuntimeUtils.createExtractor(registry.fieldExtraction(exp), this.cfg);
    }

    private List<HitExtractor> hitExtractors(List<? extends Expression> exps, FieldExtractorRegistry registry) {
        ArrayList<HitExtractor> extractors = new ArrayList<HitExtractor>(exps.size());
        for (Expression expression : exps) {
            extractors.add(this.hitExtractor(expression, registry));
        }
        return extractors;
    }
}

