/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.assembler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.eql.execution.search.Ordinal;
import org.elasticsearch.xpack.eql.execution.search.QueryRequest;
import org.elasticsearch.xpack.eql.execution.search.RuntimeUtils;
import org.elasticsearch.xpack.ql.util.CollectionUtils;

public class BoxedQueryRequest
implements QueryRequest {
    public static final int MAX_TERMS = 128;
    private final RangeQueryBuilder timestampRange;
    private final SearchSourceBuilder searchSource;
    private final List<String> keys;
    private List<QueryBuilder> keyFilters;
    private Ordinal from;
    private Ordinal to;
    private Ordinal after;

    public BoxedQueryRequest(QueryRequest original, String timestamp, List<String> keyNames) {
        this.searchSource = original.searchSource();
        this.timestampRange = QueryBuilders.rangeQuery((String)timestamp).timeZone("UTC").format("epoch_millis");
        this.keys = keyNames;
        RuntimeUtils.addFilter((QueryBuilder)this.timestampRange, this.searchSource);
    }

    @Override
    public SearchSourceBuilder searchSource() {
        return this.searchSource;
    }

    @Override
    public void nextAfter(Ordinal ordinal) {
        this.after = ordinal;
        this.searchSource.searchAfter(ordinal.toArray());
    }

    public BoxedQueryRequest from(Ordinal begin) {
        this.from = begin;
        this.timestampRange.gte(begin != null ? Long.valueOf(begin.timestamp()) : null);
        return this;
    }

    public BoxedQueryRequest to(Ordinal end) {
        this.to = end;
        this.timestampRange.lte(end != null ? Long.valueOf(end.timestamp()) : null);
        return this;
    }

    public BoxedQueryRequest keys(List<List<Object>> values) {
        List<Object> newFilters;
        if (CollectionUtils.isEmpty(values)) {
            if (CollectionUtils.isEmpty(this.keyFilters)) {
                return this;
            }
            newFilters = Collections.emptyList();
        } else {
            newFilters = new ArrayList(values.size());
            for (int keyIndex = 0; keyIndex < this.keys.size(); ++keyIndex) {
                boolean hasNullValue = false;
                HashSet<Object> keyValues = new HashSet<Object>(128);
                for (List<Object> value : values) {
                    Object keyValue = value.get(keyIndex);
                    if (keyValue == null) {
                        hasNullValue = true;
                        continue;
                    }
                    keyValues.add(keyValue);
                }
                if (keyValues.size() > 128) {
                    newFilters = Collections.emptyList();
                    break;
                }
                TermQueryBuilder query = null;
                String key = this.keys.get(keyIndex);
                if (keyValues.size() == 1) {
                    query = QueryBuilders.termQuery((String)key, keyValues.iterator().next());
                } else if (keyValues.size() > 1) {
                    query = QueryBuilders.termsQuery((String)key, keyValues);
                }
                if (hasNullValue) {
                    BoolQueryBuilder isMissing = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)key));
                    query = query != null ? QueryBuilders.boolQuery().should((QueryBuilder)query).should((QueryBuilder)isMissing) : isMissing;
                }
                newFilters.add((QueryBuilder)query);
            }
        }
        RuntimeUtils.replaceFilter(this.keyFilters, newFilters, this.searchSource);
        this.keyFilters = newFilters;
        return this;
    }

    public Ordinal after() {
        return this.after;
    }

    public Ordinal from() {
        return this.from;
    }

    public Ordinal to() {
        return this.to;
    }

    public String toString() {
        return "( " + BoxedQueryRequest.string(this.from) + " >-" + BoxedQueryRequest.string(this.after) + "-> " + BoxedQueryRequest.string(this.to) + "]";
    }

    private static String string(Ordinal o) {
        return o != null ? o.toString() : "<none>";
    }
}

