/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.input.http;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.watcher.input.Input;
import org.elasticsearch.xpack.core.watcher.watch.Payload;
import org.elasticsearch.xpack.watcher.common.http.HttpContentType;
import org.elasticsearch.xpack.watcher.common.http.HttpRequest;
import org.elasticsearch.xpack.watcher.common.http.HttpRequestTemplate;

public class HttpInput
implements Input {
    public static final String TYPE = "http";
    private final HttpRequestTemplate request;
    @Nullable
    private final HttpContentType expectedResponseXContentType;
    @Nullable
    private final Set<String> extractKeys;

    public HttpInput(HttpRequestTemplate request, @Nullable HttpContentType expectedResponseXContentType, @Nullable Set<String> extractKeys) {
        this.request = request;
        this.expectedResponseXContentType = expectedResponseXContentType;
        this.extractKeys = extractKeys;
    }

    public String type() {
        return TYPE;
    }

    public HttpRequestTemplate getRequest() {
        return this.request;
    }

    public Set<String> getExtractKeys() {
        return this.extractKeys;
    }

    public HttpContentType getExpectedResponseXContentType() {
        return this.expectedResponseXContentType;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Field.REQUEST.getPreferredName(), (ToXContent)this.request, params);
        if (this.extractKeys != null) {
            builder.field(Field.EXTRACT.getPreferredName(), this.extractKeys);
        }
        if (this.expectedResponseXContentType != null) {
            builder.field(Field.RESPONSE_CONTENT_TYPE.getPreferredName(), this.expectedResponseXContentType.id());
        }
        builder.endObject();
        return builder;
    }

    public static HttpInput parse(String watchId, XContentParser parser) throws IOException {
        XContentParser.Token token;
        HashSet<String> extract = null;
        HttpRequestTemplate request = null;
        HttpContentType expectedResponseBodyType = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (Field.REQUEST.match(currentFieldName, parser.getDeprecationHandler())) {
                try {
                    request = HttpRequestTemplate.Parser.parse(parser);
                    continue;
                }
                catch (ElasticsearchParseException pe) {
                    throw new ElasticsearchParseException("could not parse [{}] input for watch [{}]. failed to parse http request template", (Throwable)pe, new Object[]{TYPE, watchId});
                }
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (Field.EXTRACT.getPreferredName().equals(currentFieldName)) {
                    extract = new HashSet<String>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (token == XContentParser.Token.VALUE_STRING) {
                            extract.add(parser.text());
                            continue;
                        }
                        throw new ElasticsearchParseException("could not parse [{}] input for watch [{}]. expected a string value as an [{}] item but found [{}] instead", new Object[]{TYPE, watchId, currentFieldName, token});
                    }
                    continue;
                }
                throw new ElasticsearchParseException("could not parse [{}] input for watch [{}]. unexpected array field [{}]", new Object[]{TYPE, watchId, currentFieldName});
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if (Field.RESPONSE_CONTENT_TYPE.match(currentFieldName, parser.getDeprecationHandler())) {
                    expectedResponseBodyType = HttpContentType.resolve(parser.text());
                    if (expectedResponseBodyType != null) continue;
                    throw new ElasticsearchParseException("could not parse [{}] input for watch [{}]. unknown content type [{}]", new Object[]{TYPE, watchId, parser.text()});
                }
                throw new ElasticsearchParseException("could not parse [{}] input for watch [{}]. unexpected string field [{}]", new Object[]{TYPE, watchId, currentFieldName});
            }
            throw new ElasticsearchParseException("could not parse [{}] input for watch [{}]. unexpected token [{}]", new Object[]{TYPE, watchId, token});
        }
        if (request == null) {
            throw new ElasticsearchParseException("could not parse [{}] input for watch [{}]. missing require [{}] field", new Object[]{TYPE, watchId, Field.REQUEST.getPreferredName()});
        }
        if (expectedResponseBodyType == HttpContentType.TEXT && extract != null) {
            throw new ElasticsearchParseException("could not parse [{}] input for watch [{}]. key extraction is not supported for content type [{}]", new Object[]{TYPE, watchId, expectedResponseBodyType});
        }
        return new HttpInput(request, expectedResponseBodyType, extract);
    }

    public static Builder builder(HttpRequestTemplate httpRequest) {
        return new Builder(httpRequest);
    }

    static interface Field {
        public static final ParseField REQUEST = new ParseField("request", new String[0]);
        public static final ParseField EXTRACT = new ParseField("extract", new String[0]);
        public static final ParseField STATUS_CODE = new ParseField("status_code", new String[0]);
        public static final ParseField RESPONSE_CONTENT_TYPE = new ParseField("response_content_type", new String[0]);
    }

    public static class Builder
    implements Input.Builder<HttpInput> {
        private final HttpRequestTemplate request;
        private final Set<String> extractKeys = new HashSet<String>();
        private HttpContentType expectedResponseXContentType = null;

        private Builder(HttpRequestTemplate request) {
            this.request = request;
        }

        public Builder extractKeys(Collection<String> keys) {
            this.extractKeys.addAll(keys);
            return this;
        }

        public Builder extractKeys(String ... keys) {
            Collections.addAll(this.extractKeys, keys);
            return this;
        }

        public Builder expectedResponseXContentType(HttpContentType expectedResponseXContentType) {
            this.expectedResponseXContentType = expectedResponseXContentType;
            return this;
        }

        public HttpInput build() {
            return new HttpInput(this.request, this.expectedResponseXContentType, this.extractKeys.isEmpty() ? null : Collections.unmodifiableSet(this.extractKeys));
        }
    }

    public static class Result
    extends Input.Result {
        @Nullable
        private final HttpRequest request;
        final int statusCode;

        public Result(HttpRequest request, int statusCode, Payload payload) {
            super(HttpInput.TYPE, payload);
            this.request = request;
            this.statusCode = statusCode;
        }

        public Result(@Nullable HttpRequest request, Exception e) {
            super(HttpInput.TYPE, e);
            this.request = request;
            this.statusCode = -1;
        }

        public HttpRequest request() {
            return this.request;
        }

        protected XContentBuilder typeXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.request == null) {
                return builder;
            }
            builder.startObject(this.type);
            builder.field(Field.REQUEST.getPreferredName(), (ToXContent)this.request, params);
            if (this.statusCode > 0) {
                builder.field(Field.STATUS_CODE.getPreferredName(), this.statusCode);
            }
            return builder.endObject();
        }
    }
}

