/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.input;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.watcher.input.ExecutableInput;
import org.elasticsearch.xpack.watcher.input.InputFactory;
import org.elasticsearch.xpack.watcher.input.chain.ChainInputFactory;

public class InputRegistry {
    private final Map<String, InputFactory> factories;

    public InputRegistry(Map<String, InputFactory> factories) {
        HashMap<String, InputFactory> map = new HashMap<String, InputFactory>(factories);
        map.put("chain", new ChainInputFactory(this));
        this.factories = Collections.unmodifiableMap(map);
    }

    public ExecutableInput<?, ?> parse(String watchId, XContentParser parser) throws IOException {
        XContentParser.Token token;
        String type = null;
        if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("could not parse input for watch [{}]. expected an object representing the input, but found [{}] instead", new Object[]{watchId, parser.currentToken()});
        }
        ExecutableInput<?, ?> input = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                type = parser.currentName();
                continue;
            }
            if (type == null) {
                throw new ElasticsearchParseException("could not parse input for watch [{}]. expected field indicating the input type, but found [{}] instead", new Object[]{watchId, token});
            }
            if (token == XContentParser.Token.START_OBJECT) {
                InputFactory factory = this.factories.get(type);
                if (factory == null) {
                    throw new ElasticsearchParseException("could not parse input for watch [{}]. unknown input type [{}]", new Object[]{watchId, type});
                }
                input = (ExecutableInput<?, ?>)factory.parseExecutable(watchId, parser);
                continue;
            }
            throw new ElasticsearchParseException("could not parse input for watch [{}]. expected an object representing input [{}], but found [{}] instead", new Object[]{watchId, type, token});
        }
        if (input == null) {
            throw new ElasticsearchParseException("could not parse input for watch [{}]. expected field indicating the input type, but found an empty object instead", new Object[]{watchId, token});
        }
        return input;
    }

    public Map<String, InputFactory> factories() {
        return this.factories;
    }
}

