/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.actions.pagerduty;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.watcher.actions.Action;
import org.elasticsearch.xpack.watcher.notification.pagerduty.IncidentEvent;
import org.elasticsearch.xpack.watcher.notification.pagerduty.SentEvent;

public class PagerDutyAction
implements Action {
    public static final String TYPE = "pagerduty";
    final IncidentEvent.Template event;

    public PagerDutyAction(IncidentEvent.Template event) {
        this.event = event;
    }

    public String type() {
        return TYPE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PagerDutyAction that = (PagerDutyAction)o;
        return Objects.equals(this.event, that.event);
    }

    public int hashCode() {
        return Objects.hash(this.event);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.event.toXContent(builder, params);
        return builder;
    }

    public static PagerDutyAction parse(String watchId, String actionId, XContentParser parser) throws IOException {
        IncidentEvent.Template eventTemplate = IncidentEvent.Template.parse(watchId, actionId, parser);
        return new PagerDutyAction(eventTemplate);
    }

    public static Builder builder(IncidentEvent.Template event) {
        return new Builder(new PagerDutyAction(event));
    }

    public static class Builder
    implements Action.Builder<PagerDutyAction> {
        final PagerDutyAction action;

        public Builder(PagerDutyAction action) {
            this.action = action;
        }

        public PagerDutyAction build() {
            return this.action;
        }
    }

    public static interface XField {
        public static final ParseField SENT_EVENT = new ParseField("sent_event", new String[0]);
        public static final ParseField EVENT = new ParseField("event", new String[0]);
    }

    public static interface Result {

        public static class Simulated
        extends Action.Result
        implements Result {
            private final IncidentEvent event;

            protected Simulated(IncidentEvent event) {
                super(PagerDutyAction.TYPE, Action.Result.Status.SIMULATED);
                this.event = event;
            }

            public IncidentEvent event() {
                return this.event;
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                return builder.startObject(this.type).field(XField.EVENT.getPreferredName(), (ToXContent)this.event, params).endObject();
            }
        }

        public static class Executed
        extends Action.Result
        implements Result {
            private final String account;
            private final SentEvent sentEvent;

            public Executed(String account, SentEvent sentEvent) {
                super(PagerDutyAction.TYPE, Executed.status(sentEvent));
                this.account = account;
                this.sentEvent = sentEvent;
            }

            public SentEvent sentEvent() {
                return this.sentEvent;
            }

            public String account() {
                return this.account;
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject(this.type);
                builder.field(XField.SENT_EVENT.getPreferredName(), (ToXContent)this.sentEvent, params);
                return builder.endObject();
            }

            static Action.Result.Status status(SentEvent sentEvent) {
                return sentEvent.successful() ? Action.Result.Status.SUCCESS : Action.Result.Status.FAILURE;
            }
        }
    }
}

