/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.net.InetAddress;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.script.AbstractFieldScript;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptFactory;
import org.elasticsearch.search.lookup.SearchLookup;

public abstract class IpFieldScript
extends AbstractFieldScript {
    public static final ScriptContext<Factory> CONTEXT = IpFieldScript.newContext("ip_field", Factory.class);
    public static final Factory PARSE_FROM_SOURCE = (field, params, lookup) -> ctx -> new IpFieldScript(field, params, lookup, ctx){

        @Override
        public void execute() {
            this.emitFromSource();
        }
    };
    public static final String[] PARAMETERS = new String[0];
    private BytesRef[] values = new BytesRef[1];
    private int count;

    public IpFieldScript(String fieldName, Map<String, Object> params, SearchLookup searchLookup, LeafReaderContext ctx) {
        super(fieldName, params, searchLookup, ctx);
    }

    public final void runForDoc(int docId) {
        this.count = 0;
        this.setDocument(docId);
        this.execute();
    }

    public final void runForDoc(int docId, Consumer<InetAddress> consumer) {
        this.runForDoc(docId);
        for (int i = 0; i < this.count; ++i) {
            consumer.accept(InetAddressPoint.decode((byte[])this.values[i].bytes));
        }
    }

    public final BytesRef[] values() {
        return this.values;
    }

    public final int count() {
        return this.count;
    }

    @Override
    protected void emitFromObject(Object v) {
        if (v instanceof String) {
            try {
                this.emit((String)v);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final void emit(String v) {
        this.checkMaxSize(this.count);
        if (this.values.length < this.count + 1) {
            this.values = (BytesRef[])ArrayUtil.grow((Object[])this.values, (int)(this.count + 1));
        }
        BytesRef encoded = new BytesRef(InetAddressPoint.encode((InetAddress)InetAddresses.forString(v)));
        this.values[this.count++] = encoded;
    }

    public static interface LeafFactory {
        public IpFieldScript newInstance(LeafReaderContext var1);
    }

    public static interface Factory
    extends ScriptFactory {
        public LeafFactory newFactory(String var1, Map<String, Object> var2, SearchLookup var3);
    }

    public static class Emit {
        private final IpFieldScript script;

        public Emit(IpFieldScript script) {
            this.script = script;
        }

        public void emit(String v) {
            this.script.emit(v);
        }
    }
}

