/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.net.InetAddress;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.lucene.document.DoubleRange;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatRange;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.document.InetAddressRange;
import org.apache.lucene.document.IntRange;
import org.apache.lucene.document.LongRange;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.BinaryDocValuesRangeQuery;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FutureArrays;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.BinaryRangeUtil;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.RangeFieldMapper;
import org.elasticsearch.index.query.SearchExecutionContext;

public abstract class RangeType
extends Enum<RangeType> {
    public static final /* enum */ RangeType IP = new RangeType("ip_range", LengthType.FIXED_16){

        @Override
        public Field getRangeField(String name, RangeFieldMapper.Range r) {
            return new InetAddressRange(name, (InetAddress)r.from, (InetAddress)r.to);
        }

        @Override
        public InetAddress parseFrom(RangeFieldMapper.RangeFieldType fieldType, XContentParser parser, boolean coerce, boolean included) throws IOException {
            InetAddress address = InetAddresses.forString(parser.text());
            return included ? address : this.nextUp(address);
        }

        @Override
        public InetAddress parseTo(RangeFieldMapper.RangeFieldType fieldType, XContentParser parser, boolean coerce, boolean included) throws IOException {
            InetAddress address = InetAddresses.forString(parser.text());
            return included ? address : this.nextDown(address);
        }

        @Override
        public InetAddress parseValue(Object value, boolean coerce, @Nullable DateMathParser dateMathParser) {
            if (value instanceof InetAddress) {
                return (InetAddress)value;
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            return InetAddresses.forString(value.toString());
        }

        @Override
        public Object formatValue(Object value, DateFormatter dateFormatter) {
            return InetAddresses.toAddrString((InetAddress)value);
        }

        @Override
        public InetAddress minValue() {
            return InetAddressPoint.MIN_VALUE;
        }

        @Override
        public InetAddress maxValue() {
            return InetAddressPoint.MAX_VALUE;
        }

        @Override
        public InetAddress nextUp(Object value) {
            return InetAddressPoint.nextUp((InetAddress)((InetAddress)value));
        }

        @Override
        public InetAddress nextDown(Object value) {
            return InetAddressPoint.nextDown((InetAddress)((InetAddress)value));
        }

        @Override
        public BytesRef encodeRanges(Set<RangeFieldMapper.Range> ranges) throws IOException {
            return BinaryRangeUtil.encodeIPRanges(ranges);
        }

        @Override
        public List<RangeFieldMapper.Range> decodeRanges(BytesRef bytes) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Double doubleValue(Object endpointValue) {
            throw new UnsupportedOperationException("IP ranges cannot be safely converted to doubles");
        }

        @Override
        public Query dvRangeQuery(String field, BinaryDocValuesRangeQuery.QueryType queryType, Object from, Object to, boolean includeFrom, boolean includeTo) {
            if (!includeFrom) {
                from = this.nextUp(from);
            }
            if (!includeTo) {
                to = this.nextDown(to);
            }
            byte[] encodedFrom = InetAddressPoint.encode((InetAddress)((InetAddress)from));
            byte[] encodedTo = InetAddressPoint.encode((InetAddress)((InetAddress)to));
            return new BinaryDocValuesRangeQuery(field, queryType, LengthType.FIXED_16, new BytesRef(encodedFrom), new BytesRef(encodedTo), from, to);
        }

        @Override
        public Query withinQuery(String field, Object from, Object to, boolean includeFrom, boolean includeTo) {
            return this.createQuery(field, from, to, includeFrom, includeTo, (f, t) -> InetAddressRange.newWithinQuery((String)field, (InetAddress)f, (InetAddress)t));
        }

        @Override
        public Query containsQuery(String field, Object from, Object to, boolean includeFrom, boolean includeTo) {
            return this.createQuery(field, from, to, includeFrom, includeTo, (f, t) -> InetAddressRange.newContainsQuery((String)field, (InetAddress)f, (InetAddress)t));
        }

        @Override
        public Query intersectsQuery(String field, Object from, Object to, boolean includeFrom, boolean includeTo) {
            return this.createQuery(field, from, to, includeFrom, includeTo, (f, t) -> InetAddressRange.newIntersectsQuery((String)field, (InetAddress)f, (InetAddress)t));
        }

        private Query createQuery(String field, Object lower, Object upper, boolean includeLower, boolean includeUpper, BiFunction<InetAddress, InetAddress, Query> querySupplier) {
            byte[] upperBytes;
            byte[] lowerBytes = InetAddressPoint.encode((InetAddress)((InetAddress)lower));
            if (FutureArrays.compareUnsigned((byte[])lowerBytes, (int)0, (int)lowerBytes.length, (byte[])(upperBytes = InetAddressPoint.encode((InetAddress)((InetAddress)upper))), (int)0, (int)upperBytes.length) > 0) {
                throw new IllegalArgumentException("Range query `from` value (" + lower + ") is greater than `to` value (" + upper + ")");
            }
            InetAddress correctedFrom = includeLower ? (InetAddress)lower : this.nextUp(lower);
            InetAddress correctedTo = includeUpper ? (InetAddress)upper : this.nextDown(upper);
            lowerBytes = InetAddressPoint.encode((InetAddress)correctedFrom);
            if (FutureArrays.compareUnsigned((byte[])lowerBytes, (int)0, (int)lowerBytes.length, (byte[])(upperBytes = InetAddressPoint.encode((InetAddress)correctedTo)), (int)0, (int)upperBytes.length) > 0) {
                return new MatchNoDocsQuery("float range didn't intersect anything");
            }
            return querySupplier.apply(correctedFrom, correctedTo);
        }
    };
    public static final /* enum */ RangeType DATE = new RangeType("date_range", LengthType.VARIABLE, NumberFieldMapper.NumberType.LONG){

        @Override
        public Field getRangeField(String name, RangeFieldMapper.Range r) {
            return new LongRange(name, new long[]{((Number)r.from).longValue()}, new long[]{((Number)r.to).longValue()});
        }

        @Override
        public Number parseFrom(RangeFieldMapper.RangeFieldType fieldType, XContentParser parser, boolean coerce, boolean included) throws IOException {
            Long value = this.parseValue(parser.text(), coerce, fieldType.dateMathParser);
            return included ? value : this.nextUp(value);
        }

        @Override
        public Number parseTo(RangeFieldMapper.RangeFieldType fieldType, XContentParser parser, boolean coerce, boolean included) throws IOException {
            Long value = this.parseValue(parser.text(), coerce, fieldType.dateMathParser);
            return included ? value : this.nextDown(value);
        }

        @Override
        public Long parseValue(Object dateStr, boolean coerce, @Nullable DateMathParser dateMathParser) {
            assert (dateMathParser != null);
            return dateMathParser.parse(dateStr.toString(), () -> {
                throw new IllegalArgumentException("now is not used at indexing time");
            }).toEpochMilli();
        }

        @Override
        public Object formatValue(Object value, DateFormatter dateFormatter) {
            long timestamp = (Long)value;
            ZonedDateTime dateTime = Instant.ofEpochMilli(timestamp).atZone(ZoneOffset.UTC);
            return dateFormatter.format(dateTime);
        }

        @Override
        public Long minValue() {
            return Long.MIN_VALUE;
        }

        @Override
        public Long maxValue() {
            return Long.MAX_VALUE;
        }

        @Override
        public Long nextUp(Object value) {
            return (long)((Long)LONG.nextUp(value));
        }

        @Override
        public Long nextDown(Object value) {
            return (long)((Long)LONG.nextDown(value));
        }

        @Override
        public BytesRef encodeRanges(Set<RangeFieldMapper.Range> ranges) throws IOException {
            return LONG.encodeRanges(ranges);
        }

        @Override
        public List<RangeFieldMapper.Range> decodeRanges(BytesRef bytes) {
            return LONG.decodeRanges(bytes);
        }

        @Override
        public Double doubleValue(Object endpointValue) {
            return LONG.doubleValue(endpointValue);
        }

        @Override
        public Query dvRangeQuery(String field, BinaryDocValuesRangeQuery.QueryType queryType, Object from, Object to, boolean includeFrom, boolean includeTo) {
            return LONG.dvRangeQuery(field, queryType, from, to, includeFrom, includeTo);
        }

        @Override
        public Query rangeQuery(String field, boolean hasDocValues, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ShapeRelation relation, @Nullable ZoneId timeZone, @Nullable DateMathParser parser, SearchExecutionContext context) {
            boolean roundUp;
            ZoneId zone = timeZone == null ? ZoneOffset.UTC : timeZone;
            DateMathParser dateMathParser = parser == null ? DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.toDateMathParser() : parser;
            boolean bl = roundUp = !includeLower;
            Long low = lowerTerm == null ? this.minValue().longValue() : dateMathParser.parse(lowerTerm instanceof BytesRef ? ((BytesRef)lowerTerm).utf8ToString() : lowerTerm.toString(), context::nowInMillis, roundUp, zone).toEpochMilli();
            roundUp = includeUpper;
            Long high = upperTerm == null ? this.maxValue().longValue() : dateMathParser.parse(upperTerm instanceof BytesRef ? ((BytesRef)upperTerm).utf8ToString() : upperTerm.toString(), context::nowInMillis, roundUp, zone).toEpochMilli();
            return this.createRangeQuery(field, hasDocValues, low, high, includeLower, includeUpper, relation);
        }

        @Override
        public Query withinQuery(String field, Object from, Object to, boolean includeLower, boolean includeUpper) {
            return LONG.withinQuery(field, from, to, includeLower, includeUpper);
        }

        @Override
        public Query containsQuery(String field, Object from, Object to, boolean includeLower, boolean includeUpper) {
            return LONG.containsQuery(field, from, to, includeLower, includeUpper);
        }

        @Override
        public Query intersectsQuery(String field, Object from, Object to, boolean includeLower, boolean includeUpper) {
            return LONG.intersectsQuery(field, from, to, includeLower, includeUpper);
        }
    };
    public static final /* enum */ RangeType FLOAT = new RangeType("float_range", LengthType.FIXED_4, NumberFieldMapper.NumberType.FLOAT){

        @Override
        public Float minValue() {
            return Float.valueOf(Float.NEGATIVE_INFINITY);
        }

        @Override
        public Float maxValue() {
            return Float.valueOf(Float.POSITIVE_INFINITY);
        }

        @Override
        public Float nextUp(Object value) {
            return Float.valueOf(Math.nextUp(((Number)value).floatValue()));
        }

        @Override
        public Float nextDown(Object value) {
            return Float.valueOf(Math.nextDown(((Number)value).floatValue()));
        }

        @Override
        public BytesRef encodeRanges(Set<RangeFieldMapper.Range> ranges) throws IOException {
            return BinaryRangeUtil.encodeFloatRanges(ranges);
        }

        @Override
        public List<RangeFieldMapper.Range> decodeRanges(BytesRef bytes) {
            return BinaryRangeUtil.decodeFloatRanges(bytes);
        }

        @Override
        public Double doubleValue(Object endpointValue) {
            assert (endpointValue instanceof Float);
            return ((Float)endpointValue).doubleValue();
        }

        @Override
        public Query dvRangeQuery(String field, BinaryDocValuesRangeQuery.QueryType queryType, Object from, Object to, boolean includeFrom, boolean includeTo) {
            if (!includeFrom) {
                from = this.nextUp(from);
            }
            if (!includeTo) {
                to = this.nextDown(to);
            }
            byte[] encodedFrom = BinaryRangeUtil.encodeFloat(((Float)from).floatValue());
            byte[] encodedTo = BinaryRangeUtil.encodeFloat(((Float)to).floatValue());
            return new BinaryDocValuesRangeQuery(field, queryType, LengthType.FIXED_4, new BytesRef(encodedFrom), new BytesRef(encodedTo), from, to);
        }

        @Override
        public Field getRangeField(String name, RangeFieldMapper.Range r) {
            return new FloatRange(name, new float[]{((Number)r.from).floatValue()}, new float[]{((Number)r.to).floatValue()});
        }

        @Override
        public Query withinQuery(String field, Object from, Object to, boolean includeFrom, boolean includeTo) {
            return RangeType.createQuery(field, (Float)from, (Float)to, includeFrom, includeTo, (f, t) -> FloatRange.newWithinQuery((String)field, (float[])new float[]{f.floatValue()}, (float[])new float[]{t.floatValue()}), FLOAT);
        }

        @Override
        public Query containsQuery(String field, Object from, Object to, boolean includeFrom, boolean includeTo) {
            return RangeType.createQuery(field, (Float)from, (Float)to, includeFrom, includeTo, (f, t) -> FloatRange.newContainsQuery((String)field, (float[])new float[]{f.floatValue()}, (float[])new float[]{t.floatValue()}), FLOAT);
        }

        @Override
        public Query intersectsQuery(String field, Object from, Object to, boolean includeFrom, boolean includeTo) {
            return RangeType.createQuery(field, (Float)from, (Float)to, includeFrom, includeTo, (f, t) -> FloatRange.newIntersectsQuery((String)field, (float[])new float[]{f.floatValue()}, (float[])new float[]{t.floatValue()}), FLOAT);
        }
    };
    public static final /* enum */ RangeType DOUBLE = new RangeType("double_range", LengthType.FIXED_8, NumberFieldMapper.NumberType.DOUBLE){

        @Override
        public Double minValue() {
            return Double.NEGATIVE_INFINITY;
        }

        @Override
        public Double maxValue() {
            return Double.POSITIVE_INFINITY;
        }

        @Override
        public Double nextUp(Object value) {
            return Math.nextUp(((Number)value).doubleValue());
        }

        @Override
        public Double nextDown(Object value) {
            return Math.nextDown(((Number)value).doubleValue());
        }

        @Override
        public BytesRef encodeRanges(Set<RangeFieldMapper.Range> ranges) throws IOException {
            return BinaryRangeUtil.encodeDoubleRanges(ranges);
        }

        @Override
        public List<RangeFieldMapper.Range> decodeRanges(BytesRef bytes) {
            return BinaryRangeUtil.decodeDoubleRanges(bytes);
        }

        @Override
        public Double doubleValue(Object endpointValue) {
            assert (endpointValue instanceof Double);
            return (Double)endpointValue;
        }

        @Override
        public Query dvRangeQuery(String field, BinaryDocValuesRangeQuery.QueryType queryType, Object from, Object to, boolean includeFrom, boolean includeTo) {
            if (!includeFrom) {
                from = this.nextUp(from);
            }
            if (!includeTo) {
                to = this.nextDown(to);
            }
            byte[] encodedFrom = BinaryRangeUtil.encodeDouble((Double)from);
            byte[] encodedTo = BinaryRangeUtil.encodeDouble((Double)to);
            return new BinaryDocValuesRangeQuery(field, queryType, LengthType.FIXED_8, new BytesRef(encodedFrom), new BytesRef(encodedTo), from, to);
        }

        @Override
        public Field getRangeField(String name, RangeFieldMapper.Range r) {
            return new DoubleRange(name, new double[]{((Number)r.from).doubleValue()}, new double[]{((Number)r.to).doubleValue()});
        }

        @Override
        public Query withinQuery(String field, Object from, Object to, boolean includeFrom, boolean includeTo) {
            return RangeType.createQuery(field, (Double)from, (Double)to, includeFrom, includeTo, (f, t) -> DoubleRange.newWithinQuery((String)field, (double[])new double[]{f}, (double[])new double[]{t}), DOUBLE);
        }

        @Override
        public Query containsQuery(String field, Object from, Object to, boolean includeFrom, boolean includeTo) {
            return RangeType.createQuery(field, (Double)from, (Double)to, includeFrom, includeTo, (f, t) -> DoubleRange.newContainsQuery((String)field, (double[])new double[]{f}, (double[])new double[]{t}), DOUBLE);
        }

        @Override
        public Query intersectsQuery(String field, Object from, Object to, boolean includeFrom, boolean includeTo) {
            return RangeType.createQuery(field, (Double)from, (Double)to, includeFrom, includeTo, (f, t) -> DoubleRange.newIntersectsQuery((String)field, (double[])new double[]{f}, (double[])new double[]{t}), DOUBLE);
        }
    };
    public static final /* enum */ RangeType INTEGER = new RangeType("integer_range", LengthType.VARIABLE, NumberFieldMapper.NumberType.INTEGER){

        @Override
        public Integer minValue() {
            return Integer.MIN_VALUE;
        }

        @Override
        public Integer maxValue() {
            return Integer.MAX_VALUE;
        }

        @Override
        public Integer nextUp(Object value) {
            return ((Number)value).intValue() + 1;
        }

        @Override
        public Integer nextDown(Object value) {
            return ((Number)value).intValue() - 1;
        }

        @Override
        public BytesRef encodeRanges(Set<RangeFieldMapper.Range> ranges) throws IOException {
            return LONG.encodeRanges(ranges);
        }

        @Override
        public List<RangeFieldMapper.Range> decodeRanges(BytesRef bytes) {
            return LONG.decodeRanges(bytes);
        }

        @Override
        public Double doubleValue(Object endpointValue) {
            return LONG.doubleValue(endpointValue);
        }

        @Override
        public Query dvRangeQuery(String field, BinaryDocValuesRangeQuery.QueryType queryType, Object from, Object to, boolean includeFrom, boolean includeTo) {
            return LONG.dvRangeQuery(field, queryType, from, to, includeFrom, includeTo);
        }

        @Override
        public Field getRangeField(String name, RangeFieldMapper.Range r) {
            return new IntRange(name, new int[]{((Number)r.from).intValue()}, new int[]{((Number)r.to).intValue()});
        }

        @Override
        public Query withinQuery(String field, Object from, Object to, boolean includeFrom, boolean includeTo) {
            return RangeType.createQuery(field, (Integer)from, (Integer)to, includeFrom, includeTo, (f, t) -> IntRange.newWithinQuery((String)field, (int[])new int[]{f}, (int[])new int[]{t}), INTEGER);
        }

        @Override
        public Query containsQuery(String field, Object from, Object to, boolean includeFrom, boolean includeTo) {
            return RangeType.createQuery(field, (Integer)from, (Integer)to, includeFrom, includeTo, (f, t) -> IntRange.newContainsQuery((String)field, (int[])new int[]{f}, (int[])new int[]{t}), INTEGER);
        }

        @Override
        public Query intersectsQuery(String field, Object from, Object to, boolean includeFrom, boolean includeTo) {
            return RangeType.createQuery(field, (Integer)from, (Integer)to, includeFrom, includeTo, (f, t) -> IntRange.newIntersectsQuery((String)field, (int[])new int[]{f}, (int[])new int[]{t}), INTEGER);
        }
    };
    public static final /* enum */ RangeType LONG = new RangeType("long_range", LengthType.VARIABLE, NumberFieldMapper.NumberType.LONG){

        @Override
        public Long minValue() {
            return Long.MIN_VALUE;
        }

        @Override
        public Long maxValue() {
            return Long.MAX_VALUE;
        }

        @Override
        public Long nextUp(Object value) {
            return ((Number)value).longValue() + 1L;
        }

        @Override
        public Long nextDown(Object value) {
            return ((Number)value).longValue() - 1L;
        }

        @Override
        public BytesRef encodeRanges(Set<RangeFieldMapper.Range> ranges) throws IOException {
            return BinaryRangeUtil.encodeLongRanges(ranges);
        }

        @Override
        public List<RangeFieldMapper.Range> decodeRanges(BytesRef bytes) {
            return BinaryRangeUtil.decodeLongRanges(bytes);
        }

        @Override
        public Double doubleValue(Object endpointValue) {
            assert (endpointValue instanceof Long);
            return ((Long)endpointValue).doubleValue();
        }

        @Override
        public Query dvRangeQuery(String field, BinaryDocValuesRangeQuery.QueryType queryType, Object from, Object to, boolean includeFrom, boolean includeTo) {
            if (!includeFrom) {
                from = this.nextUp(from);
            }
            if (!includeTo) {
                to = this.nextDown(to);
            }
            byte[] encodedFrom = BinaryRangeUtil.encodeLong(((Number)from).longValue());
            byte[] encodedTo = BinaryRangeUtil.encodeLong(((Number)to).longValue());
            return new BinaryDocValuesRangeQuery(field, queryType, LengthType.VARIABLE, new BytesRef(encodedFrom), new BytesRef(encodedTo), from, to);
        }

        @Override
        public Field getRangeField(String name, RangeFieldMapper.Range r) {
            return new LongRange(name, new long[]{((Number)r.from).longValue()}, new long[]{((Number)r.to).longValue()});
        }

        @Override
        public Query withinQuery(String field, Object from, Object to, boolean includeFrom, boolean includeTo) {
            return RangeType.createQuery(field, (Long)from, (Long)to, includeFrom, includeTo, (f, t) -> LongRange.newWithinQuery((String)field, (long[])new long[]{f}, (long[])new long[]{t}), LONG);
        }

        @Override
        public Query containsQuery(String field, Object from, Object to, boolean includeFrom, boolean includeTo) {
            return RangeType.createQuery(field, (Long)from, (Long)to, includeFrom, includeTo, (f, t) -> LongRange.newContainsQuery((String)field, (long[])new long[]{f}, (long[])new long[]{t}), LONG);
        }

        @Override
        public Query intersectsQuery(String field, Object from, Object to, boolean includeFrom, boolean includeTo) {
            return RangeType.createQuery(field, (Long)from, (Long)to, includeFrom, includeTo, (f, t) -> LongRange.newIntersectsQuery((String)field, (long[])new long[]{f}, (long[])new long[]{t}), LONG);
        }
    };
    public final String name;
    private final NumberFieldMapper.NumberType numberType;
    public final LengthType lengthType;
    private static final /* synthetic */ RangeType[] $VALUES;

    public static RangeType[] values() {
        return (RangeType[])$VALUES.clone();
    }

    public static RangeType valueOf(String name) {
        return Enum.valueOf(RangeType.class, name);
    }

    private RangeType(String name, LengthType lengthType) {
        this.name = name;
        this.numberType = null;
        this.lengthType = lengthType;
    }

    private RangeType(String name, LengthType lengthType, NumberFieldMapper.NumberType type) {
        this.name = name;
        this.numberType = type;
        this.lengthType = lengthType;
    }

    public final String typeName() {
        return this.name;
    }

    private static <T extends Comparable<T>> Query createQuery(String field, T from, T to, boolean includeFrom, boolean includeTo, BiFunction<T, T, Query> querySupplier, RangeType rangeType) {
        T correctedTo;
        if (from.compareTo(to) > 0) {
            throw new IllegalArgumentException("Range query `from` value (" + from + ") is greater than `to` value (" + to + ")");
        }
        T correctedFrom = includeFrom ? from : (Comparable)rangeType.nextUp(from);
        Object object = correctedTo = includeTo ? to : (Comparable)rangeType.nextDown(to);
        if (correctedFrom.compareTo(correctedTo) > 0) {
            return new MatchNoDocsQuery("range didn't intersect anything");
        }
        return querySupplier.apply(correctedFrom, correctedTo);
    }

    public abstract Field getRangeField(String var1, RangeFieldMapper.Range var2);

    public List<IndexableField> createFields(ParseContext context, String name, RangeFieldMapper.Range range, boolean indexed, boolean docValued, boolean stored) {
        assert (range != null) : "range cannot be null when creating fields";
        ArrayList<IndexableField> fields = new ArrayList<IndexableField>();
        if (indexed) {
            fields.add((IndexableField)this.getRangeField(name, range));
        }
        if (docValued) {
            RangeFieldMapper.BinaryRangesDocValuesField field = (RangeFieldMapper.BinaryRangesDocValuesField)context.doc().getByKey(name);
            if (field == null) {
                field = new RangeFieldMapper.BinaryRangesDocValuesField(name, range, this);
                context.doc().addWithKey(name, field);
            } else {
                field.add(range);
            }
        }
        if (stored) {
            fields.add((IndexableField)new StoredField(name, range.toString()));
        }
        return fields;
    }

    public Object parseValue(Object value, boolean coerce, @Nullable DateMathParser dateMathParser) {
        return this.numberType.parse(value, coerce);
    }

    public Object formatValue(Object value, DateFormatter formatter) {
        return value;
    }

    public Object parseFrom(RangeFieldMapper.RangeFieldType fieldType, XContentParser parser, boolean coerce, boolean included) throws IOException {
        Number value = this.numberType.parse(parser, coerce);
        return included ? (Number)value : (Number)((Number)this.nextUp(value));
    }

    public Object parseTo(RangeFieldMapper.RangeFieldType fieldType, XContentParser parser, boolean coerce, boolean included) throws IOException {
        Number value = this.numberType.parse(parser, coerce);
        return included ? (Number)value : (Number)((Number)this.nextDown(value));
    }

    public abstract Object minValue();

    public abstract Object maxValue();

    public abstract Object nextUp(Object var1);

    public abstract Object nextDown(Object var1);

    public abstract Query withinQuery(String var1, Object var2, Object var3, boolean var4, boolean var5);

    public abstract Query containsQuery(String var1, Object var2, Object var3, boolean var4, boolean var5);

    public abstract Query intersectsQuery(String var1, Object var2, Object var3, boolean var4, boolean var5);

    public Query rangeQuery(String field, boolean hasDocValues, Object from, Object to, boolean includeFrom, boolean includeTo, ShapeRelation relation, @Nullable ZoneId timeZone, @Nullable DateMathParser dateMathParser, SearchExecutionContext context) {
        Object lower = from == null ? this.minValue() : this.parseValue(from, false, dateMathParser);
        Object upper = to == null ? this.maxValue() : this.parseValue(to, false, dateMathParser);
        return this.createRangeQuery(field, hasDocValues, lower, upper, includeFrom, includeTo, relation);
    }

    protected final Query createRangeQuery(String field, boolean hasDocValues, Object lower, Object upper, boolean includeFrom, boolean includeTo, ShapeRelation relation) {
        Query indexQuery = relation == ShapeRelation.WITHIN ? this.withinQuery(field, lower, upper, includeFrom, includeTo) : (relation == ShapeRelation.CONTAINS ? this.containsQuery(field, lower, upper, includeFrom, includeTo) : this.intersectsQuery(field, lower, upper, includeFrom, includeTo));
        if (hasDocValues) {
            BinaryDocValuesRangeQuery.QueryType queryType = relation == ShapeRelation.WITHIN ? BinaryDocValuesRangeQuery.QueryType.WITHIN : (relation == ShapeRelation.CONTAINS ? BinaryDocValuesRangeQuery.QueryType.CONTAINS : BinaryDocValuesRangeQuery.QueryType.INTERSECTS);
            Query dvQuery = this.dvRangeQuery(field, queryType, lower, upper, includeFrom, includeTo);
            return new IndexOrDocValuesQuery(indexQuery, dvQuery);
        }
        return indexQuery;
    }

    public abstract BytesRef encodeRanges(Set<RangeFieldMapper.Range> var1) throws IOException;

    public abstract List<RangeFieldMapper.Range> decodeRanges(BytesRef var1);

    public abstract Double doubleValue(Object var1);

    public boolean isNumeric() {
        return this.numberType != null;
    }

    public abstract Query dvRangeQuery(String var1, BinaryDocValuesRangeQuery.QueryType var2, Object var3, Object var4, boolean var5, boolean var6);

    public final Mapper.TypeParser parser() {
        return new FieldMapper.TypeParser((n, c) -> new RangeFieldMapper.Builder((String)n, this, RangeFieldMapper.COERCE_SETTING.get(c.getSettings()), c.indexVersionCreated()));
    }

    NumberFieldMapper.NumberType numberType() {
        return this.numberType;
    }

    private static /* synthetic */ RangeType[] $values() {
        return new RangeType[]{IP, DATE, FLOAT, DOUBLE, INTEGER, LONG};
    }

    static {
        $VALUES = RangeType.$values();
    }

    public static enum LengthType {
        FIXED_4{

            @Override
            public int readLength(byte[] bytes, int offset) {
                return 4;
            }
        }
        ,
        FIXED_8{

            @Override
            public int readLength(byte[] bytes, int offset) {
                return 8;
            }
        }
        ,
        FIXED_16{

            @Override
            public int readLength(byte[] bytes, int offset) {
                return 16;
            }
        }
        ,
        VARIABLE{

            @Override
            public int readLength(byte[] bytes, int offset) {
                int token = Byte.toUnsignedInt(bytes[offset]);
                int length = token >>> 3 & 0xF;
                if ((token & 0x80) == 0) {
                    length = 15 - length;
                }
                return 1 + length;
            }
        };


        public abstract int readLength(byte[] var1, int var2);
    }
}

