/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class Maps {
    private static final Set<Class<?>> IMMUTABLE_MAP_CLASSES = org.elasticsearch.core.Set.of((Object[])new Class[]{Collections.emptyMap().getClass(), Collections.unmodifiableMap(new HashMap()).getClass(), org.elasticsearch.core.Map.of().getClass(), org.elasticsearch.core.Map.of((Object)"a", (Object)"b").getClass()});

    public static <K, V> boolean deepEquals(Map<K, V> left, Map<K, V> right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null || left.size() != right.size()) {
            return false;
        }
        return left.entrySet().stream().allMatch(e -> right.containsKey(e.getKey()) && Objects.deepEquals(e.getValue(), right.get(e.getKey())));
    }

    public static <K, V> Map<K, V> copyMapWithRemovedEntry(Map<K, V> map, K key) {
        Objects.requireNonNull(map);
        Objects.requireNonNull(key);
        assert (Maps.checkIsImmutableMap(map, key, map.get(key)));
        return map.entrySet().stream().filter(k -> !key.equals(k.getKey())).collect(Collectors.collectingAndThen(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue), Collections::unmodifiableMap));
    }

    private static <K, V> boolean checkIsImmutableMap(Map<K, V> map, K key, V value) {
        if (IMMUTABLE_MAP_CLASSES.contains(map.getClass())) {
            return true;
        }
        try {
            map.put(key, value);
            return false;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return true;
        }
    }
}

