/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldcaps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.fieldcaps.FieldCapabilities;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesFailure;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesIndexRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesIndexResponse;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.elasticsearch.action.fieldcaps.IndexFieldCapabilities;
import org.elasticsearch.action.fieldcaps.TransportFieldCapabilitiesIndexAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.TransportService;

public class TransportFieldCapabilitiesAction
extends HandledTransportAction<FieldCapabilitiesRequest, FieldCapabilitiesResponse> {
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final TransportFieldCapabilitiesIndexAction shardAction;
    private final RemoteClusterService remoteClusterService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final Predicate<String> metadataFieldPred;

    @Inject
    public TransportFieldCapabilitiesAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, NodeClient client, TransportFieldCapabilitiesIndexAction shardAction, ActionFilters actionFilters, IndicesService indicesService, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:data/read/field_caps", transportService, actionFilters, FieldCapabilitiesRequest::new);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.remoteClusterService = transportService.getRemoteClusterService();
        this.shardAction = shardAction;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        Set<String> metadataFields = indicesService.getAllMetadataFields();
        this.metadataFieldPred = metadataFields::contains;
    }

    @Override
    protected void doExecute(Task task, FieldCapabilitiesRequest request, ActionListener<FieldCapabilitiesResponse> listener) {
        long nowInMillis = request.nowInMillis() == null ? System.currentTimeMillis() : request.nowInMillis();
        ClusterState clusterState = this.clusterService.state();
        Map<String, OriginalIndices> remoteClusterIndices = this.remoteClusterService.groupIndices(request.indicesOptions(), request.indices(), idx -> this.indexNameExpressionResolver.hasIndexAbstraction((String)idx, clusterState));
        OriginalIndices localIndices = remoteClusterIndices.remove("");
        String[] concreteIndices = localIndices == null ? Strings.EMPTY_ARRAY : this.indexNameExpressionResolver.concreteIndexNames(clusterState, localIndices);
        int totalNumRequest = concreteIndices.length + remoteClusterIndices.size();
        if (totalNumRequest == 0) {
            listener.onResponse(new FieldCapabilitiesResponse(new String[0], Collections.emptyMap()));
            return;
        }
        CountDown completionCounter = new CountDown(totalNumRequest);
        final List indexResponses = Collections.synchronizedList(new ArrayList());
        final FailureCollector indexFailures = new FailureCollector();
        final Runnable countDown = () -> {
            if (completionCounter.countDown()) {
                List<FieldCapabilitiesFailure> failures = indexFailures.values();
                if (indexResponses.size() > 0) {
                    if (request.isMergeResults()) {
                        listener.onResponse(this.merge(indexResponses, request.includeUnmapped(), new ArrayList<FieldCapabilitiesFailure>(failures)));
                    } else {
                        listener.onResponse(new FieldCapabilitiesResponse(indexResponses, new ArrayList<FieldCapabilitiesFailure>(failures)));
                    }
                } else if (indexFailures.size() > 0) {
                    listener.onFailure(failures.iterator().next().getException());
                } else {
                    listener.onResponse(new FieldCapabilitiesResponse(Collections.emptyList(), Collections.emptyList()));
                }
            }
        };
        for (final String index : concreteIndices) {
            this.shardAction.execute(new FieldCapabilitiesIndexRequest(request.fields(), index, localIndices, request.indexFilter(), nowInMillis, request.runtimeFields()), new ActionListener<FieldCapabilitiesIndexResponse>(){

                @Override
                public void onResponse(FieldCapabilitiesIndexResponse result) {
                    if (result.canMatch()) {
                        indexResponses.add(result);
                    }
                    countDown.run();
                }

                @Override
                public void onFailure(Exception e) {
                    indexFailures.collect(e, index);
                    countDown.run();
                }
            });
        }
        for (Map.Entry entry : remoteClusterIndices.entrySet()) {
            String clusterAlias = (String)entry.getKey();
            OriginalIndices originalIndices = (OriginalIndices)entry.getValue();
            Client remoteClusterClient = this.remoteClusterService.getRemoteClusterClient(this.threadPool, clusterAlias);
            FieldCapabilitiesRequest remoteRequest = new FieldCapabilitiesRequest();
            remoteRequest.setMergeResults(false);
            remoteRequest.indicesOptions(originalIndices.indicesOptions());
            remoteRequest.indices(originalIndices.indices());
            remoteRequest.fields(request.fields());
            remoteRequest.runtimeFields(request.runtimeFields());
            remoteRequest.indexFilter(request.indexFilter());
            remoteRequest.nowInMillis(nowInMillis);
            remoteClusterClient.fieldCaps(remoteRequest, ActionListener.wrap(response -> {
                for (FieldCapabilitiesIndexResponse resp : response.getIndexResponses()) {
                    indexResponses.add(new FieldCapabilitiesIndexResponse(RemoteClusterAware.buildRemoteIndexName(clusterAlias, resp.getIndexName()), resp.get(), resp.canMatch()));
                }
                for (FieldCapabilitiesFailure failure : response.getFailures()) {
                    Exception ex = failure.getException();
                    indexFailures.collectRemoteException(ex, clusterAlias, failure.getIndices());
                }
                countDown.run();
            }, ex -> {
                indexFailures.collectRemoteException((Exception)ex, clusterAlias, originalIndices.indices());
                countDown.run();
            }));
        }
    }

    private FieldCapabilitiesResponse merge(List<FieldCapabilitiesIndexResponse> indexResponses, boolean includeUnmapped, List<FieldCapabilitiesFailure> failures) {
        String[] indices = (String[])indexResponses.stream().map(FieldCapabilitiesIndexResponse::getIndexName).sorted().toArray(String[]::new);
        HashMap<String, Map<String, FieldCapabilities.Builder>> responseMapBuilder = new HashMap<String, Map<String, FieldCapabilities.Builder>>();
        for (FieldCapabilitiesIndexResponse response : indexResponses) {
            this.innerMerge(responseMapBuilder, response);
        }
        HashMap responseMap = new HashMap();
        for (Map.Entry entry : responseMapBuilder.entrySet()) {
            Map typeMapBuilder = (Map)entry.getValue();
            if (includeUnmapped) {
                this.addUnmappedFields(indices, (String)entry.getKey(), typeMapBuilder);
            }
            boolean multiTypes = typeMapBuilder.size() > 1;
            HashMap<String, FieldCapabilities> typeMap = new HashMap<String, FieldCapabilities>();
            for (Map.Entry fieldEntry : typeMapBuilder.entrySet()) {
                typeMap.put((String)fieldEntry.getKey(), ((FieldCapabilities.Builder)fieldEntry.getValue()).build(multiTypes));
            }
            responseMap.put((String)entry.getKey(), Collections.unmodifiableMap(typeMap));
        }
        return new FieldCapabilitiesResponse(indices, Collections.unmodifiableMap(responseMap), failures);
    }

    private void addUnmappedFields(String[] indices, String field, Map<String, FieldCapabilities.Builder> typeMap) {
        HashSet unmappedIndices = new HashSet();
        Arrays.stream(indices).forEach(unmappedIndices::add);
        typeMap.values().stream().forEach(b -> b.getIndices().stream().forEach(unmappedIndices::remove));
        if (!unmappedIndices.isEmpty()) {
            FieldCapabilities.Builder unmapped = new FieldCapabilities.Builder(field, "unmapped");
            typeMap.put("unmapped", unmapped);
            for (String index : unmappedIndices) {
                unmapped.add(index, false, false, false, Collections.emptyMap());
            }
        }
    }

    private void innerMerge(Map<String, Map<String, FieldCapabilities.Builder>> responseMapBuilder, FieldCapabilitiesIndexResponse response) {
        for (Map.Entry<String, IndexFieldCapabilities> entry : response.get().entrySet()) {
            String field = entry.getKey();
            boolean isMetadataField = response.getOriginVersion().onOrAfter(Version.V_7_13_0) ? entry.getValue().isMetadatafield() : this.metadataFieldPred.test(field);
            IndexFieldCapabilities fieldCap = entry.getValue();
            Map typeMap = responseMapBuilder.computeIfAbsent(field, f -> new HashMap());
            FieldCapabilities.Builder builder = typeMap.computeIfAbsent(fieldCap.getType(), key -> new FieldCapabilities.Builder(field, (String)key));
            builder.add(response.getIndexName(), isMetadataField, fieldCap.isSearchable(), fieldCap.isAggregatable(), fieldCap.meta());
        }
    }

    private class FailureCollector {
        final Map<Tuple<String, String>, FieldCapabilitiesFailure> indexFailures = Collections.synchronizedMap(new HashMap());

        private FailureCollector() {
        }

        List<FieldCapabilitiesFailure> values() {
            return new ArrayList<FieldCapabilitiesFailure>(this.indexFailures.values());
        }

        void collect(Exception e, String index) {
            Throwable cause = ExceptionsHelper.unwrapCause(e);
            Tuple groupingKey = new Tuple((Object)cause.getMessage(), (Object)cause.getClass().getName());
            this.indexFailures.compute((Tuple<String, String>)groupingKey, (k, v) -> v == null ? new FieldCapabilitiesFailure(new String[]{index}, e) : v.addIndex(index));
        }

        void collectRemoteException(Exception ex, String clusterAlias, String[] remoteIndices) {
            for (String failedIndex : remoteIndices) {
                this.collect(ex, RemoteClusterAware.buildRemoteIndexName(clusterAlias, failedIndex));
            }
        }

        int size() {
            return this.indexFailures.size();
        }
    }
}

