/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.service;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.hash.MessageDigests;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.core.CharArrays;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.authc.support.UsernamePasswordToken;
import org.elasticsearch.xpack.core.security.support.Validation;
import org.elasticsearch.xpack.security.authc.service.ServiceAccount;

public class ServiceAccountToken
implements AuthenticationToken,
Closeable {
    public static final byte MAGIC_BYTE = 0;
    public static final byte TOKEN_TYPE = 1;
    public static final byte RESERVED_BYTE = 0;
    public static final byte FORMAT_VERSION = 1;
    public static final byte[] PREFIX = new byte[]{0, 1, 0, 1};
    private static final Logger logger = LogManager.getLogger(ServiceAccountToken.class);
    private final ServiceAccountTokenId tokenId;
    private final SecureString secret;

    ServiceAccountToken(ServiceAccount.ServiceAccountId accountId, String tokenName, SecureString secret) {
        this.tokenId = new ServiceAccountTokenId(accountId, tokenName);
        this.secret = Objects.requireNonNull(secret, "service account token secret cannot be null");
    }

    public ServiceAccountTokenId getTokenId() {
        return this.tokenId;
    }

    public SecureString getSecret() {
        return this.secret;
    }

    public ServiceAccount.ServiceAccountId getAccountId() {
        return this.tokenId.getAccountId();
    }

    public String getTokenName() {
        return this.tokenId.getTokenName();
    }

    public String getQualifiedName() {
        return this.tokenId.getQualifiedName();
    }

    public SecureString asBearerString() throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            out.write(PREFIX, 0, PREFIX.length);
            out.write(this.getQualifiedName().getBytes(StandardCharsets.UTF_8));
            out.write(58);
            out.write(this.secret.toString().getBytes(StandardCharsets.UTF_8));
            String base64 = Base64.getEncoder().withoutPadding().encodeToString(out.toByteArray());
            SecureString secureString = new SecureString(base64.toCharArray());
            return secureString;
        }
    }

    public static ServiceAccountToken fromBearerString(SecureString bearerString) throws IOException {
        byte[] bytes = CharArrays.toUtf8Bytes((char[])bearerString.getChars());
        logger.trace("parsing token bytes {}", (Object)MessageDigests.toHexString((byte[])bytes));
        byte[] decodedBytes = Base64.getDecoder().decode(bytes);
        byte[] prefixBytes = Arrays.copyOfRange(decodedBytes, 0, 4);
        if (decodedBytes.length < 4 || !Arrays.equals(prefixBytes, PREFIX)) {
            logger.trace(() -> new ParameterizedMessage("service account token expects the 4 leading bytes to be {}, got {}.", (Object)Arrays.toString(PREFIX), (Object)Arrays.toString(prefixBytes)));
            return null;
        }
        byte[] contentBytes = Arrays.copyOfRange(decodedBytes, 4, decodedBytes.length);
        char[] content = CharArrays.utf8BytesToChars((byte[])contentBytes);
        int i = UsernamePasswordToken.indexOfColon((char[])content);
        if (i < 0) {
            logger.trace("failed to extract qualified service token name and secret, missing ':'");
            return null;
        }
        String qualifiedName = new String(Arrays.copyOfRange(content, 0, i));
        String[] split = Strings.delimitedListToStringArray((String)qualifiedName, (String)"/");
        if (split == null || split.length != 3) {
            logger.trace("The qualified name of a service token should take format of 'namespace/service_name/token_name', got [{}]", (Object)qualifiedName);
            return null;
        }
        return new ServiceAccountToken(new ServiceAccount.ServiceAccountId(split[0], split[1]), split[2], new SecureString(Arrays.copyOfRange(content, i + 1, content.length)));
    }

    @Override
    public void close() {
        this.secret.close();
    }

    public String toString() {
        return this.getQualifiedName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceAccountToken that = (ServiceAccountToken)o;
        return this.tokenId.equals(that.tokenId) && this.secret.equals((Object)that.secret);
    }

    public int hashCode() {
        return Objects.hash(this.tokenId, this.secret);
    }

    public static ServiceAccountToken newToken(ServiceAccount.ServiceAccountId accountId, String tokenName) {
        return new ServiceAccountToken(accountId, tokenName, UUIDs.randomBase64UUIDSecureString());
    }

    public String principal() {
        return this.tokenId.getAccountId().asPrincipal();
    }

    public Object credentials() {
        return this.secret;
    }

    public void clearCredentials() {
        this.close();
    }

    public static class ServiceAccountTokenId {
        private final ServiceAccount.ServiceAccountId accountId;
        private final String tokenName;

        public ServiceAccountTokenId(ServiceAccount.ServiceAccountId accountId, String tokenName) {
            this.accountId = Objects.requireNonNull(accountId, "service account ID cannot be null");
            if (!Validation.isValidServiceAccountTokenName((String)tokenName)) {
                throw new IllegalArgumentException(Validation.formatInvalidServiceTokenNameErrorMessage((String)tokenName));
            }
            this.tokenName = Objects.requireNonNull(tokenName, "service account token name cannot be null");
        }

        public ServiceAccount.ServiceAccountId getAccountId() {
            return this.accountId;
        }

        public String getTokenName() {
            return this.tokenName;
        }

        public String getQualifiedName() {
            return this.accountId.asPrincipal() + "/" + this.tokenName;
        }

        public String toString() {
            return this.getQualifiedName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ServiceAccountTokenId that = (ServiceAccountTokenId)o;
            return this.accountId.equals(that.accountId) && this.tokenName.equals(that.tokenName);
        }

        public int hashCode() {
            return Objects.hash(this.accountId, this.tokenName);
        }
    }
}

