/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm;

import java.util.Locale;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ilm.AsyncActionStep;
import org.elasticsearch.xpack.core.ilm.AsyncWaitStep;
import org.elasticsearch.xpack.core.ilm.ClusterStateActionStep;
import org.elasticsearch.xpack.core.ilm.ClusterStateWaitStep;
import org.elasticsearch.xpack.core.ilm.ErrorStep;
import org.elasticsearch.xpack.core.ilm.LifecycleExecutionState;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.ilm.PhaseCompleteStep;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.TerminalPolicyStep;
import org.elasticsearch.xpack.ilm.ExecuteStepsUpdateTask;
import org.elasticsearch.xpack.ilm.IndexLifecycleTransition;
import org.elasticsearch.xpack.ilm.MoveToErrorStepUpdateTask;
import org.elasticsearch.xpack.ilm.MoveToNextStepUpdateTask;
import org.elasticsearch.xpack.ilm.PolicyStepsRegistry;
import org.elasticsearch.xpack.ilm.SetStepInfoUpdateTask;
import org.elasticsearch.xpack.ilm.history.ILMHistoryItem;
import org.elasticsearch.xpack.ilm.history.ILMHistoryStore;

class IndexLifecycleRunner {
    private static final Logger logger = LogManager.getLogger(IndexLifecycleRunner.class);
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final PolicyStepsRegistry stepRegistry;
    private final ILMHistoryStore ilmHistoryStore;
    private final LongSupplier nowSupplier;

    IndexLifecycleRunner(PolicyStepsRegistry stepRegistry, ILMHistoryStore ilmHistoryStore, ClusterService clusterService, ThreadPool threadPool, LongSupplier nowSupplier) {
        this.stepRegistry = stepRegistry;
        this.ilmHistoryStore = ilmHistoryStore;
        this.clusterService = clusterService;
        this.nowSupplier = nowSupplier;
        this.threadPool = threadPool;
    }

    static Step getCurrentStep(PolicyStepsRegistry stepRegistry, String policy, IndexMetadata indexMetadata) {
        LifecycleExecutionState lifecycleState = LifecycleExecutionState.fromIndexMetadata((IndexMetadata)indexMetadata);
        Step.StepKey currentStepKey = LifecycleExecutionState.getCurrentStepKey((LifecycleExecutionState)lifecycleState);
        logger.trace("[{}] retrieved current step key: {}", (Object)indexMetadata.getIndex().getName(), (Object)currentStepKey);
        if (currentStepKey == null) {
            return stepRegistry.getFirstStep(policy);
        }
        return stepRegistry.getStep(indexMetadata, currentStepKey);
    }

    @Nullable
    private static Long calculateOriginationMillis(IndexMetadata indexMetadata) {
        LifecycleExecutionState lifecycleState = LifecycleExecutionState.fromIndexMetadata((IndexMetadata)indexMetadata);
        Long originationDate = indexMetadata.getSettings().getAsLong("index.lifecycle.origination_date", Long.valueOf(-1L));
        if (lifecycleState.getLifecycleDate() == null && originationDate == -1L) {
            return null;
        }
        return originationDate == -1L ? lifecycleState.getLifecycleDate() : originationDate;
    }

    boolean isReadyToTransitionToThisPhase(String policy, IndexMetadata indexMetadata, String phase) {
        Long lifecycleDate = IndexLifecycleRunner.calculateOriginationMillis(indexMetadata);
        if (lifecycleDate == null) {
            logger.trace("[{}] no index creation or origination date has been set yet", (Object)indexMetadata.getIndex().getName());
            return true;
        }
        TimeValue after = this.stepRegistry.getIndexAgeForPhase(policy, phase);
        long now = this.nowSupplier.getAsLong();
        long ageMillis = now - lifecycleDate;
        TimeValue age = ageMillis >= 0L ? new TimeValue(ageMillis) : (ageMillis == Long.MIN_VALUE ? new TimeValue(Long.MAX_VALUE) : new TimeValue(-ageMillis));
        if (logger.isTraceEnabled()) {
            logger.trace("[{}] checking for index age to be at least [{}] before performing actions in the \"{}\" phase. Now: {}, lifecycle date: {}, age: [{}{}/{}s]", (Object)indexMetadata.getIndex().getName(), (Object)after, (Object)phase, (Object)new TimeValue(now).seconds(), (Object)new TimeValue(lifecycleDate.longValue()).seconds(), (Object)(ageMillis < 0L ? "-" : ""), (Object)age, (Object)age.seconds());
        }
        return now >= lifecycleDate + after.getMillis();
    }

    void runPeriodicStep(final String policy, Metadata metadata, final IndexMetadata indexMetadata) {
        Step currentStep;
        final String index = indexMetadata.getIndex().getName();
        LifecycleExecutionState lifecycleState = LifecycleExecutionState.fromIndexMetadata((IndexMetadata)indexMetadata);
        try {
            currentStep = IndexLifecycleRunner.getCurrentStep(this.stepRegistry, policy, indexMetadata);
        }
        catch (Exception e) {
            this.markPolicyRetrievalError(policy, indexMetadata.getIndex(), lifecycleState, e);
            return;
        }
        if (currentStep == null) {
            if (!this.stepRegistry.policyExists(policy)) {
                this.markPolicyDoesNotExist(policy, indexMetadata.getIndex(), lifecycleState);
                return;
            }
            Step.StepKey currentStepKey = LifecycleExecutionState.getCurrentStepKey((LifecycleExecutionState)lifecycleState);
            if (TerminalPolicyStep.KEY.equals((Object)currentStepKey)) {
                return;
            }
            logger.error("current step [{}] for index [{}] with policy [{}] is not recognized", (Object)currentStepKey, (Object)index, (Object)policy);
            return;
        }
        if (currentStep instanceof TerminalPolicyStep) {
            logger.debug("policy [{}] for index [{}] complete, skipping execution", (Object)policy, (Object)index);
            return;
        }
        if (currentStep instanceof ErrorStep) {
            this.onErrorMaybeRetryFailedStep(policy, indexMetadata);
            return;
        }
        logger.trace("[{}] maybe running periodic step ({}) with current step {}", (Object)index, (Object)currentStep.getClass().getSimpleName(), (Object)currentStep.getKey());
        if (currentStep instanceof PhaseCompleteStep) {
            if (currentStep.getNextStepKey() == null) {
                logger.debug("[{}] stopping in the current phase ({}) as there are no more steps in the policy", (Object)index, (Object)currentStep.getKey().getPhase());
                return;
            }
            if (this.isReadyToTransitionToThisPhase(policy, indexMetadata, currentStep.getNextStepKey().getPhase())) {
                this.moveToStep(indexMetadata.getIndex(), policy, currentStep.getKey(), currentStep.getNextStepKey());
            }
        } else if (currentStep instanceof AsyncWaitStep) {
            logger.debug("[{}] running periodic policy with current-step [{}]", (Object)index, (Object)currentStep.getKey());
            ((AsyncWaitStep)currentStep).evaluateCondition(metadata, indexMetadata.getIndex(), new AsyncWaitStep.Listener(){

                public void onResponse(boolean conditionMet, ToXContentObject stepInfo) {
                    logger.trace("cs-change-async-wait-callback, [{}] current-step: {}", (Object)index, (Object)currentStep.getKey());
                    if (conditionMet) {
                        IndexLifecycleRunner.this.moveToStep(indexMetadata.getIndex(), policy, currentStep.getKey(), currentStep.getNextStepKey());
                    } else if (stepInfo != null) {
                        IndexLifecycleRunner.this.setStepInfo(indexMetadata.getIndex(), policy, currentStep.getKey(), stepInfo);
                    }
                }

                public void onFailure(Exception e) {
                    IndexLifecycleRunner.this.moveToErrorStep(indexMetadata.getIndex(), policy, currentStep.getKey(), e);
                }
            }, TimeValue.MAX_VALUE);
        } else {
            logger.trace("[{}] ignoring non periodic step execution from step transition [{}]", (Object)index, (Object)currentStep.getKey());
        }
    }

    private void onErrorMaybeRetryFailedStep(final String policy, IndexMetadata indexMetadata) {
        final String index = indexMetadata.getIndex().getName();
        LifecycleExecutionState lifecycleState = LifecycleExecutionState.fromIndexMetadata((IndexMetadata)indexMetadata);
        final Step failedStep = this.stepRegistry.getStep(indexMetadata, new Step.StepKey(lifecycleState.getPhase(), lifecycleState.getAction(), lifecycleState.getFailedStep()));
        if (failedStep == null) {
            logger.warn("failed step [{}] for index [{}] is not part of policy [{}] anymore, or it is invalid. skipping execution", (Object)lifecycleState.getFailedStep(), (Object)index, (Object)policy);
            return;
        }
        if (lifecycleState.isAutoRetryableError() != null && lifecycleState.isAutoRetryableError().booleanValue()) {
            int currentRetryAttempt = lifecycleState.getFailedStepRetryCount() == null ? 1 : 1 + lifecycleState.getFailedStepRetryCount();
            logger.info("policy [{}] for index [{}] on an error step due to a transient error, moving back to the failed step [{}] for execution. retry attempt [{}]", (Object)policy, (Object)index, (Object)lifecycleState.getFailedStep(), (Object)currentRetryAttempt);
            this.clusterService.submitStateUpdateTask(String.format(Locale.ROOT, "ilm-retry-failed-step {policy [%s], index [%s], failedStep [%s]}", policy, index, failedStep.getKey()), (ClusterStateTaskConfig)new ClusterStateUpdateTask(TimeValue.MAX_VALUE){

                public ClusterState execute(ClusterState currentState) {
                    return IndexLifecycleTransition.moveClusterStateToPreviouslyFailedStep(currentState, index, IndexLifecycleRunner.this.nowSupplier, IndexLifecycleRunner.this.stepRegistry, true);
                }

                public void onFailure(String source, Exception e) {
                    logger.error((Message)new ParameterizedMessage("retry execution of step [{}] for index [{}] failed", (Object)failedStep.getKey().getName(), (Object)index), (Throwable)e);
                }

                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    if (!oldState.equals(newState)) {
                        IndexMetadata newIndexMeta = newState.metadata().index(index);
                        Step indexMetaCurrentStep = IndexLifecycleRunner.getCurrentStep(IndexLifecycleRunner.this.stepRegistry, policy, newIndexMeta);
                        Step.StepKey stepKey = indexMetaCurrentStep.getKey();
                        if (stepKey != null && stepKey != TerminalPolicyStep.KEY && newIndexMeta != null) {
                            logger.trace("policy [{}] for index [{}] was moved back on the failed step for as part of an automatic retry. Attempting to execute the failed step [{}] if it's an async action", (Object)policy, (Object)index, (Object)stepKey);
                            IndexLifecycleRunner.this.maybeRunAsyncAction(newState, newIndexMeta, policy, stepKey);
                        }
                    }
                }
            });
        } else {
            logger.debug("policy [{}] for index [{}] on an error step after a terminal error, skipping execution", (Object)policy, (Object)index);
        }
    }

    void maybeRunAsyncAction(ClusterState currentState, final IndexMetadata indexMetadata, final String policy, Step.StepKey expectedStepKey) {
        Step currentStep;
        final String index = indexMetadata.getIndex().getName();
        LifecycleExecutionState lifecycleState = LifecycleExecutionState.fromIndexMetadata((IndexMetadata)indexMetadata);
        try {
            currentStep = IndexLifecycleRunner.getCurrentStep(this.stepRegistry, policy, indexMetadata);
        }
        catch (Exception e) {
            this.markPolicyRetrievalError(policy, indexMetadata.getIndex(), lifecycleState, e);
            return;
        }
        if (currentStep == null) {
            Step.StepKey currentStepKey = LifecycleExecutionState.getCurrentStepKey((LifecycleExecutionState)lifecycleState);
            if (TerminalPolicyStep.KEY.equals((Object)currentStepKey)) {
                return;
            }
            logger.warn("current step [{}] for index [{}] with policy [{}] is not recognized", (Object)currentStepKey, (Object)index, (Object)policy);
            return;
        }
        logger.trace("[{}] maybe running async action step ({}) with current step {}", (Object)index, (Object)currentStep.getClass().getSimpleName(), (Object)currentStep.getKey());
        if (!currentStep.getKey().equals((Object)expectedStepKey)) {
            throw new IllegalStateException("expected index [" + indexMetadata.getIndex().getName() + "] with policy [" + policy + "] to have current step consistent with provided step key (" + expectedStepKey + ") but it was " + currentStep.getKey());
        }
        if (currentStep instanceof AsyncActionStep) {
            logger.debug("[{}] running policy with async action step [{}]", (Object)index, (Object)currentStep.getKey());
            ((AsyncActionStep)currentStep).performAction(indexMetadata, currentState, new ClusterStateObserver(this.clusterService, null, logger, this.threadPool.getThreadContext()), (ActionListener)new ActionListener<Boolean>(){

                public void onResponse(Boolean complete) {
                    logger.trace("cs-change-async-action-callback, [{}], current-step: {}", (Object)index, (Object)currentStep.getKey());
                    if (complete.booleanValue()) {
                        if (((AsyncActionStep)currentStep).indexSurvives()) {
                            IndexLifecycleRunner.this.moveToStep(indexMetadata.getIndex(), policy, currentStep.getKey(), currentStep.getNextStepKey());
                        } else {
                            IndexLifecycleRunner.this.registerDeleteOperation(indexMetadata);
                        }
                    } else {
                        IndexLifecycleRunner.this.moveToErrorStep(indexMetadata.getIndex(), policy, currentStep.getKey(), new IllegalStateException("unknown exception for step " + currentStep.getKey() + " in policy " + policy));
                    }
                }

                public void onFailure(Exception e) {
                    IndexLifecycleRunner.this.moveToErrorStep(indexMetadata.getIndex(), policy, currentStep.getKey(), e);
                }
            });
        } else {
            logger.trace("[{}] ignoring non async action step execution from step transition [{}]", (Object)index, (Object)currentStep.getKey());
        }
    }

    void runPolicyAfterStateChange(String policy, IndexMetadata indexMetadata) {
        Step currentStep;
        String index = indexMetadata.getIndex().getName();
        LifecycleExecutionState lifecycleState = LifecycleExecutionState.fromIndexMetadata((IndexMetadata)indexMetadata);
        try {
            currentStep = IndexLifecycleRunner.getCurrentStep(this.stepRegistry, policy, indexMetadata);
        }
        catch (Exception e) {
            this.markPolicyRetrievalError(policy, indexMetadata.getIndex(), lifecycleState, e);
            return;
        }
        if (currentStep == null) {
            if (!this.stepRegistry.policyExists(policy)) {
                this.markPolicyDoesNotExist(policy, indexMetadata.getIndex(), lifecycleState);
                return;
            }
            Step.StepKey currentStepKey = LifecycleExecutionState.getCurrentStepKey((LifecycleExecutionState)lifecycleState);
            if (TerminalPolicyStep.KEY.equals((Object)currentStepKey)) {
                return;
            }
            logger.error("current step [{}] for index [{}] with policy [{}] is not recognized", (Object)currentStepKey, (Object)index, (Object)policy);
            return;
        }
        if (currentStep instanceof TerminalPolicyStep) {
            logger.debug("policy [{}] for index [{}] complete, skipping execution", (Object)policy, (Object)index);
            return;
        }
        if (currentStep instanceof ErrorStep) {
            logger.debug("policy [{}] for index [{}] on an error step, skipping execution", (Object)policy, (Object)index);
            return;
        }
        logger.trace("[{}] maybe running step ({}) after state change: {}", (Object)index, (Object)currentStep.getClass().getSimpleName(), (Object)currentStep.getKey());
        if (currentStep instanceof PhaseCompleteStep) {
            if (currentStep.getNextStepKey() == null) {
                logger.debug("[{}] stopping in the current phase ({}) as there are no more steps in the policy", (Object)index, (Object)currentStep.getKey().getPhase());
                return;
            }
            if (this.isReadyToTransitionToThisPhase(policy, indexMetadata, currentStep.getNextStepKey().getPhase())) {
                this.moveToStep(indexMetadata.getIndex(), policy, currentStep.getKey(), currentStep.getNextStepKey());
            }
        } else if (currentStep instanceof ClusterStateActionStep || currentStep instanceof ClusterStateWaitStep) {
            logger.debug("[{}] running policy with current-step [{}]", (Object)indexMetadata.getIndex().getName(), (Object)currentStep.getKey());
            this.clusterService.submitStateUpdateTask(String.format(Locale.ROOT, "ilm-execute-cluster-state-steps [%s]", currentStep), (ClusterStateTaskConfig)new ExecuteStepsUpdateTask(policy, indexMetadata.getIndex(), currentStep, this.stepRegistry, this, this.nowSupplier));
        } else {
            logger.trace("[{}] ignoring step execution from cluster state change event [{}]", (Object)index, (Object)currentStep.getKey());
        }
    }

    private void moveToStep(Index index, String policy, Step.StepKey currentStepKey, Step.StepKey newStepKey) {
        logger.debug("[{}] moving to step [{}] {} -> {}", (Object)index.getName(), (Object)policy, (Object)currentStepKey, (Object)newStepKey);
        this.clusterService.submitStateUpdateTask(String.format(Locale.ROOT, "ilm-move-to-step {policy [%s], index [%s], currentStep [%s], nextStep [%s]}", policy, index.getName(), currentStepKey, newStepKey), (ClusterStateTaskConfig)new MoveToNextStepUpdateTask(index, policy, currentStepKey, newStepKey, this.nowSupplier, this.stepRegistry, clusterState -> {
            IndexMetadata indexMetadata = clusterState.metadata().index(index);
            this.registerSuccessfulOperation(indexMetadata);
            if (newStepKey != null && newStepKey != TerminalPolicyStep.KEY && indexMetadata != null) {
                this.maybeRunAsyncAction((ClusterState)clusterState, indexMetadata, policy, newStepKey);
            }
        }));
    }

    private void moveToErrorStep(Index index, String policy, Step.StepKey currentStepKey, Exception e) {
        logger.error((Message)new ParameterizedMessage("policy [{}] for index [{}] failed on step [{}]. Moving to ERROR step", new Object[]{policy, index.getName(), currentStepKey}), (Throwable)e);
        this.clusterService.submitStateUpdateTask(String.format(Locale.ROOT, "ilm-move-to-error-step {policy [%s], index [%s], currentStep [%s]}", policy, index.getName(), currentStepKey), (ClusterStateTaskConfig)new MoveToErrorStepUpdateTask(index, policy, currentStepKey, e, this.nowSupplier, this.stepRegistry::getStep, clusterState -> {
            IndexMetadata indexMetadata = clusterState.metadata().index(index);
            this.registerFailedOperation(indexMetadata, e);
        }));
    }

    private void setStepInfo(Index index, String policy, @Nullable Step.StepKey currentStepKey, ToXContentObject stepInfo) {
        this.clusterService.submitStateUpdateTask(String.format(Locale.ROOT, "ilm-set-step-info {policy [%s], index [%s], currentStep [%s]}", policy, index.getName(), currentStepKey), (ClusterStateTaskConfig)new SetStepInfoUpdateTask(index, policy, currentStepKey, stepInfo));
    }

    private void markPolicyDoesNotExist(String policyName, Index index, LifecycleExecutionState executionState) {
        this.markPolicyRetrievalError(policyName, index, executionState, new IllegalArgumentException("policy [" + policyName + "] does not exist"));
    }

    private void markPolicyRetrievalError(String policyName, Index index, LifecycleExecutionState executionState, Exception e) {
        logger.debug((Message)new ParameterizedMessage("unable to retrieve policy [{}] for index [{}], recording this in step_info for this index", (Object)policyName, (Object)index.getName()), (Throwable)e);
        this.setStepInfo(index, policyName, LifecycleExecutionState.getCurrentStepKey((LifecycleExecutionState)executionState), new SetStepInfoUpdateTask.ExceptionWrapper(e));
    }

    void registerSuccessfulOperation(IndexMetadata indexMetadata) {
        if (indexMetadata == null) {
            return;
        }
        Long origination = IndexLifecycleRunner.calculateOriginationMillis(indexMetadata);
        this.ilmHistoryStore.putAsync(ILMHistoryItem.success(indexMetadata.getIndex().getName(), (String)LifecycleSettings.LIFECYCLE_NAME_SETTING.get(indexMetadata.getSettings()), this.nowSupplier.getAsLong(), origination == null ? null : Long.valueOf(this.nowSupplier.getAsLong() - origination), LifecycleExecutionState.fromIndexMetadata((IndexMetadata)indexMetadata)));
    }

    void registerDeleteOperation(IndexMetadata metadataBeforeDeletion) {
        if (metadataBeforeDeletion == null) {
            throw new IllegalStateException("cannot register deletion of an index that did not previously exist");
        }
        Long origination = IndexLifecycleRunner.calculateOriginationMillis(metadataBeforeDeletion);
        this.ilmHistoryStore.putAsync(ILMHistoryItem.success(metadataBeforeDeletion.getIndex().getName(), (String)LifecycleSettings.LIFECYCLE_NAME_SETTING.get(metadataBeforeDeletion.getSettings()), this.nowSupplier.getAsLong(), origination == null ? null : Long.valueOf(this.nowSupplier.getAsLong() - origination), LifecycleExecutionState.builder((LifecycleExecutionState)LifecycleExecutionState.fromIndexMetadata((IndexMetadata)metadataBeforeDeletion)).setStep("complete").build()));
    }

    void registerFailedOperation(IndexMetadata indexMetadata, Exception failure) {
        if (indexMetadata == null) {
            return;
        }
        Long origination = IndexLifecycleRunner.calculateOriginationMillis(indexMetadata);
        this.ilmHistoryStore.putAsync(ILMHistoryItem.failure(indexMetadata.getIndex().getName(), (String)LifecycleSettings.LIFECYCLE_NAME_SETTING.get(indexMetadata.getSettings()), this.nowSupplier.getAsLong(), origination == null ? null : Long.valueOf(this.nowSupplier.getAsLong() - origination), LifecycleExecutionState.fromIndexMetadata((IndexMetadata)indexMetadata), failure));
    }
}

