/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.versionfield;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.FilteredTermsEnum;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.ByteRunAutomaton;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.SortedSetOrdinalsIndexFieldData;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.TermBasedFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.query.support.QueryParsers;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.xpack.versionfield.VersionEncoder;
import org.elasticsearch.xpack.versionfield.VersionFieldWildcardQuery;
import org.elasticsearch.xpack.versionfield.VersionScriptDocValues;

public class VersionStringFieldMapper
extends FieldMapper {
    private static final byte[] MIN_VALUE = new byte[16];
    private static final byte[] MAX_VALUE = new byte[16];
    public static final String CONTENT_TYPE = "version";
    public static final FieldMapper.TypeParser PARSER;
    private final FieldType fieldType;
    public static DocValueFormat VERSION_DOCVALUE;

    private VersionStringFieldMapper(String simpleName, FieldType fieldType, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, mappedFieldType, Lucene.KEYWORD_ANALYZER, multiFields, copyTo);
        this.fieldType = fieldType;
    }

    public VersionStringFieldType fieldType() {
        return (VersionStringFieldType)super.fieldType();
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    protected void parseCreateField(ParseContext context) throws IOException {
        XContentParser parser = context.parser();
        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
            return;
        }
        String versionString = parser.textOrNull();
        if (versionString == null) {
            return;
        }
        VersionEncoder.EncodedVersion encoding = VersionEncoder.encodeVersion(versionString);
        BytesRef encodedVersion = encoding.bytesRef;
        context.doc().add((IndexableField)new Field(this.fieldType().name(), encodedVersion, (IndexableFieldType)this.fieldType));
        context.doc().add((IndexableField)new SortedSetDocValuesField(this.fieldType().name(), encodedVersion));
    }

    public Iterator<Mapper> iterator() {
        ArrayList subIterators = new ArrayList();
        Iterator concat = Iterators.concat((Iterator[])new Iterator[]{super.iterator(), subIterators.iterator()});
        return concat;
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName()).init(this);
    }

    static {
        Arrays.fill(MIN_VALUE, (byte)0);
        Arrays.fill(MAX_VALUE, (byte)-1);
        PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n));
        VERSION_DOCVALUE = new DocValueFormat(){

            public String getWriteableName() {
                return VersionStringFieldMapper.CONTENT_TYPE;
            }

            public void writeTo(StreamOutput out) {
            }

            public String format(BytesRef value) {
                return VersionEncoder.decodeVersion(value);
            }

            public BytesRef parseBytesRef(String value) {
                return VersionEncoder.encodeVersion((String)value).bytesRef;
            }

            public String toString() {
                return this.getWriteableName();
            }
        };
    }

    public static final class VersionStringFieldType
    extends TermBasedFieldType {
        private VersionStringFieldType(String name, FieldType fieldType, Map<String, String> meta) {
            super(name, true, false, true, new TextSearchInfo(fieldType, null, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER), meta);
        }

        public String typeName() {
            return VersionStringFieldMapper.CONTENT_TYPE;
        }

        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            return SourceValueFetcher.toString((String)this.name(), (SearchExecutionContext)context, (String)format);
        }

        public Query existsQuery(SearchExecutionContext context) {
            return new DocValuesFieldExistsQuery(this.name());
        }

        public Query prefixQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, SearchExecutionContext context) {
            return this.wildcardQuery(value + "*", method, caseInsensitive, context);
        }

        public Query regexpQuery(String value, int syntaxFlags, int matchFlags, int maxDeterminizedStates, @Nullable MultiTermQuery.RewriteMethod method, SearchExecutionContext context) {
            if (!context.allowExpensiveQueries()) {
                throw new ElasticsearchException("[regexp] queries cannot be executed when '" + SearchService.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false.", new Object[0]);
            }
            RegexpQuery query = new RegexpQuery(new Term(this.name(), new BytesRef((CharSequence)value)), syntaxFlags, matchFlags, maxDeterminizedStates){

                protected TermsEnum getTermsEnum(Terms terms, AttributeSource atts) throws IOException {
                    return new FilteredTermsEnum(terms.iterator(), false){

                        protected FilteredTermsEnum.AcceptStatus accept(BytesRef term) throws IOException {
                            byte[] decoded = VersionEncoder.decodeVersion(term).getBytes(StandardCharsets.UTF_8);
                            boolean accepted = (this).compiled.runAutomaton.run(decoded, 0, decoded.length);
                            if (accepted) {
                                return FilteredTermsEnum.AcceptStatus.YES;
                            }
                            return FilteredTermsEnum.AcceptStatus.NO;
                        }
                    };
                }
            };
            if (method != null) {
                query.setRewriteMethod(method);
            }
            return query;
        }

        public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions, SearchExecutionContext context) {
            if (!context.allowExpensiveQueries()) {
                throw new ElasticsearchException("[fuzzy] queries cannot be executed when '" + SearchService.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false.", new Object[0]);
            }
            return new FuzzyQuery(new Term(this.name(), (BytesRef)value), fuzziness.asDistance(BytesRefs.toString((Object)value)), prefixLength, maxExpansions, transpositions){

                protected TermsEnum getTermsEnum(Terms terms, AttributeSource atts) throws IOException {
                    final ByteRunAutomaton runAutomaton = this.getAutomata().runAutomaton;
                    return new FilteredTermsEnum(terms.iterator(), false){

                        protected FilteredTermsEnum.AcceptStatus accept(BytesRef term) throws IOException {
                            byte[] decoded = VersionEncoder.decodeVersion(term).getBytes(StandardCharsets.UTF_8);
                            boolean accepted = runAutomaton.run(decoded, 0, decoded.length);
                            if (accepted) {
                                return FilteredTermsEnum.AcceptStatus.YES;
                            }
                            return FilteredTermsEnum.AcceptStatus.NO;
                        }
                    };
                }
            };
        }

        public Query wildcardQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, SearchExecutionContext context) {
            if (!context.allowExpensiveQueries()) {
                throw new ElasticsearchException("[wildcard] queries cannot be executed when '" + SearchService.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false.", new Object[0]);
            }
            VersionFieldWildcardQuery query = new VersionFieldWildcardQuery(new Term(this.name(), value), caseInsensitive);
            QueryParsers.setRewriteMethod((MultiTermQuery)query, (MultiTermQuery.RewriteMethod)method);
            return query;
        }

        protected BytesRef indexedValueForSearch(Object value) {
            String valueAsString;
            if (value instanceof String) {
                valueAsString = (String)value;
            } else if (value instanceof BytesRef) {
                valueAsString = ((BytesRef)value).utf8ToString();
            } else {
                throw new IllegalArgumentException("Illegal value type: " + value.getClass() + ", value: " + value);
            }
            return VersionEncoder.encodeVersion((String)valueAsString).bytesRef;
        }

        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            return new SortedSetOrdinalsIndexFieldData.Builder(this.name(), VersionScriptDocValues::new, (ValuesSourceType)CoreValuesSourceType.KEYWORD);
        }

        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            return VERSION_DOCVALUE.format((BytesRef)value);
        }

        public DocValueFormat docValueFormat(@Nullable String format, ZoneId timeZone) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom formats");
            }
            if (timeZone != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom time zones");
            }
            return VERSION_DOCVALUE;
        }

        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, SearchExecutionContext context) {
            BytesRef lower = lowerTerm == null ? null : this.indexedValueForSearch(lowerTerm);
            BytesRef upper = upperTerm == null ? null : this.indexedValueForSearch(upperTerm);
            return new TermRangeQuery(this.name(), lower, upper, includeLower, includeUpper);
        }
    }

    static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();

        Builder(String name) {
            super(name);
        }

        private VersionStringFieldType buildFieldType(ContentPath contentPath, FieldType fieldtype) {
            return new VersionStringFieldType(this.buildFullName(contentPath), fieldtype, (Map)this.meta.getValue());
        }

        public VersionStringFieldMapper build(ContentPath contentPath) {
            FieldType fieldtype = new FieldType((IndexableFieldType)Defaults.FIELD_TYPE);
            return new VersionStringFieldMapper(this.name, fieldtype, (MappedFieldType)this.buildFieldType(contentPath, fieldtype), this.multiFieldsBuilder.build((Mapper.Builder)this, contentPath), this.copyTo.build());
        }

        protected List<FieldMapper.Parameter<?>> getParameters() {
            return org.elasticsearch.core.List.of(this.meta);
        }
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.freeze();
        }
    }
}

