/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.shutdown;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.metadata.SingleNodeShutdownMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.XContentParser;

public class PutShutdownNodeAction
extends ActionType<AcknowledgedResponse> {
    public static final PutShutdownNodeAction INSTANCE = new PutShutdownNodeAction();
    public static final String NAME = "cluster:admin/shutdown/create";

    public PutShutdownNodeAction() {
        super(NAME, AcknowledgedResponse::readFrom);
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private final String nodeId;
        private final SingleNodeShutdownMetadata.Type type;
        private final String reason;
        private static final ParseField TYPE_FIELD = new ParseField("type", new String[0]);
        public static final ParseField REASON_FIELD = new ParseField("reason", new String[0]);
        private static final ConstructingObjectParser<Request, String> PARSER = new ConstructingObjectParser("put_node_shutdown_request", false, (a, nodeId) -> new Request((String)nodeId, SingleNodeShutdownMetadata.Type.parse((String)((String)a[0])), (String)a[1]));

        public static Request parseRequest(String nodeId, XContentParser parser) {
            return (Request)((Object)PARSER.apply(parser, (Object)nodeId));
        }

        public Request(String nodeId, SingleNodeShutdownMetadata.Type type, String reason) {
            this.nodeId = nodeId;
            this.type = type;
            this.reason = reason;
        }

        public Request(StreamInput in) throws IOException {
            this.nodeId = in.readString();
            this.type = (SingleNodeShutdownMetadata.Type)in.readEnum(SingleNodeShutdownMetadata.Type.class);
            this.reason = in.readString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.nodeId);
            out.writeEnum((Enum)this.type);
            out.writeString(this.reason);
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public SingleNodeShutdownMetadata.Type getType() {
            return this.type;
        }

        public String getReason() {
            return this.reason;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException arve = new ActionRequestValidationException();
            if (!Strings.hasText((String)this.nodeId)) {
                arve.addValidationError("the node id to shutdown is required");
            }
            if (this.type == null) {
                arve.addValidationError("the shutdown type is required");
            }
            if (!Strings.hasText((String)this.nodeId)) {
                arve.addValidationError("the reason for shutdown is required");
            }
            if (!arve.validationErrors().isEmpty()) {
                return arve;
            }
            return null;
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), TYPE_FIELD);
            PARSER.declareString(ConstructingObjectParser.constructorArg(), REASON_FIELD);
        }
    }
}

