/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.vectors;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackFeatureSet;

public class VectorsFeatureSetUsage
extends XPackFeatureSet.Usage {
    private final int numDenseVectorFields;
    private final int numSparseVectorFields;
    private final int avgDenseVectorDims;

    public VectorsFeatureSetUsage(StreamInput input) throws IOException {
        super(input);
        this.numDenseVectorFields = input.readVInt();
        this.numSparseVectorFields = input.readVInt();
        this.avgDenseVectorDims = input.readVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.numDenseVectorFields);
        out.writeVInt(this.numSparseVectorFields);
        out.writeVInt(this.avgDenseVectorDims);
    }

    public VectorsFeatureSetUsage(int numDenseVectorFields, int numSparseVectorFields, int avgDenseVectorDims) {
        super("vectors", true, true);
        this.numDenseVectorFields = numDenseVectorFields;
        this.numSparseVectorFields = numSparseVectorFields;
        this.avgDenseVectorDims = avgDenseVectorDims;
    }

    public Version getMinimalSupportedVersion() {
        return Version.V_7_3_0;
    }

    @Override
    protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.innerXContent(builder, params);
        builder.field("dense_vector_fields_count", this.numDenseVectorFields);
        builder.field("sparse_vector_fields_count", this.numSparseVectorFields);
        builder.field("dense_vector_dims_avg_count", this.avgDenseVectorDims);
    }

    public int numDenseVectorFields() {
        return this.numDenseVectorFields;
    }

    public int numSparseVectorFields() {
        return this.numSparseVectorFields;
    }

    public int avgDenseVectorDims() {
        return this.avgDenseVectorDims;
    }

    public int hashCode() {
        return Objects.hash(this.available, this.enabled, this.numDenseVectorFields, this.numSparseVectorFields, this.avgDenseVectorDims);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof VectorsFeatureSetUsage)) {
            return false;
        }
        VectorsFeatureSetUsage other = (VectorsFeatureSetUsage)obj;
        return this.available == other.available && this.enabled == other.enabled && this.numDenseVectorFields == other.numDenseVectorFields && this.numSparseVectorFields == other.numSparseVectorFields && this.avgDenseVectorDims == other.avgDenseVectorDims;
    }
}

