/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.termsenum.action;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.core.termsenum.action.TermsEnumRequest;

public class NodeTermsEnumRequest
extends TransportRequest
implements IndicesRequest {
    private String field;
    private String string;
    private String searchAfter;
    private long taskStartedTimeMillis;
    private long nodeStartedTimeMillis;
    private boolean caseInsensitive;
    private int size;
    private long timeout;
    private final QueryBuilder indexFilter;
    private Set<ShardId> shardIds;
    private String nodeId;

    public NodeTermsEnumRequest(String nodeId, Set<ShardId> shardIds, TermsEnumRequest request, long taskStartTimeMillis) {
        this.field = request.field();
        this.string = request.string();
        this.searchAfter = request.searchAfter();
        this.caseInsensitive = request.caseInsensitive();
        this.size = request.size();
        this.timeout = request.timeout().getMillis();
        this.taskStartedTimeMillis = taskStartTimeMillis;
        this.indexFilter = request.indexFilter();
        this.nodeId = nodeId;
        this.shardIds = shardIds;
    }

    public NodeTermsEnumRequest(StreamInput in) throws IOException {
        super(in);
        this.field = in.readString();
        this.string = in.readOptionalString();
        this.searchAfter = in.readOptionalString();
        this.caseInsensitive = in.readBoolean();
        this.size = in.readVInt();
        this.timeout = in.readVLong();
        this.taskStartedTimeMillis = in.readVLong();
        this.indexFilter = (QueryBuilder)in.readOptionalNamedWriteable(QueryBuilder.class);
        this.nodeId = in.readString();
        int numShards = in.readVInt();
        this.shardIds = new HashSet<ShardId>(numShards);
        for (int i = 0; i < numShards; ++i) {
            this.shardIds.add(new ShardId(in));
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.field);
        out.writeOptionalString(this.string);
        out.writeOptionalString(this.searchAfter);
        out.writeBoolean(this.caseInsensitive);
        out.writeVInt(this.size);
        long timeSpentSoFarInCoordinatingNode = System.currentTimeMillis() - this.taskStartedTimeMillis;
        long remainingTimeForShardToUse = this.timeout - timeSpentSoFarInCoordinatingNode;
        out.writeVLong(remainingTimeForShardToUse);
        out.writeVLong(this.taskStartedTimeMillis);
        out.writeOptionalNamedWriteable((NamedWriteable)this.indexFilter);
        out.writeString(this.nodeId);
        out.writeVInt(this.shardIds.size());
        for (ShardId shardId : this.shardIds) {
            shardId.writeTo(out);
        }
    }

    public String field() {
        return this.field;
    }

    @Nullable
    public String string() {
        return this.string;
    }

    @Nullable
    public String searchAfter() {
        return this.searchAfter;
    }

    public long taskStartedTimeMillis() {
        return this.taskStartedTimeMillis;
    }

    long nodeStartedTimeMillis() {
        if (this.nodeStartedTimeMillis == 0L) {
            this.nodeStartedTimeMillis = System.currentTimeMillis();
        }
        return this.nodeStartedTimeMillis;
    }

    public void startTimerOnDataNode() {
        this.nodeStartedTimeMillis = System.currentTimeMillis();
    }

    public Set<ShardId> shardIds() {
        return Collections.unmodifiableSet(this.shardIds);
    }

    public boolean caseInsensitive() {
        return this.caseInsensitive;
    }

    public int size() {
        return this.size;
    }

    public long timeout() {
        return this.timeout;
    }

    public String nodeId() {
        return this.nodeId;
    }

    public QueryBuilder indexFilter() {
        return this.indexFilter;
    }

    public String[] indices() {
        HashSet<String> indicesNames = new HashSet<String>();
        for (ShardId shardId : this.shardIds) {
            indicesNames.add(shardId.getIndexName());
        }
        return indicesNames.toArray(new String[0]);
    }

    public IndicesOptions indicesOptions() {
        return null;
    }

    public boolean remove(ShardId shardId) {
        return this.shardIds.remove(shardId);
    }
}

