/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.privilege;

import java.util.Collections;
import java.util.function.Predicate;
import org.elasticsearch.transport.TransportActionProxy;
import org.elasticsearch.xpack.core.security.authz.privilege.Privilege;
import org.elasticsearch.xpack.core.security.support.StringMatcher;

public final class SystemPrivilege
extends Privilege {
    public static SystemPrivilege INSTANCE = new SystemPrivilege();
    private static final Predicate<String> ALLOWED_ACTIONS = StringMatcher.of("internal:*", "indices:monitor/*", "cluster:monitor/*", "cluster:admin/bootstrap/*", "cluster:admin/reroute", "indices:admin/mapping/put", "indices:admin/template/put", "indices:admin/template/delete", "indices:admin/seq_no/global_checkpoint_sync*", "indices:admin/seq_no/retention_lease_sync*", "indices:admin/seq_no/retention_lease_background_sync*", "indices:admin/seq_no/add_retention_lease*", "indices:admin/seq_no/remove_retention_lease*", "indices:admin/seq_no/renew_retention_lease*", "indices:admin/settings/update", "cluster:admin/persistent/completion");
    private static final Predicate<String> PREDICATE = action -> {
        if (TransportActionProxy.isProxyAction((String)action)) {
            return ALLOWED_ACTIONS.test(TransportActionProxy.unwrapAction((String)action));
        }
        return ALLOWED_ACTIONS.test((String)action);
    };

    private SystemPrivilege() {
        super(Collections.singleton("internal"), new String[0]);
    }

    @Override
    public Predicate<String> predicate() {
        return PREDICATE;
    }
}

