/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.oidc;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.http.HttpHost;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.support.DelegatedAuthorizationSettings;
import org.elasticsearch.xpack.core.ssl.SSLConfigurationSettings;

public class OpenIdConnectRealmSettings {
    public static final List<String> SUPPORTED_SIGNATURE_ALGORITHMS = org.elasticsearch.core.List.of((Object[])new String[]{"HS256", "HS384", "HS512", "RS256", "RS384", "RS512", "ES256", "ES384", "ES512", "PS256", "PS384", "PS512"});
    private static final List<String> RESPONSE_TYPES = org.elasticsearch.core.List.of((Object[])new String[]{"code", "id_token", "id_token token"});
    public static final List<String> CLIENT_AUTH_METHODS = org.elasticsearch.core.List.of((Object[])new String[]{"client_secret_basic", "client_secret_post", "client_secret_jwt"});
    public static final List<String> SUPPORTED_CLIENT_AUTH_JWT_ALGORITHMS = org.elasticsearch.core.List.of((Object[])new String[]{"HS256", "HS384", "HS512"});
    public static final String TYPE = "oidc";
    public static final Setting.AffixSetting<String> RP_CLIENT_ID = RealmSettings.simpleString("oidc", "rp.client_id", Setting.Property.NodeScope);
    public static final Setting.AffixSetting<SecureString> RP_CLIENT_SECRET = RealmSettings.secureString("oidc", "rp.client_secret");
    public static final Setting.AffixSetting<String> RP_REDIRECT_URI = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("oidc"), (String)"rp.redirect_uri", key -> Setting.simpleString((String)key, v -> {
        try {
            new URI((String)v);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid value [" + v + "] for [" + key + "]. Not a valid URI.", e);
        }
    }, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<String> RP_POST_LOGOUT_REDIRECT_URI = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("oidc"), (String)"rp.post_logout_redirect_uri", key -> Setting.simpleString((String)key, v -> {
        try {
            new URI((String)v);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid value [" + v + "] for [" + key + "]. Not a valid URI.", e);
        }
    }, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<String> RP_RESPONSE_TYPE = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("oidc"), (String)"rp.response_type", key -> Setting.simpleString((String)key, v -> {
        if (!RESPONSE_TYPES.contains(v)) {
            throw new IllegalArgumentException("Invalid value [" + v + "] for [" + key + "]. Allowed values are " + RESPONSE_TYPES + "");
        }
    }, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<String> RP_SIGNATURE_ALGORITHM = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("oidc"), (String)"rp.signature_algorithm", key -> new Setting(key, "RS256", Function.identity(), v -> {
        if (!SUPPORTED_SIGNATURE_ALGORITHMS.contains(v)) {
            throw new IllegalArgumentException("Invalid value [" + v + "] for [" + key + "]. Allowed values are " + SUPPORTED_SIGNATURE_ALGORITHMS + "}]");
        }
    }, new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<List<String>> RP_REQUESTED_SCOPES = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("oidc"), (String)"rp.requested_scopes", key -> Setting.listSetting((String)key, Collections.singletonList("openid"), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<String> RP_CLIENT_AUTH_METHOD = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("oidc"), (String)"rp.client_auth_method", key -> new Setting(key, "client_secret_basic", Function.identity(), v -> {
        if (!CLIENT_AUTH_METHODS.contains(v)) {
            throw new IllegalArgumentException("Invalid value [" + v + "] for [" + key + "]. Allowed values are " + CLIENT_AUTH_METHODS + "}]");
        }
    }, new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<String> RP_CLIENT_AUTH_JWT_SIGNATURE_ALGORITHM = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("oidc"), (String)"rp.client_auth_jwt_signature_algorithm", key -> new Setting(key, "HS384", Function.identity(), v -> {
        if (!SUPPORTED_CLIENT_AUTH_JWT_ALGORITHMS.contains(v)) {
            throw new IllegalArgumentException("Invalid value [" + v + "] for [" + key + "]. Allowed values are " + SUPPORTED_CLIENT_AUTH_JWT_ALGORITHMS + "}]");
        }
    }, new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<String> OP_AUTHORIZATION_ENDPOINT = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("oidc"), (String)"op.authorization_endpoint", key -> Setting.simpleString((String)key, v -> {
        try {
            new URI((String)v);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid value [" + v + "] for [" + key + "]. Not a valid URI.", e);
        }
    }, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<String> OP_TOKEN_ENDPOINT = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("oidc"), (String)"op.token_endpoint", key -> Setting.simpleString((String)key, v -> {
        try {
            new URI((String)v);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid value [" + v + "] for [" + key + "]. Not a valid URI.", e);
        }
    }, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<String> OP_USERINFO_ENDPOINT = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("oidc"), (String)"op.userinfo_endpoint", key -> Setting.simpleString((String)key, v -> {
        try {
            new URI((String)v);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid value [" + v + "] for [" + key + "]. Not a valid URI.", e);
        }
    }, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<String> OP_ENDSESSION_ENDPOINT = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("oidc"), (String)"op.endsession_endpoint", key -> Setting.simpleString((String)key, v -> {
        try {
            new URI((String)v);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid value [" + v + "] for [" + key + "]. Not a valid URI.", e);
        }
    }, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<String> OP_ISSUER = RealmSettings.simpleString("oidc", "op.issuer", Setting.Property.NodeScope);
    public static final Setting.AffixSetting<String> OP_JWKSET_PATH = RealmSettings.simpleString("oidc", "op.jwkset_path", Setting.Property.NodeScope);
    public static final Setting.AffixSetting<TimeValue> ALLOWED_CLOCK_SKEW = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("oidc"), (String)"allowed_clock_skew", key -> Setting.timeSetting((String)key, (TimeValue)TimeValue.timeValueSeconds((long)60L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<Boolean> POPULATE_USER_METADATA = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("oidc"), (String)"populate_user_metadata", key -> Setting.boolSetting((String)key, (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    private static final TimeValue DEFAULT_TIMEOUT = TimeValue.timeValueSeconds((long)5L);
    public static final Setting.AffixSetting<TimeValue> HTTP_CONNECT_TIMEOUT = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("oidc"), (String)"http.connect_timeout", key -> Setting.timeSetting((String)key, (TimeValue)DEFAULT_TIMEOUT, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<TimeValue> HTTP_CONNECTION_READ_TIMEOUT = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("oidc"), (String)"http.connection_read_timeout", key -> Setting.timeSetting((String)key, (TimeValue)DEFAULT_TIMEOUT, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<TimeValue> HTTP_SOCKET_TIMEOUT = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("oidc"), (String)"http.socket_timeout", key -> Setting.timeSetting((String)key, (TimeValue)DEFAULT_TIMEOUT, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<Integer> HTTP_MAX_CONNECTIONS = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("oidc"), (String)"http.max_connections", key -> Setting.intSetting((String)key, (int)200, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<Integer> HTTP_MAX_ENDPOINT_CONNECTIONS = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("oidc"), (String)"http.max_endpoint_connections", key -> Setting.intSetting((String)key, (int)200, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<String> HTTP_PROXY_HOST = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("oidc"), (String)"http.proxy.host", key -> Setting.simpleString((String)key, (Setting.Validator)new Setting.Validator<String>(){

        public void validate(String value) {
        }

        public void validate(String value, Map<Setting<?>, Object> settings) {
            String namespace = HTTP_PROXY_HOST.getNamespace(HTTP_PROXY_HOST.getConcreteSetting(key));
            Setting portSetting = HTTP_PROXY_PORT.getConcreteSettingForNamespace(namespace);
            Integer port = (Integer)settings.get(portSetting);
            Setting schemeSetting = HTTP_PROXY_SCHEME.getConcreteSettingForNamespace(namespace);
            String scheme = (String)settings.get(schemeSetting);
            try {
                new HttpHost(value, port.intValue(), scheme);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("HTTP host for hostname [" + value + "] (from [" + key + "]), port [" + port + "] (from [" + portSetting.getKey() + "]) and scheme [" + scheme + "] (from ([" + schemeSetting.getKey() + "]) is invalid");
            }
        }

        public Iterator<Setting<?>> settings() {
            String namespace = HTTP_PROXY_HOST.getNamespace(HTTP_PROXY_HOST.getConcreteSetting(key));
            List<Setting> settings = Arrays.asList(HTTP_PROXY_PORT.getConcreteSettingForNamespace(namespace), HTTP_PROXY_SCHEME.getConcreteSettingForNamespace(namespace));
            return settings.iterator();
        }
    }, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<Integer> HTTP_PROXY_PORT = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("oidc"), (String)"http.proxy.port", key -> Setting.intSetting((String)key, (int)80, (int)1, (int)65535, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{() -> HTTP_PROXY_HOST});
    public static final Setting.AffixSetting<String> HTTP_PROXY_SCHEME = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("oidc"), (String)"http.proxy.scheme", key -> Setting.simpleString((String)key, (String)"http", value -> {
        if (!value.equals("http") && !value.equals("https")) {
            throw new IllegalArgumentException("Invalid value [" + value + "] for [" + key + "]. Only `http` or `https` are allowed.");
        }
    }, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final ClaimSetting PRINCIPAL_CLAIM = new ClaimSetting("principal");
    public static final ClaimSetting GROUPS_CLAIM = new ClaimSetting("groups");
    public static final ClaimSetting NAME_CLAIM = new ClaimSetting("name");
    public static final ClaimSetting DN_CLAIM = new ClaimSetting("dn");
    public static final ClaimSetting MAIL_CLAIM = new ClaimSetting("mail");

    private OpenIdConnectRealmSettings() {
    }

    public static Set<Setting.AffixSetting<?>> getSettings() {
        HashSet set = Sets.newHashSet((Object[])new Setting.AffixSetting[]{RP_CLIENT_ID, RP_REDIRECT_URI, RP_RESPONSE_TYPE, RP_REQUESTED_SCOPES, RP_CLIENT_SECRET, RP_SIGNATURE_ALGORITHM, RP_POST_LOGOUT_REDIRECT_URI, RP_CLIENT_AUTH_METHOD, RP_CLIENT_AUTH_JWT_SIGNATURE_ALGORITHM, OP_AUTHORIZATION_ENDPOINT, OP_TOKEN_ENDPOINT, OP_USERINFO_ENDPOINT, OP_ENDSESSION_ENDPOINT, OP_ISSUER, OP_JWKSET_PATH, POPULATE_USER_METADATA, HTTP_CONNECT_TIMEOUT, HTTP_CONNECTION_READ_TIMEOUT, HTTP_SOCKET_TIMEOUT, HTTP_MAX_CONNECTIONS, HTTP_MAX_ENDPOINT_CONNECTIONS, HTTP_PROXY_HOST, HTTP_PROXY_PORT, HTTP_PROXY_SCHEME, ALLOWED_CLOCK_SKEW});
        set.addAll(DelegatedAuthorizationSettings.getSettings(TYPE));
        set.addAll(RealmSettings.getStandardSettings(TYPE));
        set.addAll(SSLConfigurationSettings.getRealmSettings(TYPE));
        set.addAll(PRINCIPAL_CLAIM.settings());
        set.addAll(GROUPS_CLAIM.settings());
        set.addAll(DN_CLAIM.settings());
        set.addAll(NAME_CLAIM.settings());
        set.addAll(MAIL_CLAIM.settings());
        return set;
    }

    public static final class ClaimSetting {
        public static final String CLAIMS_PREFIX = "claims.";
        public static final String CLAIM_PATTERNS_PREFIX = "claim_patterns.";
        private final Setting.AffixSetting<String> claim;
        private final Setting.AffixSetting<String> pattern;

        public ClaimSetting(String name) {
            this.claim = RealmSettings.simpleString(OpenIdConnectRealmSettings.TYPE, CLAIMS_PREFIX + name, Setting.Property.NodeScope);
            this.pattern = RealmSettings.simpleString(OpenIdConnectRealmSettings.TYPE, CLAIM_PATTERNS_PREFIX + name, Setting.Property.NodeScope);
        }

        public Collection<Setting.AffixSetting<?>> settings() {
            return Arrays.asList(this.getClaim(), this.getPattern());
        }

        public String name(RealmConfig config) {
            return this.getClaim().getConcreteSettingForNamespace(config.name()).getKey();
        }

        public Setting.AffixSetting<String> getClaim() {
            return this.claim;
        }

        public Setting.AffixSetting<String> getPattern() {
            return this.pattern;
        }
    }
}

